/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import org.apache.lucene.analysis.ja.dict.JaMorphData;
import org.apache.lucene.analysis.util.CSVUtil;

final class UserMorphData
implements JaMorphData {
    public static final int WORD_COST = -100000;
    public static final int LEFT_ID = 5;
    public static final int RIGHT_ID = 5;
    private final String[] data;

    UserMorphData(String[] data) {
        this.data = data;
    }

    public int getLeftId(int wordId) {
        return 5;
    }

    public int getRightId(int wordId) {
        return 5;
    }

    public int getWordCost(int wordId) {
        return -100000;
    }

    @Override
    public String getReading(int morphId, char[] surface, int off, int len) {
        return this.getFeature(morphId, 0);
    }

    @Override
    public String getPartOfSpeech(int morphId) {
        return this.getFeature(morphId, 1);
    }

    @Override
    public String getBaseForm(int morphId, char[] surface, int off, int len) {
        return null;
    }

    @Override
    public String getPronunciation(int morphId, char[] surface, int off, int len) {
        return null;
    }

    @Override
    public String getInflectionType(int morphId) {
        return null;
    }

    @Override
    public String getInflectionForm(int wordId) {
        return null;
    }

    private String[] getAllFeaturesArray(int wordId) {
        String allFeatures = this.data[wordId - 100000000];
        if (allFeatures == null) {
            return null;
        }
        return allFeatures.split("\u0000");
    }

    private String getFeature(int wordId, int ... fields) {
        String[] allFeatures = this.getAllFeaturesArray(wordId);
        if (allFeatures == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (fields.length == 0) {
            for (String feature : allFeatures) {
                sb.append(CSVUtil.quoteEscape((String)feature)).append(",");
            }
        } else if (fields.length == 1) {
            sb.append(allFeatures[fields[0]]).append(",");
        } else {
            for (int field : fields) {
                sb.append(CSVUtil.quoteEscape((String)allFeatures[field])).append(",");
            }
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

