/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSettingsMergeTieredPolicy
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSettingsMergeTieredPolicy> {
    @Nullable
    private final Double deletesPctAllowed;
    @Nullable
    private final Double expungeDeletesAllowed;
    @Nullable
    private final String floorSegment;
    @Nullable
    private final Integer maxMergeAtOnce;
    @Nullable
    private final String maxMergedSegment;
    @Nullable
    private final Double reclaimDeletesWeight;
    @Nullable
    private final Double segmentsPerTier;
    public static final JsonpDeserializer<IndexSettingsMergeTieredPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsMergeTieredPolicy::setupIndexSettingsMergeTieredPolicyDeserializer);

    private IndexSettingsMergeTieredPolicy(Builder builder) {
        this.deletesPctAllowed = builder.deletesPctAllowed;
        this.expungeDeletesAllowed = builder.expungeDeletesAllowed;
        this.floorSegment = builder.floorSegment;
        this.maxMergeAtOnce = builder.maxMergeAtOnce;
        this.maxMergedSegment = builder.maxMergedSegment;
        this.reclaimDeletesWeight = builder.reclaimDeletesWeight;
        this.segmentsPerTier = builder.segmentsPerTier;
    }

    public static IndexSettingsMergeTieredPolicy of(Function<Builder, ObjectBuilder<IndexSettingsMergeTieredPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Double deletesPctAllowed() {
        return this.deletesPctAllowed;
    }

    @Nullable
    public final Double expungeDeletesAllowed() {
        return this.expungeDeletesAllowed;
    }

    @Nullable
    public final String floorSegment() {
        return this.floorSegment;
    }

    @Nullable
    public final Integer maxMergeAtOnce() {
        return this.maxMergeAtOnce;
    }

    @Nullable
    public final String maxMergedSegment() {
        return this.maxMergedSegment;
    }

    @Nullable
    public final Double reclaimDeletesWeight() {
        return this.reclaimDeletesWeight;
    }

    @Nullable
    public final Double segmentsPerTier() {
        return this.segmentsPerTier;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deletesPctAllowed != null) {
            generator.writeKey("deletes_pct_allowed");
            generator.write(this.deletesPctAllowed.doubleValue());
        }
        if (this.expungeDeletesAllowed != null) {
            generator.writeKey("expunge_deletes_allowed");
            generator.write(this.expungeDeletesAllowed.doubleValue());
        }
        if (this.floorSegment != null) {
            generator.writeKey("floor_segment");
            generator.write(this.floorSegment);
        }
        if (this.maxMergeAtOnce != null) {
            generator.writeKey("max_merge_at_once");
            generator.write(this.maxMergeAtOnce.intValue());
        }
        if (this.maxMergedSegment != null) {
            generator.writeKey("max_merged_segment");
            generator.write(this.maxMergedSegment);
        }
        if (this.reclaimDeletesWeight != null) {
            generator.writeKey("reclaim_deletes_weight");
            generator.write(this.reclaimDeletesWeight.doubleValue());
        }
        if (this.segmentsPerTier != null) {
            generator.writeKey("segments_per_tier");
            generator.write(this.segmentsPerTier.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSettingsMergeTieredPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deletesPctAllowed, JsonpDeserializer.doubleDeserializer(), "deletes_pct_allowed");
        op.add(Builder::expungeDeletesAllowed, JsonpDeserializer.doubleDeserializer(), "expunge_deletes_allowed");
        op.add(Builder::floorSegment, JsonpDeserializer.stringDeserializer(), "floor_segment");
        op.add(Builder::maxMergeAtOnce, JsonpDeserializer.integerDeserializer(), "max_merge_at_once");
        op.add(Builder::maxMergedSegment, JsonpDeserializer.stringDeserializer(), "max_merged_segment");
        op.add(Builder::reclaimDeletesWeight, JsonpDeserializer.doubleDeserializer(), "reclaim_deletes_weight");
        op.add(Builder::segmentsPerTier, JsonpDeserializer.doubleDeserializer(), "segments_per_tier");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.deletesPctAllowed);
        result = 31 * result + Objects.hashCode(this.expungeDeletesAllowed);
        result = 31 * result + Objects.hashCode(this.floorSegment);
        result = 31 * result + Objects.hashCode(this.maxMergeAtOnce);
        result = 31 * result + Objects.hashCode(this.maxMergedSegment);
        result = 31 * result + Objects.hashCode(this.reclaimDeletesWeight);
        result = 31 * result + Objects.hashCode(this.segmentsPerTier);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsMergeTieredPolicy other = (IndexSettingsMergeTieredPolicy)o;
        return Objects.equals(this.deletesPctAllowed, other.deletesPctAllowed) && Objects.equals(this.expungeDeletesAllowed, other.expungeDeletesAllowed) && Objects.equals(this.floorSegment, other.floorSegment) && Objects.equals(this.maxMergeAtOnce, other.maxMergeAtOnce) && Objects.equals(this.maxMergedSegment, other.maxMergedSegment) && Objects.equals(this.reclaimDeletesWeight, other.reclaimDeletesWeight) && Objects.equals(this.segmentsPerTier, other.segmentsPerTier);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSettingsMergeTieredPolicy> {
        @Nullable
        private Double deletesPctAllowed;
        @Nullable
        private Double expungeDeletesAllowed;
        @Nullable
        private String floorSegment;
        @Nullable
        private Integer maxMergeAtOnce;
        @Nullable
        private String maxMergedSegment;
        @Nullable
        private Double reclaimDeletesWeight;
        @Nullable
        private Double segmentsPerTier;

        public Builder() {
        }

        private Builder(IndexSettingsMergeTieredPolicy o) {
            this.deletesPctAllowed = o.deletesPctAllowed;
            this.expungeDeletesAllowed = o.expungeDeletesAllowed;
            this.floorSegment = o.floorSegment;
            this.maxMergeAtOnce = o.maxMergeAtOnce;
            this.maxMergedSegment = o.maxMergedSegment;
            this.reclaimDeletesWeight = o.reclaimDeletesWeight;
            this.segmentsPerTier = o.segmentsPerTier;
        }

        private Builder(Builder o) {
            this.deletesPctAllowed = o.deletesPctAllowed;
            this.expungeDeletesAllowed = o.expungeDeletesAllowed;
            this.floorSegment = o.floorSegment;
            this.maxMergeAtOnce = o.maxMergeAtOnce;
            this.maxMergedSegment = o.maxMergedSegment;
            this.reclaimDeletesWeight = o.reclaimDeletesWeight;
            this.segmentsPerTier = o.segmentsPerTier;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder deletesPctAllowed(@Nullable Double value) {
            this.deletesPctAllowed = value;
            return this;
        }

        @Nonnull
        public final Builder expungeDeletesAllowed(@Nullable Double value) {
            this.expungeDeletesAllowed = value;
            return this;
        }

        @Nonnull
        public final Builder floorSegment(@Nullable String value) {
            this.floorSegment = value;
            return this;
        }

        @Nonnull
        public final Builder maxMergeAtOnce(@Nullable Integer value) {
            this.maxMergeAtOnce = value;
            return this;
        }

        @Nonnull
        public final Builder maxMergedSegment(@Nullable String value) {
            this.maxMergedSegment = value;
            return this;
        }

        @Nonnull
        public final Builder reclaimDeletesWeight(@Nullable Double value) {
            this.reclaimDeletesWeight = value;
            return this;
        }

        @Nonnull
        public final Builder segmentsPerTier(@Nullable Double value) {
            this.segmentsPerTier = value;
            return this;
        }

        @Override
        @Nonnull
        public IndexSettingsMergeTieredPolicy build() {
            this._checkSingleUse();
            return new IndexSettingsMergeTieredPolicy(this);
        }
    }
}

