/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaTime {
    public static void define(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        JavaExtensions.put(runtime2, java.time.Instant.class, proxy2 -> proxy2.defineMethods(context, Instant.class));
        JavaExtensions.put(runtime2, java.time.OffsetDateTime.class, proxy2 -> proxy2.defineMethods(context, OffsetDateTime.class));
        JavaExtensions.put(runtime2, java.time.LocalDateTime.class, proxy2 -> proxy2.defineMethods(context, LocalDateTime.class));
        JavaExtensions.put(runtime2, java.time.ZonedDateTime.class, proxy2 -> proxy2.defineMethods(context, ZonedDateTime.class));
        JavaExtensions.put(runtime2, ZoneId.class, klass -> klass.addMethod(context, "inspect", new JavaLang.InspectRawValue((RubyModule)klass)));
        JavaExtensions.put(runtime2, Temporal.class, klass -> klass.addMethod(context, "inspect", new JavaLang.InspectValueWithTypePrefix((RubyModule)klass)));
    }

    private static RubyTime toTime(ThreadContext context, int year2, int month2, int day, int hour2, int min2, int sec2, int nano, DateTimeZone zone2) {
        int millisOfSec = nano / 1000000;
        DateTime dt = new DateTime(year2, month2, day, hour2, min2, sec2, millisOfSec, zone2);
        return RubyTime.newTime(context.runtime, dt, nano % 1000000);
    }

    private static DateTimeZone convertZone(String id2) {
        if ("Z".equals(id2)) {
            return DateTimeZone.UTC;
        }
        return DateTimeZone.forID(id2);
    }

    @JRubyModule(name={"Java::JavaTime::ZonedDateTime"})
    public static class ZonedDateTime {
        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.ZonedDateTime val = (java.time.ZonedDateTime)JavaUtil.unwrapIfJavaObject(self2);
            return JavaTime.toTime(context, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), JavaTime.convertZone(val.getZone().getId()));
        }
    }

    @JRubyModule(name={"Java::JavaTime::LocalDateTime"})
    public static class LocalDateTime {
        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.LocalDateTime val = (java.time.LocalDateTime)JavaUtil.unwrapIfJavaObject(self2);
            return JavaTime.toTime(context, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), RubyTime.getLocalTimeZone(context));
        }
    }

    @JRubyModule(name={"Java::JavaTime::OffsetDateTime"})
    public static class OffsetDateTime {
        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.OffsetDateTime val = (java.time.OffsetDateTime)JavaUtil.unwrapIfJavaObject(self2);
            return JavaTime.toTime(context, val.getYear(), val.getMonthValue(), val.getDayOfMonth(), val.getHour(), val.getMinute(), val.getSecond(), val.getNano(), JavaTime.convertZone(val.getOffset().getId()));
        }
    }

    @JRubyModule(name={"Java::JavaTime::Instant"})
    public static class Instant {
        @JRubyMethod(name={"to_time"})
        public static IRubyObject to_time(ThreadContext context, IRubyObject self2) {
            java.time.Instant val = (java.time.Instant)JavaUtil.unwrapIfJavaObject(self2);
            long nano = val.getNano();
            long millis = val.getEpochSecond() * 1000L + nano / 1000000L;
            return RubyTime.newTime(context.runtime, new DateTime(millis, RubyTime.getLocalTimeZone(context)), nano %= 1000000L);
        }
    }
}

