/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.texparserlib.CaseChange;

public class GlsLikeFamily {
    private String singular;
    private String plural;
    private String sentence;
    private String sentencepl;
    private String allcaps;
    private String allcapspl;
    private String prefix;
    private String options;

    public void setOptions(String string) {
        this.options = string;
    }

    public String getOptions() {
        return this.options;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean hasSingular() {
        return this.singular != null && !this.singular.isEmpty();
    }

    public String getSingular() {
        return this.singular;
    }

    public void setSingular(String string) {
        this.singular = string;
    }

    public boolean hasPlural() {
        return this.plural != null && !this.plural.isEmpty();
    }

    public String getPlural() {
        return this.plural;
    }

    public void setPlural(String string) {
        this.plural = string;
    }

    public boolean hasSentence() {
        return this.sentence != null && !this.sentence.isEmpty();
    }

    public String getSentence() {
        return this.sentence;
    }

    public void setSentence(String string) {
        this.sentence = string;
    }

    public boolean hasSentencePlural() {
        return this.sentencepl != null && !this.sentencepl.isEmpty();
    }

    public String getSentencePlural() {
        return this.sentencepl;
    }

    public void setSentencePlural(String string) {
        this.sentencepl = string;
    }

    public boolean hasAllCaps() {
        return this.allcaps != null && !this.allcaps.isEmpty();
    }

    public String getAllCaps() {
        return this.allcaps;
    }

    public void setAllCaps(String string) {
        this.allcaps = string;
    }

    public boolean hasAllCapsPlural() {
        return this.allcapspl != null && !this.allcapspl.isEmpty();
    }

    public String getAllCapsPlural() {
        return this.allcapspl;
    }

    public void setAllCapsPlural(String string) {
        this.allcapspl = string;
    }

    public boolean hasMember(String string) {
        return string.equals(this.singular) || string.equals(this.plural) || string.equals(this.sentence) || string.equals(this.sentencepl) || string.equals(this.allcaps) || string.equals(this.allcapspl);
    }

    public boolean isPlural(String string) {
        return string.equals(this.plural) || string.equals(this.sentencepl) || string.equals(this.allcapspl);
    }

    public CaseChange getMemberCase(String string) {
        if (string.equals(this.sentence) || string.equals(this.sentencepl)) {
            return CaseChange.SENTENCE;
        }
        if (string.equals(this.allcaps) || string.equals(this.allcapspl)) {
            return CaseChange.TO_UPPER;
        }
        return CaseChange.NO_CHANGE;
    }

    public String getMember(CaseChange caseChange, String string) {
        boolean bl = this.isPlural(string);
        String string2 = null;
        switch (caseChange) {
            case SENTENCE: {
                string2 = bl ? this.sentencepl : this.sentence;
                break;
            }
            case TO_UPPER: {
                string2 = bl ? this.allcapspl : this.allcaps;
                break;
            }
            default: {
                String string3 = string2 = bl ? this.plural : this.singular;
            }
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = string;
        }
        return string2;
    }

    public String toString() {
        return String.format("%s[options=%s,prefix=%s,singular=%s,plural=%s,sentence=%s,sentenceplural=%s,allcaps=%s,allcapsplural=%s]", this.getClass().getSimpleName(), this.options, this.prefix, this.singular, this.plural, this.sentence, this.sentencepl, this.allcaps, this.allcapspl);
    }
}

