/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise the computation of absolute value difference.


This filter is parameterized over the types of the two input images
and the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter will walk over all the pixels in the two input images, and
for each one of them it will do the following:


Cast the input 1 pixel value to double .

Cast the input 2 pixel value to double .

Compute the difference of the two pixel values.

Compute the absolute value of the difference.

Cast the double value resulting from the absolute value to the pixel
type of the output image.

Store the casted value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND).
See:
 itk::simple::AbsoluteValueDifference for the procedural interface

 itk::AbsoluteValueDifferenceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAbsoluteValueDifferenceImageFilter.h
*/
public class AbsoluteValueDifferenceImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AbsoluteValueDifferenceImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AbsoluteValueDifferenceImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AbsoluteValueDifferenceImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AbsoluteValueDifferenceImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AbsoluteValueDifferenceImageFilter::~AbsoluteValueDifferenceImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AbsoluteValueDifferenceImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AbsoluteValueDifferenceImageFilter::AbsoluteValueDifferenceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AbsoluteValueDifferenceImageFilter() {
    this(SimpleITKJNI.new_AbsoluteValueDifferenceImageFilter(), true);
  }

  /**
std::string itk::simple::AbsoluteValueDifferenceImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AbsoluteValueDifferenceImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AbsoluteValueDifferenceImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AbsoluteValueDifferenceImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.AbsoluteValueDifferenceImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.AbsoluteValueDifferenceImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::AbsoluteValueDifferenceImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.AbsoluteValueDifferenceImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
