/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Morphological opening by attributes.


An attribute opening removes blobs according to criteria such as area.
When applied to grayscale images they have the effect of trimming
peaks (regions brighter than their surroundings) based on area while
leaving the rest of the image unchanged.

This code was contributed in the Insight Journal paper

"Grayscale morphological attribute operations" by Beare R. https://doi.org/10.54294/ifvjls


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 itk::simple::AreaOpening for the procedural interface

 itk::AreaOpeningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAreaOpeningImageFilter.h
*/
public class AreaOpeningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AreaOpeningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AreaOpeningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AreaOpeningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AreaOpeningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AreaOpeningImageFilter::~AreaOpeningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AreaOpeningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AreaOpeningImageFilter::AreaOpeningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AreaOpeningImageFilter() {
    this(SimpleITKJNI.new_AreaOpeningImageFilter(), true);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::SetLambda(double Lambda)

The size of the area opening.

*/
public  void setLambda(double Lambda) {
    SimpleITKJNI.AreaOpeningImageFilter_setLambda(swigCPtr, this, Lambda);
  }

  /**
double itk::simple::AreaOpeningImageFilter::GetLambda() const
*/
public  double getLambda() {
    return SimpleITKJNI.AreaOpeningImageFilter_getLambda(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether the image spacing is used or not - defaults to true.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.AreaOpeningImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.AreaOpeningImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.AreaOpeningImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::AreaOpeningImageFilter::GetUseImageSpacing() const

Set/Get whether the image spacing is used or not - defaults to true.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.AreaOpeningImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.AreaOpeningImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.AreaOpeningImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AreaOpeningImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.AreaOpeningImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::AreaOpeningImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.AreaOpeningImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::AreaOpeningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AreaOpeningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AreaOpeningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AreaOpeningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AreaOpeningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AreaOpeningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
