/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;

public class SimpleITK implements SimpleITKConstants {
  /**
const std::string SITKCommon_EXPORT itk::simple::GetPixelIDValueAsString(PixelIDValueType type)
*/
public  static String getPixelIDValueAsString(int type) {
    return SimpleITKJNI.getPixelIDValueAsString__SWIG_0(type);
  }

  /**
const std::string SITKCommon_EXPORT itk::simple::GetPixelIDValueAsString(PixelIDValueType type)
*/
public  static String getPixelIDValueAsString(PixelIDValueEnum type) {
    return SimpleITKJNI.getPixelIDValueAsString__SWIG_1(type.swigValue());
  }

  /**
PixelIDValueType SITKCommon_EXPORT itk::simple::GetPixelIDValueFromString(const std::string &amp;enumString)

Function mapping enumeration names in std::string to values.


This function is intended for use by the R bindings. R stores the
enumeration values using the names : "sitkUnknown", "sitkUInt8",
etc from PixelIDValueEnum above. This function is used to provide the
integer values using calls like:

val = GetPixelIDValueFromString("sitkInt32")

If the pixel type has not been instantiated then the sitkUnknown value
(-1) will be returned. If the pixel type string is not recognized
(i.e. is not in the set of tested names) then the return value is -99.
The idea is to provide a warning (via the R package) if this function
needs to be updated to match changes to PixelIDValueEnum - i.e. if a
new pixel type is added.

*/
public  static int getPixelIDValueFromString(String enumString) {
    return SimpleITKJNI.getPixelIDValueFromString(enumString);
  }

  /**
SITKCommon_EXPORT Transform itk::simple::ReadTransform(const PathType &amp;filename)
*/
public  static Transform readTransform(String filename) {
    return new Transform(SimpleITKJNI.readTransform(filename), true);
  }

  /**
SITKCommon_EXPORT void itk::simple::WriteTransform(const Transform &amp;transform, const PathType &amp;filename)
*/
public  static void writeTransform(Transform transform, String filename) {
    SimpleITKJNI.writeTransform(Transform.getCPtr(transform), transform, filename);
  }

  /**
void SITKIO_EXPORT itk::simple::Show(const Image &amp;image, const std::string &amp;title="", const bool
debugOn=ProcessObject::GetGlobalDefaultDebug())

Display an image in an external viewer (Fiji by default)

This function directly calls the execute method of ImageViewer in order to support a procedural API

*/
public  static void show(Image image, String title, boolean debugOn) {
    SimpleITKJNI.show__SWIG_0(Image.getCPtr(image), image, title, debugOn);
  }

  /**
void SITKIO_EXPORT itk::simple::Show(const Image &amp;image, const std::string &amp;title="", const bool
debugOn=ProcessObject::GetGlobalDefaultDebug())

Display an image in an external viewer (Fiji by default)

This function directly calls the execute method of ImageViewer in order to support a procedural API

*/
public  static void show(Image image, String title) {
    SimpleITKJNI.show__SWIG_1(Image.getCPtr(image), image, title);
  }

  /**
void SITKIO_EXPORT itk::simple::Show(const Image &amp;image, const std::string &amp;title="", const bool
debugOn=ProcessObject::GetGlobalDefaultDebug())

Display an image in an external viewer (Fiji by default)

This function directly calls the execute method of ImageViewer in order to support a procedural API

*/
public  static void show(Image image) {
    SimpleITKJNI.show__SWIG_2(Image.getCPtr(image), image);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, String fileName, boolean useCompression, int compressionLevel) {
    SimpleITKJNI.writeImage__SWIG_0(Image.getCPtr(image), image, fileName, useCompression, compressionLevel);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, String fileName, boolean useCompression) {
    SimpleITKJNI.writeImage__SWIG_1(Image.getCPtr(image), image, fileName, useCompression);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, String fileName) {
    SimpleITKJNI.writeImage__SWIG_2(Image.getCPtr(image), image, fileName);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, VectorString fileNames, boolean useCompression, int compressionLevel) {
    SimpleITKJNI.writeImage__SWIG_3(Image.getCPtr(image), image, VectorString.getCPtr(fileNames), fileNames, useCompression, compressionLevel);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, VectorString fileNames, boolean useCompression) {
    SimpleITKJNI.writeImage__SWIG_4(Image.getCPtr(image), image, VectorString.getCPtr(fileNames), fileNames, useCompression);
  }

  /**
SITKIO_EXPORT void itk::simple::WriteImage(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;fileNames, bool useCompression=false, int compressionLevel=-1)

WriteImage is a procedural interface to the ImageSeriesWriter. class which is convenient for many image writing tasks.




Parameters:

image:
the input image to be written

fileNames:
a vector of filenames of length equal to the number of slices in the
image.

useCompression:
request to compress the written file

compressionLevel:
a hint for the amount of compression to be applied during writing.


See:
 itk::simple::ImageFileWriter for writing a single file.


*/
public  static void writeImage(Image image, VectorString fileNames) {
    SimpleITKJNI.writeImage__SWIG_5(Image.getCPtr(image), image, VectorString.getCPtr(fileNames), fileNames);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(VectorString fileNames, PixelIDValueEnum outputPixelType, String imageIO) {
    return new Image(SimpleITKJNI.readImage__SWIG_0(VectorString.getCPtr(fileNames), fileNames, outputPixelType.swigValue(), imageIO), true);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(VectorString fileNames, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.readImage__SWIG_1(VectorString.getCPtr(fileNames), fileNames, outputPixelType.swigValue()), true);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(VectorString fileNames) {
    return new Image(SimpleITKJNI.readImage__SWIG_2(VectorString.getCPtr(fileNames), fileNames), true);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(String filename, PixelIDValueEnum outputPixelType, String imageIO) {
    return new Image(SimpleITKJNI.readImage__SWIG_3(filename, outputPixelType.swigValue(), imageIO), true);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(String filename, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.readImage__SWIG_4(filename, outputPixelType.swigValue()), true);
  }

  /**
SITKIO_EXPORT Image itk::simple::ReadImage(const std::vector&lt; PathType &gt; &amp;fileNames, PixelIDValueEnum
outputPixelType=sitkUnknown, const std::string &amp;imageIO="")

ReadImage is a procedural interface to the ImageSeriesReader class which is convenient for most image reading tasks.




Parameters:

fileNames:
a vector of file names

outputPixelType:
see ImageReaderBase::SetOutputPixelType

imageIO:
see ImageReaderBase::SetImageIO


When reading a series of images that have meta-data associated with
them (e.g. a DICOM series) the resulting image will have an empty
meta-data dictionary. If you need the meta-data dictionaries
associated with each slice then you should use the ImageSeriesReader class.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. If this is not the case, explicitly specify the
widest pixel type in the series as the outputPixelType.

See:
 itk::simple::ImageFileReader for reading a single file.

 itk::simple::ImageSeriesReader for reading a series and meta-data dictionaries.


*/
public  static Image readImage(String filename) {
    return new Image(SimpleITKJNI.readImage__SWIG_5(filename), true);
  }

  /**
std::string itk::simple::Hash(const Image &amp;image, HashImageFilter::HashFunction
function=HashImageFilter::SHA1)
*/
public  static String hash(Image image, HashImageFilter.HashFunction function) {
    return SimpleITKJNI.hash__SWIG_0(Image.getCPtr(image), image, function.swigValue());
  }

  /**
std::string itk::simple::Hash(const Image &amp;image, HashImageFilter::HashFunction
function=HashImageFilter::SHA1)
*/
public  static String hash(Image image) {
    return SimpleITKJNI.hash__SWIG_1(Image.getCPtr(image), image);
  }

  /**
BSplineTransform itk::simple::BSplineTransformInitializer(const Image &amp;image1, const std::vector&lt; uint32_t &gt;
&amp;transformDomainMeshSize=std::vector&lt; uint32_t &gt;(3, 1u),
unsigned int order=3u)

BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize() before calling
InitializeTransform().


This function directly calls the execute method of BSplineTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::BSplineTransformInitializerFilter for the object oriented interface


*/
public  static BSplineTransform bSplineTransformInitializer(Image image1, VectorUInt32 transformDomainMeshSize, long order) {
    return new BSplineTransform(SimpleITKJNI.bSplineTransformInitializer__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(transformDomainMeshSize), transformDomainMeshSize, order), true);
  }

  /**
BSplineTransform itk::simple::BSplineTransformInitializer(const Image &amp;image1, const std::vector&lt; uint32_t &gt;
&amp;transformDomainMeshSize=std::vector&lt; uint32_t &gt;(3, 1u),
unsigned int order=3u)

BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize() before calling
InitializeTransform().


This function directly calls the execute method of BSplineTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::BSplineTransformInitializerFilter for the object oriented interface


*/
public  static BSplineTransform bSplineTransformInitializer(Image image1, VectorUInt32 transformDomainMeshSize) {
    return new BSplineTransform(SimpleITKJNI.bSplineTransformInitializer__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(transformDomainMeshSize), transformDomainMeshSize), true);
  }

  /**
BSplineTransform itk::simple::BSplineTransformInitializer(const Image &amp;image1, const std::vector&lt; uint32_t &gt;
&amp;transformDomainMeshSize=std::vector&lt; uint32_t &gt;(3, 1u),
unsigned int order=3u)

BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize() before calling
InitializeTransform().


This function directly calls the execute method of BSplineTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::BSplineTransformInitializerFilter for the object oriented interface


*/
public  static BSplineTransform bSplineTransformInitializer(Image image1) {
    return new BSplineTransform(SimpleITKJNI.bSplineTransformInitializer__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  /**
Transform itk::simple::CenteredTransformInitializer(const Image &amp;fixedImage, const Image &amp;movingImage, const
Transform &amp;transform,
CenteredTransformInitializerFilter::OperationModeType operationMode=it
k::simple::CenteredTransformInitializerFilter::MOMENTS)

CenteredTransformInitializer is a helper class intended to initialize the center of rotation and
the translation of Transforms having the center of rotation among
their parameters.


This function directly calls the execute method of CenteredTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::CenteredTransformInitializerFilter for the object oriented interface


*/
public  static Transform centeredTransformInitializer(Image fixedImage, Image movingImage, Transform transform, CenteredTransformInitializerFilter.OperationModeType operationMode) {
    return new Transform(SimpleITKJNI.centeredTransformInitializer__SWIG_0(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Transform.getCPtr(transform), transform, operationMode.swigValue()), true);
  }

  /**
Transform itk::simple::CenteredTransformInitializer(const Image &amp;fixedImage, const Image &amp;movingImage, const
Transform &amp;transform,
CenteredTransformInitializerFilter::OperationModeType operationMode=it
k::simple::CenteredTransformInitializerFilter::MOMENTS)

CenteredTransformInitializer is a helper class intended to initialize the center of rotation and
the translation of Transforms having the center of rotation among
their parameters.


This function directly calls the execute method of CenteredTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::CenteredTransformInitializerFilter for the object oriented interface


*/
public  static Transform centeredTransformInitializer(Image fixedImage, Image movingImage, Transform transform) {
    return new Transform(SimpleITKJNI.centeredTransformInitializer__SWIG_1(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Transform.getCPtr(transform), transform), true);
  }

  /**
Transform itk::simple::CenteredVersorTransformInitializer(const Image &amp;fixedImage, const Image &amp;movingImage, const
Transform &amp;transform, bool computeRotation=false)

CenteredVersorTransformInitializer is a helper class intended to initialize the center of rotation,
versor, and translation of the VersorRigid3DTransform.


This function directly calls the execute method of
CenteredVectorTransformInitializerFilter in order to support a
procedural API.


See:
 itk::simple::CenteredVersorTransformInitializerFilter for the object oriented interface


*/
public  static Transform centeredVersorTransformInitializer(Image fixedImage, Image movingImage, Transform transform, boolean computeRotation) {
    return new Transform(SimpleITKJNI.centeredVersorTransformInitializer__SWIG_0(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Transform.getCPtr(transform), transform, computeRotation), true);
  }

  /**
Transform itk::simple::CenteredVersorTransformInitializer(const Image &amp;fixedImage, const Image &amp;movingImage, const
Transform &amp;transform, bool computeRotation=false)

CenteredVersorTransformInitializer is a helper class intended to initialize the center of rotation,
versor, and translation of the VersorRigid3DTransform.


This function directly calls the execute method of
CenteredVectorTransformInitializerFilter in order to support a
procedural API.


See:
 itk::simple::CenteredVersorTransformInitializerFilter for the object oriented interface


*/
public  static Transform centeredVersorTransformInitializer(Image fixedImage, Image movingImage, Transform transform) {
    return new Transform(SimpleITKJNI.centeredVersorTransformInitializer__SWIG_1(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Transform.getCPtr(transform), transform), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform, VectorDouble fixedLandmarks, VectorDouble movingLandmarks, VectorDouble landmarkWeight, Image referenceImage, long numberOfControlPoints) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_0(Transform.getCPtr(transform), transform, VectorDouble.getCPtr(fixedLandmarks), fixedLandmarks, VectorDouble.getCPtr(movingLandmarks), movingLandmarks, VectorDouble.getCPtr(landmarkWeight), landmarkWeight, Image.getCPtr(referenceImage), referenceImage, numberOfControlPoints), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform, VectorDouble fixedLandmarks, VectorDouble movingLandmarks, VectorDouble landmarkWeight, Image referenceImage) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_1(Transform.getCPtr(transform), transform, VectorDouble.getCPtr(fixedLandmarks), fixedLandmarks, VectorDouble.getCPtr(movingLandmarks), movingLandmarks, VectorDouble.getCPtr(landmarkWeight), landmarkWeight, Image.getCPtr(referenceImage), referenceImage), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform, VectorDouble fixedLandmarks, VectorDouble movingLandmarks, VectorDouble landmarkWeight) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_2(Transform.getCPtr(transform), transform, VectorDouble.getCPtr(fixedLandmarks), fixedLandmarks, VectorDouble.getCPtr(movingLandmarks), movingLandmarks, VectorDouble.getCPtr(landmarkWeight), landmarkWeight), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform, VectorDouble fixedLandmarks, VectorDouble movingLandmarks) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_3(Transform.getCPtr(transform), transform, VectorDouble.getCPtr(fixedLandmarks), fixedLandmarks, VectorDouble.getCPtr(movingLandmarks), movingLandmarks), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform, VectorDouble fixedLandmarks) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_4(Transform.getCPtr(transform), transform, VectorDouble.getCPtr(fixedLandmarks), fixedLandmarks), true);
  }

  /**
Transform itk::simple::LandmarkBasedTransformInitializer(const Transform &amp;transform, const std::vector&lt; double &gt;
&amp;fixedLandmarks=std::vector&lt; double &gt;(), const
std::vector&lt; double &gt; &amp;movingLandmarks=std::vector&lt;
double &gt;(), const std::vector&lt; double &gt;
&amp;landmarkWeight=std::vector&lt; double &gt;(), const Image
&amp;referenceImage=Image(), unsigned int numberOfControlPoints=4u)

itk::simple::LandmarkBasedTransformInitializerFilter Procedural Interface


This function directly calls the execute method of LandmarkBasedTransformInitializerFilter in order to support a procedural API


See:
 itk::simple::LandmarkBasedTransformInitializerFilter for the object oriented interface


*/
public  static Transform landmarkBasedTransformInitializer(Transform transform) {
    return new Transform(SimpleITKJNI.landmarkBasedTransformInitializer__SWIG_5(Transform.getCPtr(transform), transform), true);
  }

  /**
Image itk::simple::Cast(const Image &amp;image, PixelIDValueEnum pixelID)
*/
public  static Image cast(Image image, PixelIDValueEnum pixelID) {
    return new Image(SimpleITKJNI.cast(Image.getCPtr(image), image, pixelID.swigValue()), true);
  }

  public static Image extract(Image image1, VectorUInt32 size, VectorInt32 index, ExtractImageFilter.DirectionCollapseToStrategyType directionCollapseToStrategy) {
    return new Image(SimpleITKJNI.extract__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorInt32.getCPtr(index), index, directionCollapseToStrategy.swigValue()), true);
  }

  public static Image extract(Image image1, VectorUInt32 size, VectorInt32 index) {
    return new Image(SimpleITKJNI.extract__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorInt32.getCPtr(index), index), true);
  }

  public static Image extract(Image image1, VectorUInt32 size) {
    return new Image(SimpleITKJNI.extract__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size), true);
  }

  public static Image extract(Image image1) {
    return new Image(SimpleITKJNI.extract__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image paste(Image destinationImage, Image sourceImage, VectorUInt32 sourceSize, VectorInt32 sourceIndex, VectorInt32 destinationIndex, VectorBool DestinationSkipAxes) {
    return new Image(SimpleITKJNI.paste__SWIG_0(Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage, VectorUInt32.getCPtr(sourceSize), sourceSize, VectorInt32.getCPtr(sourceIndex), sourceIndex, VectorInt32.getCPtr(destinationIndex), destinationIndex, VectorBool.getCPtr(DestinationSkipAxes), DestinationSkipAxes), true);
  }

  public static Image paste(Image destinationImage, Image sourceImage, VectorUInt32 sourceSize, VectorInt32 sourceIndex, VectorInt32 destinationIndex) {
    return new Image(SimpleITKJNI.paste__SWIG_1(Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage, VectorUInt32.getCPtr(sourceSize), sourceSize, VectorInt32.getCPtr(sourceIndex), sourceIndex, VectorInt32.getCPtr(destinationIndex), destinationIndex), true);
  }

  public static Image paste(Image destinationImage, Image sourceImage, VectorUInt32 sourceSize, VectorInt32 sourceIndex) {
    return new Image(SimpleITKJNI.paste__SWIG_2(Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage, VectorUInt32.getCPtr(sourceSize), sourceSize, VectorInt32.getCPtr(sourceIndex), sourceIndex), true);
  }

  public static Image paste(Image destinationImage, Image sourceImage, VectorUInt32 sourceSize) {
    return new Image(SimpleITKJNI.paste__SWIG_3(Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage, VectorUInt32.getCPtr(sourceSize), sourceSize), true);
  }

  public static Image paste(Image destinationImage, Image sourceImage) {
    return new Image(SimpleITKJNI.paste__SWIG_4(Image.getCPtr(destinationImage), destinationImage, Image.getCPtr(sourceImage), sourceImage), true);
  }

  public static Image resample(Image image1, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue, PixelIDValueEnum outputPixelType, boolean useNearestNeighborExtrapolator) {
    return new Image(SimpleITKJNI.resample__SWIG_0(Image.getCPtr(image1), image1, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue, outputPixelType.swigValue(), useNearestNeighborExtrapolator), true);
  }

  public static Image resample(Image image1, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.resample__SWIG_1(Image.getCPtr(image1), image1, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue, outputPixelType.swigValue()), true);
  }

  public static Image resample(Image image1, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue) {
    return new Image(SimpleITKJNI.resample__SWIG_2(Image.getCPtr(image1), image1, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue), true);
  }

  public static Image resample(Image image1, Transform transform, InterpolatorEnum interpolator) {
    return new Image(SimpleITKJNI.resample__SWIG_3(Image.getCPtr(image1), image1, Transform.getCPtr(transform), transform, interpolator.swigValue()), true);
  }

  public static Image resample(Image image1, Transform transform) {
    return new Image(SimpleITKJNI.resample__SWIG_4(Image.getCPtr(image1), image1, Transform.getCPtr(transform), transform), true);
  }

  public static Image resample(Image image1) {
    return new Image(SimpleITKJNI.resample__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image resample(Image image1, Image referenceImage, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue, PixelIDValueEnum outputPixelType, boolean useNearestNeighborExtrapolator) {
    return new Image(SimpleITKJNI.resample__SWIG_6(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue, outputPixelType.swigValue(), useNearestNeighborExtrapolator), true);
  }

  public static Image resample(Image image1, Image referenceImage, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.resample__SWIG_7(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue, outputPixelType.swigValue()), true);
  }

  public static Image resample(Image image1, Image referenceImage, Transform transform, InterpolatorEnum interpolator, double defaultPixelValue) {
    return new Image(SimpleITKJNI.resample__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage, Transform.getCPtr(transform), transform, interpolator.swigValue(), defaultPixelValue), true);
  }

  public static Image resample(Image image1, Image referenceImage, Transform transform, InterpolatorEnum interpolator) {
    return new Image(SimpleITKJNI.resample__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage, Transform.getCPtr(transform), transform, interpolator.swigValue()), true);
  }

  public static Image resample(Image image1, Image referenceImage, Transform transform) {
    return new Image(SimpleITKJNI.resample__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage, Transform.getCPtr(transform), transform), true);
  }

  public static Image resample(Image image1, Image referenceImage) {
    return new Image(SimpleITKJNI.resample__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(referenceImage), referenceImage), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection, double defaultPixelValue, PixelIDValueEnum outputPixelType, boolean useNearestNeighborExtrapolator) {
    return new Image(SimpleITKJNI.resample__SWIG_12(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection, defaultPixelValue, outputPixelType.swigValue(), useNearestNeighborExtrapolator), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection, double defaultPixelValue, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.resample__SWIG_13(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection, defaultPixelValue, outputPixelType.swigValue()), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection, double defaultPixelValue) {
    return new Image(SimpleITKJNI.resample__SWIG_14(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection, defaultPixelValue), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection) {
    return new Image(SimpleITKJNI.resample__SWIG_15(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin, VectorDouble outputSpacing) {
    return new Image(SimpleITKJNI.resample__SWIG_16(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator, VectorDouble outputOrigin) {
    return new Image(SimpleITKJNI.resample__SWIG_17(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue(), VectorDouble.getCPtr(outputOrigin), outputOrigin), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform, InterpolatorEnum interpolator) {
    return new Image(SimpleITKJNI.resample__SWIG_18(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform, interpolator.swigValue()), true);
  }

  public static Image resample(Image image1, VectorUInt32 size, Transform transform) {
    return new Image(SimpleITKJNI.resample__SWIG_19(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, Transform.getCPtr(transform), transform), true);
  }

  public static Image resample(Image image1, VectorUInt32 size) {
    return new Image(SimpleITKJNI.resample__SWIG_20(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches, double sampleVariance, double noiseSigma, double noiseModelFidelityWeight) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_0(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches, sampleVariance, noiseSigma, noiseModelFidelityWeight), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches, double sampleVariance, double noiseSigma) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_1(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches, sampleVariance, noiseSigma), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches, double sampleVariance) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_2(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches, sampleVariance), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_3(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius, long numberOfIterations) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_4(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius, numberOfIterations), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma, long patchRadius) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_5(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma, patchRadius), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel, double kernelBandwidthSigma) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_6(Image.getCPtr(image1), image1, noiseModel.swigValue(), kernelBandwidthSigma), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, PatchBasedDenoisingImageFilter.NoiseModelType noiseModel) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_7(Image.getCPtr(image1), image1, noiseModel.swigValue()), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches, double sampleVariance) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_8(Image.getCPtr(image1), image1, kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches, sampleVariance), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, double kernelBandwidthSigma, long patchRadius, long numberOfIterations, long numberOfSamplePatches) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_9(Image.getCPtr(image1), image1, kernelBandwidthSigma, patchRadius, numberOfIterations, numberOfSamplePatches), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, double kernelBandwidthSigma, long patchRadius, long numberOfIterations) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_10(Image.getCPtr(image1), image1, kernelBandwidthSigma, patchRadius, numberOfIterations), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, double kernelBandwidthSigma, long patchRadius) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_11(Image.getCPtr(image1), image1, kernelBandwidthSigma, patchRadius), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1, double kernelBandwidthSigma) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_12(Image.getCPtr(image1), image1, kernelBandwidthSigma), true);
  }

  /**
Image itk::simple::PatchBasedDenoising(const Image &amp;image1,
itk::simple::PatchBasedDenoisingImageFilter::NoiseModelType
noiseModel, double kernelBandwidthSigma=400.0, uint32_t
patchRadius=4u, uint32_t numberOfIterations=1u, uint32_t
numberOfSamplePatches=200u, double sampleVariance=400.0, double
noiseSigma=0.0, double noiseModelFidelityWeight=0.0)

itk::simple::PatchBasedDenoisingImageFilter Procedural Interface


This function directly calls the execute method of PatchBasedDenoisingImageFilter in order to support a procedural API


See:
 itk::simple::PatchBasedDenoisingImageFilter for the object oriented interface


*/
public  static Image patchBasedDenoising(Image image1) {
    return new Image(SimpleITKJNI.patchBasedDenoising__SWIG_13(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, double variance, long maximumKernelWidth, double maximumError, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_0(Image.getCPtr(image1), image1, variance, maximumKernelWidth, maximumError, useImageSpacing), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, double variance, long maximumKernelWidth, double maximumError) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_1(Image.getCPtr(image1), image1, variance, maximumKernelWidth, maximumError), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, double variance, long maximumKernelWidth) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_2(Image.getCPtr(image1), image1, variance, maximumKernelWidth), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, double variance) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_3(Image.getCPtr(image1), image1, variance), true);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussian(const Image &amp;image1, double sigma, bool
normalizeAcrossScale=false)

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter in order to support a procedural API


See:
 itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface


*/
public  static Image smoothingRecursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.smoothingRecursiveGaussian__SWIG_0(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale), true);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussian(const Image &amp;image1, double sigma, bool
normalizeAcrossScale=false)

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter in order to support a procedural API


See:
 itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface


*/
public  static Image smoothingRecursiveGaussian(Image image1, double sigma) {
    return new Image(SimpleITKJNI.smoothingRecursiveGaussian__SWIG_1(Image.getCPtr(image1), image1, sigma), true);
  }

  public static Image abs(Image image1) {
    return new Image(SimpleITKJNI.abs(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::AbsoluteValueDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image absoluteValueDifference(Image image1, Image image2) {
    return new Image(SimpleITKJNI.absoluteValueDifference__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::AbsoluteValueDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image absoluteValueDifference(Image image1, double constant) {
    return new Image(SimpleITKJNI.absoluteValueDifference__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::AbsoluteValueDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image absoluteValueDifference(double constant, Image image2) {
    return new Image(SimpleITKJNI.absoluteValueDifference__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image acos(Image image1) {
    return new Image(SimpleITKJNI.acos(Image.getCPtr(image1), image1), true);
  }

  public static Image adaptiveHistogramEqualization(Image image1, VectorUInt32 radius, float alpha, float beta) {
    return new Image(SimpleITKJNI.adaptiveHistogramEqualization__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, alpha, beta), true);
  }

  public static Image adaptiveHistogramEqualization(Image image1, VectorUInt32 radius, float alpha) {
    return new Image(SimpleITKJNI.adaptiveHistogramEqualization__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, alpha), true);
  }

  public static Image adaptiveHistogramEqualization(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.adaptiveHistogramEqualization__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image adaptiveHistogramEqualization(Image image1) {
    return new Image(SimpleITKJNI.adaptiveHistogramEqualization__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Add(Image &amp;&amp;image1, double constant)
*/
public  static Image add(Image image1, Image image2) {
    return new Image(SimpleITKJNI.add__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Add(Image &amp;&amp;image1, double constant)
*/
public  static Image add(Image image1, double constant) {
    return new Image(SimpleITKJNI.add__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Add(Image &amp;&amp;image1, double constant)
*/
public  static Image add(double constant, Image image2) {
    return new Image(SimpleITKJNI.add__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image additiveGaussianNoise(Image image1, double standardDeviation, double mean, long seed) {
    return new Image(SimpleITKJNI.additiveGaussianNoise__SWIG_0(Image.getCPtr(image1), image1, standardDeviation, mean, seed), true);
  }

  public static Image additiveGaussianNoise(Image image1, double standardDeviation, double mean) {
    return new Image(SimpleITKJNI.additiveGaussianNoise__SWIG_1(Image.getCPtr(image1), image1, standardDeviation, mean), true);
  }

  public static Image additiveGaussianNoise(Image image1, double standardDeviation) {
    return new Image(SimpleITKJNI.additiveGaussianNoise__SWIG_2(Image.getCPtr(image1), image1, standardDeviation), true);
  }

  public static Image additiveGaussianNoise(Image image1) {
    return new Image(SimpleITKJNI.additiveGaussianNoise__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image aggregateLabelMap(Image image1) {
    return new Image(SimpleITKJNI.aggregateLabelMap(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::And(int constant, const Image &amp;image2)
*/
public  static Image and(Image image1, Image image2) {
    return new Image(SimpleITKJNI.and__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::And(int constant, const Image &amp;image2)
*/
public  static Image and(Image image1, int constant) {
    return new Image(SimpleITKJNI.and__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::And(int constant, const Image &amp;image2)
*/
public  static Image and(int constant, Image image2) {
    return new Image(SimpleITKJNI.and__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image antiAliasBinary(Image image1, double maximumRMSError, long numberOfIterations) {
    return new Image(SimpleITKJNI.antiAliasBinary__SWIG_0(Image.getCPtr(image1), image1, maximumRMSError, numberOfIterations), true);
  }

  public static Image antiAliasBinary(Image image1, double maximumRMSError) {
    return new Image(SimpleITKJNI.antiAliasBinary__SWIG_1(Image.getCPtr(image1), image1, maximumRMSError), true);
  }

  public static Image antiAliasBinary(Image image1) {
    return new Image(SimpleITKJNI.antiAliasBinary__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image approximateSignedDistanceMap(Image image1, double insideValue, double outsideValue) {
    return new Image(SimpleITKJNI.approximateSignedDistanceMap__SWIG_0(Image.getCPtr(image1), image1, insideValue, outsideValue), true);
  }

  public static Image approximateSignedDistanceMap(Image image1, double insideValue) {
    return new Image(SimpleITKJNI.approximateSignedDistanceMap__SWIG_1(Image.getCPtr(image1), image1, insideValue), true);
  }

  public static Image approximateSignedDistanceMap(Image image1) {
    return new Image(SimpleITKJNI.approximateSignedDistanceMap__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image areaClosing(Image image1, double lambda, boolean useImageSpacing, boolean fullyConnected) {
    return new Image(SimpleITKJNI.areaClosing__SWIG_0(Image.getCPtr(image1), image1, lambda, useImageSpacing, fullyConnected), true);
  }

  public static Image areaClosing(Image image1, double lambda, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.areaClosing__SWIG_1(Image.getCPtr(image1), image1, lambda, useImageSpacing), true);
  }

  public static Image areaClosing(Image image1, double lambda) {
    return new Image(SimpleITKJNI.areaClosing__SWIG_2(Image.getCPtr(image1), image1, lambda), true);
  }

  public static Image areaClosing(Image image1) {
    return new Image(SimpleITKJNI.areaClosing__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image areaOpening(Image image1, double lambda, boolean useImageSpacing, boolean fullyConnected) {
    return new Image(SimpleITKJNI.areaOpening__SWIG_0(Image.getCPtr(image1), image1, lambda, useImageSpacing, fullyConnected), true);
  }

  public static Image areaOpening(Image image1, double lambda, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.areaOpening__SWIG_1(Image.getCPtr(image1), image1, lambda, useImageSpacing), true);
  }

  public static Image areaOpening(Image image1, double lambda) {
    return new Image(SimpleITKJNI.areaOpening__SWIG_2(Image.getCPtr(image1), image1, lambda), true);
  }

  public static Image areaOpening(Image image1) {
    return new Image(SimpleITKJNI.areaOpening__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image asin(Image image1) {
    return new Image(SimpleITKJNI.asin(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Atan2(Image &amp;&amp;image1, double constant)
*/
public  static Image atan2(Image image1, Image image2) {
    return new Image(SimpleITKJNI.atan2__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Atan2(Image &amp;&amp;image1, double constant)
*/
public  static Image atan2(Image image1, double constant) {
    return new Image(SimpleITKJNI.atan2__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Atan2(Image &amp;&amp;image1, double constant)
*/
public  static Image atan2(double constant, Image image2) {
    return new Image(SimpleITKJNI.atan2__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image atan(Image image1) {
    return new Image(SimpleITKJNI.atan(Image.getCPtr(image1), image1), true);
  }

  public static Image bSplineDecomposition(Image image1, long splineOrder) {
    return new Image(SimpleITKJNI.bSplineDecomposition__SWIG_0(Image.getCPtr(image1), image1, splineOrder), true);
  }

  public static Image bSplineDecomposition(Image image1) {
    return new Image(SimpleITKJNI.bSplineDecomposition__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image bilateral(Image image1, double domainSigma, double rangeSigma, long numberOfRangeGaussianSamples) {
    return new Image(SimpleITKJNI.bilateral__SWIG_0(Image.getCPtr(image1), image1, domainSigma, rangeSigma, numberOfRangeGaussianSamples), true);
  }

  public static Image bilateral(Image image1, double domainSigma, double rangeSigma) {
    return new Image(SimpleITKJNI.bilateral__SWIG_1(Image.getCPtr(image1), image1, domainSigma, rangeSigma), true);
  }

  public static Image bilateral(Image image1, double domainSigma) {
    return new Image(SimpleITKJNI.bilateral__SWIG_2(Image.getCPtr(image1), image1, domainSigma), true);
  }

  public static Image bilateral(Image image1) {
    return new Image(SimpleITKJNI.bilateral__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binShrink(Image image1, VectorUInt32 shrinkFactors) {
    return new Image(SimpleITKJNI.binShrink__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(shrinkFactors), shrinkFactors), true);
  }

  public static Image binShrink(Image image1) {
    return new Image(SimpleITKJNI.binShrink__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryClosingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryClosingByReconstruction__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue, fullyConnected), true);
  }

  public static Image binaryClosingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryClosingByReconstruction__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue), true);
  }

  public static Image binaryClosingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryClosingByReconstruction__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryClosingByReconstruction(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryClosingByReconstruction__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryClosingByReconstruction(Image image1) {
    return new Image(SimpleITKJNI.binaryClosingByReconstruction__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryContour(Image image1, boolean fullyConnected, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryContour__SWIG_0(Image.getCPtr(image1), image1, fullyConnected, backgroundValue, foregroundValue), true);
  }

  public static Image binaryContour(Image image1, boolean fullyConnected, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryContour__SWIG_1(Image.getCPtr(image1), image1, fullyConnected, backgroundValue), true);
  }

  public static Image binaryContour(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryContour__SWIG_2(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image binaryContour(Image image1) {
    return new Image(SimpleITKJNI.binaryContour__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryDilate(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue, double foregroundValue, boolean boundaryToForeground) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue, foregroundValue, boundaryToForeground), true);
  }

  public static Image binaryDilate(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue, foregroundValue), true);
  }

  public static Image binaryDilate(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue), true);
  }

  public static Image binaryDilate(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryDilate(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryDilate(Image image1) {
    return new Image(SimpleITKJNI.binaryDilate__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryErode(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue, double foregroundValue, boolean boundaryToForeground) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue, foregroundValue, boundaryToForeground), true);
  }

  public static Image binaryErode(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue, foregroundValue), true);
  }

  public static Image binaryErode(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue), true);
  }

  public static Image binaryErode(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryErode(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryErode(Image image1) {
    return new Image(SimpleITKJNI.binaryErode__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryFillhole(Image image1, boolean fullyConnected, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryFillhole__SWIG_0(Image.getCPtr(image1), image1, fullyConnected, foregroundValue), true);
  }

  public static Image binaryFillhole(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryFillhole__SWIG_1(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image binaryFillhole(Image image1) {
    return new Image(SimpleITKJNI.binaryFillhole__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryGrindPeak(Image image1, boolean fullyConnected, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryGrindPeak__SWIG_0(Image.getCPtr(image1), image1, fullyConnected, foregroundValue, backgroundValue), true);
  }

  public static Image binaryGrindPeak(Image image1, boolean fullyConnected, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryGrindPeak__SWIG_1(Image.getCPtr(image1), image1, fullyConnected, foregroundValue), true);
  }

  public static Image binaryGrindPeak(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryGrindPeak__SWIG_2(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image binaryGrindPeak(Image image1) {
    return new Image(SimpleITKJNI.binaryGrindPeak__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryImageToLabelMap(Image image1, boolean fullyConnected, double inputForegroundValue, double outputBackgroundValue) {
    return new Image(SimpleITKJNI.binaryImageToLabelMap__SWIG_0(Image.getCPtr(image1), image1, fullyConnected, inputForegroundValue, outputBackgroundValue), true);
  }

  public static Image binaryImageToLabelMap(Image image1, boolean fullyConnected, double inputForegroundValue) {
    return new Image(SimpleITKJNI.binaryImageToLabelMap__SWIG_1(Image.getCPtr(image1), image1, fullyConnected, inputForegroundValue), true);
  }

  public static Image binaryImageToLabelMap(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryImageToLabelMap__SWIG_2(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image binaryImageToLabelMap(Image image1) {
    return new Image(SimpleITKJNI.binaryImageToLabelMap__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryMagnitude(Image image1, Image image2) {
    return new Image(SimpleITKJNI.binaryMagnitude(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image binaryMedian(Image image1, VectorUInt32 radius, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryMedian__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, foregroundValue, backgroundValue), true);
  }

  public static Image binaryMedian(Image image1, VectorUInt32 radius, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryMedian__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, foregroundValue), true);
  }

  public static Image binaryMedian(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.binaryMedian__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image binaryMedian(Image image1) {
    return new Image(SimpleITKJNI.binaryMedian__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryMinMaxCurvatureFlow(Image image1, double timeStep, long numberOfIterations, int stencilRadius, double threshold) {
    return new Image(SimpleITKJNI.binaryMinMaxCurvatureFlow__SWIG_0(Image.getCPtr(image1), image1, timeStep, numberOfIterations, stencilRadius, threshold), true);
  }

  public static Image binaryMinMaxCurvatureFlow(Image image1, double timeStep, long numberOfIterations, int stencilRadius) {
    return new Image(SimpleITKJNI.binaryMinMaxCurvatureFlow__SWIG_1(Image.getCPtr(image1), image1, timeStep, numberOfIterations, stencilRadius), true);
  }

  public static Image binaryMinMaxCurvatureFlow(Image image1, double timeStep, long numberOfIterations) {
    return new Image(SimpleITKJNI.binaryMinMaxCurvatureFlow__SWIG_2(Image.getCPtr(image1), image1, timeStep, numberOfIterations), true);
  }

  public static Image binaryMinMaxCurvatureFlow(Image image1, double timeStep) {
    return new Image(SimpleITKJNI.binaryMinMaxCurvatureFlow__SWIG_3(Image.getCPtr(image1), image1, timeStep), true);
  }

  public static Image binaryMinMaxCurvatureFlow(Image image1) {
    return new Image(SimpleITKJNI.binaryMinMaxCurvatureFlow__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryMorphologicalClosing(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue, boolean safeBorder) {
    return new Image(SimpleITKJNI.binaryMorphologicalClosing__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue, safeBorder), true);
  }

  public static Image binaryMorphologicalClosing(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryMorphologicalClosing__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue), true);
  }

  public static Image binaryMorphologicalClosing(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryMorphologicalClosing__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryMorphologicalClosing(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryMorphologicalClosing__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryMorphologicalClosing(Image image1) {
    return new Image(SimpleITKJNI.binaryMorphologicalClosing__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryMorphologicalOpening(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryMorphologicalOpening__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue, foregroundValue), true);
  }

  public static Image binaryMorphologicalOpening(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryMorphologicalOpening__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), backgroundValue), true);
  }

  public static Image binaryMorphologicalOpening(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryMorphologicalOpening__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryMorphologicalOpening(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryMorphologicalOpening__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryMorphologicalOpening(Image image1) {
    return new Image(SimpleITKJNI.binaryMorphologicalOpening__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryNot(Image image1, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryNot__SWIG_0(Image.getCPtr(image1), image1, foregroundValue, backgroundValue), true);
  }

  public static Image binaryNot(Image image1, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryNot__SWIG_1(Image.getCPtr(image1), image1, foregroundValue), true);
  }

  public static Image binaryNot(Image image1) {
    return new Image(SimpleITKJNI.binaryNot__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue, double backgroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue, backgroundValue, fullyConnected), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue, backgroundValue), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), foregroundValue), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image binaryOpeningByReconstruction(Image image1) {
    return new Image(SimpleITKJNI.binaryOpeningByReconstruction__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryProjection(Image image1, long projectionDimension, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension, foregroundValue, backgroundValue), true);
  }

  public static Image binaryProjection(Image image1, long projectionDimension, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryProjection__SWIG_1(Image.getCPtr(image1), image1, projectionDimension, foregroundValue), true);
  }

  public static Image binaryProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.binaryProjection__SWIG_2(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image binaryProjection(Image image1) {
    return new Image(SimpleITKJNI.binaryProjection__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryPruning(Image image1, long iteration) {
    return new Image(SimpleITKJNI.binaryPruning__SWIG_0(Image.getCPtr(image1), image1, iteration), true);
  }

  public static Image binaryPruning(Image image1) {
    return new Image(SimpleITKJNI.binaryPruning__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryReconstructionByDilation(Image markerImage, Image maskImage, double backgroundValue, double foregroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryReconstructionByDilation__SWIG_0(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue, foregroundValue, fullyConnected), true);
  }

  public static Image binaryReconstructionByDilation(Image markerImage, Image maskImage, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryReconstructionByDilation__SWIG_1(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue, foregroundValue), true);
  }

  public static Image binaryReconstructionByDilation(Image markerImage, Image maskImage, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryReconstructionByDilation__SWIG_2(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue), true);
  }

  public static Image binaryReconstructionByDilation(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.binaryReconstructionByDilation__SWIG_3(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image binaryReconstructionByErosion(Image markerImage, Image maskImage, double backgroundValue, double foregroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.binaryReconstructionByErosion__SWIG_0(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue, foregroundValue, fullyConnected), true);
  }

  public static Image binaryReconstructionByErosion(Image markerImage, Image maskImage, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.binaryReconstructionByErosion__SWIG_1(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue, foregroundValue), true);
  }

  public static Image binaryReconstructionByErosion(Image markerImage, Image maskImage, double backgroundValue) {
    return new Image(SimpleITKJNI.binaryReconstructionByErosion__SWIG_2(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, backgroundValue), true);
  }

  public static Image binaryReconstructionByErosion(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.binaryReconstructionByErosion__SWIG_3(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image binaryThinning(Image image1) {
    return new Image(SimpleITKJNI.binaryThinning(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryThreshold(Image image1, double lowerThreshold, double upperThreshold, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.binaryThreshold__SWIG_0(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold, insideValue, outsideValue), true);
  }

  public static Image binaryThreshold(Image image1, double lowerThreshold, double upperThreshold, short insideValue) {
    return new Image(SimpleITKJNI.binaryThreshold__SWIG_1(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold, insideValue), true);
  }

  public static Image binaryThreshold(Image image1, double lowerThreshold, double upperThreshold) {
    return new Image(SimpleITKJNI.binaryThreshold__SWIG_2(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold), true);
  }

  public static Image binaryThreshold(Image image1, double lowerThreshold) {
    return new Image(SimpleITKJNI.binaryThreshold__SWIG_3(Image.getCPtr(image1), image1, lowerThreshold), true);
  }

  public static Image binaryThreshold(Image image1) {
    return new Image(SimpleITKJNI.binaryThreshold__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binaryThresholdProjection(Image image1, long projectionDimension, double thresholdValue, short foregroundValue, short backgroundValue) {
    return new Image(SimpleITKJNI.binaryThresholdProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension, thresholdValue, foregroundValue, backgroundValue), true);
  }

  public static Image binaryThresholdProjection(Image image1, long projectionDimension, double thresholdValue, short foregroundValue) {
    return new Image(SimpleITKJNI.binaryThresholdProjection__SWIG_1(Image.getCPtr(image1), image1, projectionDimension, thresholdValue, foregroundValue), true);
  }

  public static Image binaryThresholdProjection(Image image1, long projectionDimension, double thresholdValue) {
    return new Image(SimpleITKJNI.binaryThresholdProjection__SWIG_2(Image.getCPtr(image1), image1, projectionDimension, thresholdValue), true);
  }

  public static Image binaryThresholdProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.binaryThresholdProjection__SWIG_3(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image binaryThresholdProjection(Image image1) {
    return new Image(SimpleITKJNI.binaryThresholdProjection__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image binomialBlur(Image image1, long repetitions) {
    return new Image(SimpleITKJNI.binomialBlur__SWIG_0(Image.getCPtr(image1), image1, repetitions), true);
  }

  public static Image binomialBlur(Image image1) {
    return new Image(SimpleITKJNI.binomialBlur__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image bitwiseNot(Image image1) {
    return new Image(SimpleITKJNI.bitwiseNot(Image.getCPtr(image1), image1), true);
  }

  public static Image blackTopHat(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean safeBorder) {
    return new Image(SimpleITKJNI.blackTopHat__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), safeBorder), true);
  }

  public static Image blackTopHat(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.blackTopHat__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image blackTopHat(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.blackTopHat__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image blackTopHat(Image image1) {
    return new Image(SimpleITKJNI.blackTopHat__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image boundedReciprocal(Image image1) {
    return new Image(SimpleITKJNI.boundedReciprocal(Image.getCPtr(image1), image1), true);
  }

  public static Image boxMean(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.boxMean__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image boxMean(Image image1) {
    return new Image(SimpleITKJNI.boxMean__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image boxSigma(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.boxSigma__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image boxSigma(Image image1) {
    return new Image(SimpleITKJNI.boxSigma__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image cannyEdgeDetection(Image image1, double lowerThreshold, double upperThreshold, VectorDouble variance, VectorDouble maximumError) {
    return new Image(SimpleITKJNI.cannyEdgeDetection__SWIG_0(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold, VectorDouble.getCPtr(variance), variance, VectorDouble.getCPtr(maximumError), maximumError), true);
  }

  public static Image cannyEdgeDetection(Image image1, double lowerThreshold, double upperThreshold, VectorDouble variance) {
    return new Image(SimpleITKJNI.cannyEdgeDetection__SWIG_1(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold, VectorDouble.getCPtr(variance), variance), true);
  }

  public static Image cannyEdgeDetection(Image image1, double lowerThreshold, double upperThreshold) {
    return new Image(SimpleITKJNI.cannyEdgeDetection__SWIG_2(Image.getCPtr(image1), image1, lowerThreshold, upperThreshold), true);
  }

  public static Image cannyEdgeDetection(Image image1, double lowerThreshold) {
    return new Image(SimpleITKJNI.cannyEdgeDetection__SWIG_3(Image.getCPtr(image1), image1, lowerThreshold), true);
  }

  public static Image cannyEdgeDetection(Image image1) {
    return new Image(SimpleITKJNI.cannyEdgeDetection__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, long numberOfIterations, boolean reverseExpansionDirection, double isoSurfaceValue) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling, numberOfIterations, reverseExpansionDirection, isoSurfaceValue), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, long numberOfIterations, boolean reverseExpansionDirection) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling, numberOfIterations, reverseExpansionDirection), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, long numberOfIterations) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling, numberOfIterations), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling, double curvatureScaling) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling, curvatureScaling), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError, double propagationScaling) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError, propagationScaling), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance, double maximumRMSError) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_6(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance, maximumRMSError), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold, double variance) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_7(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold, variance), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage, double threshold) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_8(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, threshold), true);
  }

  public static Image cannySegmentationLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.cannySegmentationLevelSet__SWIG_9(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image changeLabel(Image image1, DoubleDoubleMap changeMap) {
    return new Image(SimpleITKJNI.changeLabel__SWIG_0(Image.getCPtr(image1), image1, DoubleDoubleMap.getCPtr(changeMap), changeMap), true);
  }

  public static Image changeLabel(Image image1) {
    return new Image(SimpleITKJNI.changeLabel__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image changeLabelLabelMap(Image image1, DoubleDoubleMap changeMap) {
    return new Image(SimpleITKJNI.changeLabelLabelMap__SWIG_0(Image.getCPtr(image1), image1, DoubleDoubleMap.getCPtr(changeMap), changeMap), true);
  }

  public static Image changeLabelLabelMap(Image image1) {
    return new Image(SimpleITKJNI.changeLabelLabelMap__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image checkerBoard(Image image1, Image image2, VectorUInt32 checkerPattern) {
    return new Image(SimpleITKJNI.checkerBoard__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, VectorUInt32.getCPtr(checkerPattern), checkerPattern), true);
  }

  public static Image checkerBoard(Image image1, Image image2) {
    return new Image(SimpleITKJNI.checkerBoard__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image clamp(Image image1, PixelIDValueEnum outputPixelType, double lowerBound, double upperBound) {
    return new Image(SimpleITKJNI.clamp__SWIG_0(Image.getCPtr(image1), image1, outputPixelType.swigValue(), lowerBound, upperBound), true);
  }

  public static Image clamp(Image image1, PixelIDValueEnum outputPixelType, double lowerBound) {
    return new Image(SimpleITKJNI.clamp__SWIG_1(Image.getCPtr(image1), image1, outputPixelType.swigValue(), lowerBound), true);
  }

  public static Image clamp(Image image1, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.clamp__SWIG_2(Image.getCPtr(image1), image1, outputPixelType.swigValue()), true);
  }

  public static Image clamp(Image image1) {
    return new Image(SimpleITKJNI.clamp__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image closingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean fullyConnected, boolean preserveIntensities) {
    return new Image(SimpleITKJNI.closingByReconstruction__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), fullyConnected, preserveIntensities), true);
  }

  public static Image closingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean fullyConnected) {
    return new Image(SimpleITKJNI.closingByReconstruction__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), fullyConnected), true);
  }

  public static Image closingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.closingByReconstruction__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image closingByReconstruction(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.closingByReconstruction__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image closingByReconstruction(Image image1) {
    return new Image(SimpleITKJNI.closingByReconstruction__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image collidingFronts(Image image1, VectorUIntList seedPoints1, VectorUIntList seedPoints2, boolean applyConnectivity, double negativeEpsilon, boolean stopOnTargets) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedPoints1), seedPoints1, VectorUIntList.getCPtr(seedPoints2), seedPoints2, applyConnectivity, negativeEpsilon, stopOnTargets), true);
  }

  public static Image collidingFronts(Image image1, VectorUIntList seedPoints1, VectorUIntList seedPoints2, boolean applyConnectivity, double negativeEpsilon) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedPoints1), seedPoints1, VectorUIntList.getCPtr(seedPoints2), seedPoints2, applyConnectivity, negativeEpsilon), true);
  }

  public static Image collidingFronts(Image image1, VectorUIntList seedPoints1, VectorUIntList seedPoints2, boolean applyConnectivity) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedPoints1), seedPoints1, VectorUIntList.getCPtr(seedPoints2), seedPoints2, applyConnectivity), true);
  }

  public static Image collidingFronts(Image image1, VectorUIntList seedPoints1, VectorUIntList seedPoints2) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedPoints1), seedPoints1, VectorUIntList.getCPtr(seedPoints2), seedPoints2), true);
  }

  public static Image collidingFronts(Image image1, VectorUIntList seedPoints1) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedPoints1), seedPoints1), true);
  }

  public static Image collidingFronts(Image image1) {
    return new Image(SimpleITKJNI.collidingFronts__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image complexToImaginary(Image image1) {
    return new Image(SimpleITKJNI.complexToImaginary(Image.getCPtr(image1), image1), true);
  }

  public static Image complexToModulus(Image image1) {
    return new Image(SimpleITKJNI.complexToModulus(Image.getCPtr(image1), image1), true);
  }

  public static Image complexToPhase(Image image1) {
    return new Image(SimpleITKJNI.complexToPhase(Image.getCPtr(image1), image1), true);
  }

  public static Image complexToReal(Image image1) {
    return new Image(SimpleITKJNI.complexToReal(Image.getCPtr(image1), image1), true);
  }

  public static Image compose(VectorOfImage images) {
    return new Image(SimpleITKJNI.compose__SWIG_0(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image compose(Image image1) {
    return new Image(SimpleITKJNI.compose__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image compose(Image image1, Image image2) {
    return new Image(SimpleITKJNI.compose__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image compose(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.compose__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image compose(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.compose__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image compose(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.compose__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image confidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier, long initialNeighborhoodRadius, short replaceValue) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier, initialNeighborhoodRadius, replaceValue), true);
  }

  public static Image confidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier, long initialNeighborhoodRadius) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier, initialNeighborhoodRadius), true);
  }

  public static Image confidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier), true);
  }

  public static Image confidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations), true);
  }

  public static Image confidenceConnected(Image image1, VectorUIntList seedList) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList), true);
  }

  public static Image confidenceConnected(Image image1) {
    return new Image(SimpleITKJNI.confidenceConnected__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image connectedComponent(Image image, Image maskImage, boolean fullyConnected) {
    return new Image(SimpleITKJNI.connectedComponent__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, fullyConnected), true);
  }

  public static Image connectedComponent(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.connectedComponent__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image connectedComponent(Image image, boolean fullyConnected) {
    return new Image(SimpleITKJNI.connectedComponent__SWIG_2(Image.getCPtr(image), image, fullyConnected), true);
  }

  public static Image connectedComponent(Image image) {
    return new Image(SimpleITKJNI.connectedComponent__SWIG_3(Image.getCPtr(image), image), true);
  }

  public static Image connectedThreshold(Image image1, VectorUIntList seedList, double lower, double upper, short replaceValue, ConnectedThresholdImageFilter.ConnectivityType connectivity) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper, replaceValue, connectivity.swigValue()), true);
  }

  public static Image connectedThreshold(Image image1, VectorUIntList seedList, double lower, double upper, short replaceValue) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper, replaceValue), true);
  }

  public static Image connectedThreshold(Image image1, VectorUIntList seedList, double lower, double upper) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper), true);
  }

  public static Image connectedThreshold(Image image1, VectorUIntList seedList, double lower) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower), true);
  }

  public static Image connectedThreshold(Image image1, VectorUIntList seedList) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList), true);
  }

  public static Image connectedThreshold(Image image1) {
    return new Image(SimpleITKJNI.connectedThreshold__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image constantPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound, double constant) {
    return new Image(SimpleITKJNI.constantPad__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound, constant), true);
  }

  public static Image constantPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound) {
    return new Image(SimpleITKJNI.constantPad__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound), true);
  }

  public static Image constantPad(Image image1, VectorUInt32 padLowerBound) {
    return new Image(SimpleITKJNI.constantPad__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound), true);
  }

  public static Image constantPad(Image image1) {
    return new Image(SimpleITKJNI.constantPad__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image convolution(Image image, Image kernelImage, boolean normalize, ConvolutionImageFilter.BoundaryConditionType boundaryCondition, ConvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.convolution__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image convolution(Image image, Image kernelImage, boolean normalize, ConvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.convolution__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image convolution(Image image, Image kernelImage, boolean normalize) {
    return new Image(SimpleITKJNI.convolution__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize), true);
  }

  public static Image convolution(Image image, Image kernelImage) {
    return new Image(SimpleITKJNI.convolution__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage), true);
  }

  public static Image cos(Image image1) {
    return new Image(SimpleITKJNI.cos(Image.getCPtr(image1), image1), true);
  }

  public static Image crop(Image image1, VectorUInt32 lowerBoundaryCropSize, VectorUInt32 upperBoundaryCropSize) {
    return new Image(SimpleITKJNI.crop__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(lowerBoundaryCropSize), lowerBoundaryCropSize, VectorUInt32.getCPtr(upperBoundaryCropSize), upperBoundaryCropSize), true);
  }

  public static Image crop(Image image1, VectorUInt32 lowerBoundaryCropSize) {
    return new Image(SimpleITKJNI.crop__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(lowerBoundaryCropSize), lowerBoundaryCropSize), true);
  }

  public static Image crop(Image image1) {
    return new Image(SimpleITKJNI.crop__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image curvatureAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter, long conductanceScalingUpdateInterval, long numberOfIterations) {
    return new Image(SimpleITKJNI.curvatureAnisotropicDiffusion__SWIG_0(Image.getCPtr(image1), image1, timeStep, conductanceParameter, conductanceScalingUpdateInterval, numberOfIterations), true);
  }

  public static Image curvatureAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter, long conductanceScalingUpdateInterval) {
    return new Image(SimpleITKJNI.curvatureAnisotropicDiffusion__SWIG_1(Image.getCPtr(image1), image1, timeStep, conductanceParameter, conductanceScalingUpdateInterval), true);
  }

  public static Image curvatureAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter) {
    return new Image(SimpleITKJNI.curvatureAnisotropicDiffusion__SWIG_2(Image.getCPtr(image1), image1, timeStep, conductanceParameter), true);
  }

  public static Image curvatureAnisotropicDiffusion(Image image1, double timeStep) {
    return new Image(SimpleITKJNI.curvatureAnisotropicDiffusion__SWIG_3(Image.getCPtr(image1), image1, timeStep), true);
  }

  public static Image curvatureAnisotropicDiffusion(Image image1) {
    return new Image(SimpleITKJNI.curvatureAnisotropicDiffusion__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image curvatureFlow(Image image1, double timeStep, long numberOfIterations) {
    return new Image(SimpleITKJNI.curvatureFlow__SWIG_0(Image.getCPtr(image1), image1, timeStep, numberOfIterations), true);
  }

  public static Image curvatureFlow(Image image1, double timeStep) {
    return new Image(SimpleITKJNI.curvatureFlow__SWIG_1(Image.getCPtr(image1), image1, timeStep), true);
  }

  public static Image curvatureFlow(Image image1) {
    return new Image(SimpleITKJNI.curvatureFlow__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image cyclicShift(Image image1, VectorInt32 shift) {
    return new Image(SimpleITKJNI.cyclicShift__SWIG_0(Image.getCPtr(image1), image1, VectorInt32.getCPtr(shift), shift), true);
  }

  public static Image cyclicShift(Image image1) {
    return new Image(SimpleITKJNI.cyclicShift__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image dICOMOrient(Image image1, String desiredCoordinateOrientation) {
    return new Image(SimpleITKJNI.dICOMOrient__SWIG_0(Image.getCPtr(image1), image1, desiredCoordinateOrientation), true);
  }

  public static Image dICOMOrient(Image image1) {
    return new Image(SimpleITKJNI.dICOMOrient__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image danielssonDistanceMap(Image image1, boolean inputIsBinary, boolean squaredDistance, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.danielssonDistanceMap__SWIG_0(Image.getCPtr(image1), image1, inputIsBinary, squaredDistance, useImageSpacing), true);
  }

  public static Image danielssonDistanceMap(Image image1, boolean inputIsBinary, boolean squaredDistance) {
    return new Image(SimpleITKJNI.danielssonDistanceMap__SWIG_1(Image.getCPtr(image1), image1, inputIsBinary, squaredDistance), true);
  }

  public static Image danielssonDistanceMap(Image image1, boolean inputIsBinary) {
    return new Image(SimpleITKJNI.danielssonDistanceMap__SWIG_2(Image.getCPtr(image1), image1, inputIsBinary), true);
  }

  public static Image danielssonDistanceMap(Image image1) {
    return new Image(SimpleITKJNI.danielssonDistanceMap__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image derivative(Image image1, long direction, long order, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.derivative__SWIG_0(Image.getCPtr(image1), image1, direction, order, useImageSpacing), true);
  }

  public static Image derivative(Image image1, long direction, long order) {
    return new Image(SimpleITKJNI.derivative__SWIG_1(Image.getCPtr(image1), image1, direction, order), true);
  }

  public static Image derivative(Image image1, long direction) {
    return new Image(SimpleITKJNI.derivative__SWIG_2(Image.getCPtr(image1), image1, direction), true);
  }

  public static Image derivative(Image image1) {
    return new Image(SimpleITKJNI.derivative__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image dilateObjectMorphology(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double objectValue) {
    return new Image(SimpleITKJNI.dilateObjectMorphology__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), objectValue), true);
  }

  public static Image dilateObjectMorphology(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.dilateObjectMorphology__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image dilateObjectMorphology(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.dilateObjectMorphology__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image dilateObjectMorphology(Image image1) {
    return new Image(SimpleITKJNI.dilateObjectMorphology__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance, VectorUInt32 order, long maximumKernelWidth, double maximumError, boolean useImageSpacing, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_0(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, VectorUInt32.getCPtr(order), order, maximumKernelWidth, maximumError, useImageSpacing, normalizeAcrossScale), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance, VectorUInt32 order, long maximumKernelWidth, double maximumError, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_1(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, VectorUInt32.getCPtr(order), order, maximumKernelWidth, maximumError, useImageSpacing), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance, VectorUInt32 order, long maximumKernelWidth, double maximumError) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_2(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, VectorUInt32.getCPtr(order), order, maximumKernelWidth, maximumError), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance, VectorUInt32 order, long maximumKernelWidth) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_3(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, VectorUInt32.getCPtr(order), order, maximumKernelWidth), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance, VectorUInt32 order) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_4(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, VectorUInt32.getCPtr(order), order), true);
  }

  public static Image discreteGaussianDerivative(Image image1, VectorDouble variance) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_5(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance), true);
  }

  public static Image discreteGaussianDerivative(Image image1) {
    return new Image(SimpleITKJNI.discreteGaussianDerivative__SWIG_6(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, VectorDouble variance, long maximumKernelWidth, VectorDouble maximumError, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_4(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, maximumKernelWidth, VectorDouble.getCPtr(maximumError), maximumError, useImageSpacing), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, VectorDouble variance, long maximumKernelWidth, VectorDouble maximumError) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_5(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, maximumKernelWidth, VectorDouble.getCPtr(maximumError), maximumError), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, VectorDouble variance, long maximumKernelWidth) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_6(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance, maximumKernelWidth), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1, VectorDouble variance) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_7(Image.getCPtr(image1), image1, VectorDouble.getCPtr(variance), variance), true);
  }

  /**
Image itk::simple::DiscreteGaussian(const Image &amp;image1, double variance, unsigned int
maximumKernelWidth=32u, double maximumError=0.01, bool
useImageSpacing=true)

Blurs an image by separable convolution with discrete gaussian
kernels. This filter performs Gaussian blurring by separable
convolution of an image and a discrete Gaussian operator (kernel).


This function directly calls the execute method of DiscreteGaussianImageFilter in order to support a procedural API


See:
 itk::simple::DiscreteGaussianImageFilter for the object oriented interface


*/
public  static Image discreteGaussian(Image image1) {
    return new Image(SimpleITKJNI.discreteGaussian__SWIG_8(Image.getCPtr(image1), image1), true);
  }

  public static Image displacementFieldJacobianDeterminant(Image image1, boolean useImageSpacing, VectorDouble derivativeWeights) {
    return new Image(SimpleITKJNI.displacementFieldJacobianDeterminant__SWIG_0(Image.getCPtr(image1), image1, useImageSpacing, VectorDouble.getCPtr(derivativeWeights), derivativeWeights), true);
  }

  public static Image displacementFieldJacobianDeterminant(Image image1, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.displacementFieldJacobianDeterminant__SWIG_1(Image.getCPtr(image1), image1, useImageSpacing), true);
  }

  public static Image displacementFieldJacobianDeterminant(Image image1) {
    return new Image(SimpleITKJNI.displacementFieldJacobianDeterminant__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::DivideFloor(Image &amp;&amp;image1, double constant)
*/
public  static Image divideFloor(Image image1, Image image2) {
    return new Image(SimpleITKJNI.divideFloor__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::DivideFloor(Image &amp;&amp;image1, double constant)
*/
public  static Image divideFloor(Image image1, double constant) {
    return new Image(SimpleITKJNI.divideFloor__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::DivideFloor(Image &amp;&amp;image1, double constant)
*/
public  static Image divideFloor(double constant, Image image2) {
    return new Image(SimpleITKJNI.divideFloor__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Divide(Image &amp;&amp;image1, double constant)
*/
public  static Image divide(Image image1, Image image2) {
    return new Image(SimpleITKJNI.divide__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Divide(Image &amp;&amp;image1, double constant)
*/
public  static Image divide(Image image1, double constant) {
    return new Image(SimpleITKJNI.divide__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Divide(Image &amp;&amp;image1, double constant)
*/
public  static Image divide(double constant, Image image2) {
    return new Image(SimpleITKJNI.divide__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::DivideReal(Image &amp;&amp;image1, double constant)
*/
public  static Image divideReal(Image image1, Image image2) {
    return new Image(SimpleITKJNI.divideReal__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::DivideReal(Image &amp;&amp;image1, double constant)
*/
public  static Image divideReal(Image image1, double constant) {
    return new Image(SimpleITKJNI.divideReal__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::DivideReal(Image &amp;&amp;image1, double constant)
*/
public  static Image divideReal(double constant, Image image2) {
    return new Image(SimpleITKJNI.divideReal__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2, double threshold3, double threshold4, short insideValue, short outsideValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_0(Image.getCPtr(image1), image1, threshold1, threshold2, threshold3, threshold4, insideValue, outsideValue, fullyConnected), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2, double threshold3, double threshold4, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_1(Image.getCPtr(image1), image1, threshold1, threshold2, threshold3, threshold4, insideValue, outsideValue), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2, double threshold3, double threshold4, short insideValue) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_2(Image.getCPtr(image1), image1, threshold1, threshold2, threshold3, threshold4, insideValue), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2, double threshold3, double threshold4) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_3(Image.getCPtr(image1), image1, threshold1, threshold2, threshold3, threshold4), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2, double threshold3) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_4(Image.getCPtr(image1), image1, threshold1, threshold2, threshold3), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1, double threshold2) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_5(Image.getCPtr(image1), image1, threshold1, threshold2), true);
  }

  public static Image doubleThreshold(Image image1, double threshold1) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_6(Image.getCPtr(image1), image1, threshold1), true);
  }

  public static Image doubleThreshold(Image image1) {
    return new Image(SimpleITKJNI.doubleThreshold__SWIG_7(Image.getCPtr(image1), image1), true);
  }

  public static Image edgePotential(Image image1) {
    return new Image(SimpleITKJNI.edgePotential(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, Image image2) {
    return new Image(SimpleITKJNI.equal__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(Image image1, double constant) {
    return new Image(SimpleITKJNI.equal__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.equal__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Equal(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image equal(double constant, Image image2) {
    return new Image(SimpleITKJNI.equal__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image erodeObjectMorphology(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double objectValue, double backgroundValue) {
    return new Image(SimpleITKJNI.erodeObjectMorphology__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), objectValue, backgroundValue), true);
  }

  public static Image erodeObjectMorphology(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, double objectValue) {
    return new Image(SimpleITKJNI.erodeObjectMorphology__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), objectValue), true);
  }

  public static Image erodeObjectMorphology(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.erodeObjectMorphology__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image erodeObjectMorphology(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.erodeObjectMorphology__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image erodeObjectMorphology(Image image1) {
    return new Image(SimpleITKJNI.erodeObjectMorphology__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image exp(Image image1) {
    return new Image(SimpleITKJNI.exp(Image.getCPtr(image1), image1), true);
  }

  public static Image expNegative(Image image1) {
    return new Image(SimpleITKJNI.expNegative(Image.getCPtr(image1), image1), true);
  }

  public static Image expand(Image image1, VectorUInt32 expandFactors, InterpolatorEnum interpolator) {
    return new Image(SimpleITKJNI.expand__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(expandFactors), expandFactors, interpolator.swigValue()), true);
  }

  public static Image expand(Image image1, VectorUInt32 expandFactors) {
    return new Image(SimpleITKJNI.expand__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(expandFactors), expandFactors), true);
  }

  public static Image expand(Image image1) {
    return new Image(SimpleITKJNI.expand__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image fFTConvolution(Image image, Image kernelImage, boolean normalize, FFTConvolutionImageFilter.BoundaryConditionType boundaryCondition, FFTConvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.fFTConvolution__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image fFTConvolution(Image image, Image kernelImage, boolean normalize, FFTConvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.fFTConvolution__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image fFTConvolution(Image image, Image kernelImage, boolean normalize) {
    return new Image(SimpleITKJNI.fFTConvolution__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage, normalize), true);
  }

  public static Image fFTConvolution(Image image, Image kernelImage) {
    return new Image(SimpleITKJNI.fFTConvolution__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage), true);
  }

  public static Image fFTNormalizedCorrelation(Image fixedImage, Image movingImage, java.math.BigInteger requiredNumberOfOverlappingPixels, double requiredFractionOfOverlappingPixels) {
    return new Image(SimpleITKJNI.fFTNormalizedCorrelation__SWIG_0(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, requiredNumberOfOverlappingPixels, requiredFractionOfOverlappingPixels), true);
  }

  public static Image fFTNormalizedCorrelation(Image fixedImage, Image movingImage, java.math.BigInteger requiredNumberOfOverlappingPixels) {
    return new Image(SimpleITKJNI.fFTNormalizedCorrelation__SWIG_1(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, requiredNumberOfOverlappingPixels), true);
  }

  public static Image fFTNormalizedCorrelation(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.fFTNormalizedCorrelation__SWIG_2(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

  public static Image fFTPad(Image image1, FFTPadImageFilter.BoundaryConditionType boundaryCondition, int sizeGreatestPrimeFactor) {
    return new Image(SimpleITKJNI.fFTPad__SWIG_0(Image.getCPtr(image1), image1, boundaryCondition.swigValue(), sizeGreatestPrimeFactor), true);
  }

  public static Image fFTPad(Image image1, FFTPadImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.fFTPad__SWIG_1(Image.getCPtr(image1), image1, boundaryCondition.swigValue()), true);
  }

  public static Image fFTPad(Image image1) {
    return new Image(SimpleITKJNI.fFTPad__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image fFTShift(Image image1, boolean inverse) {
    return new Image(SimpleITKJNI.fFTShift__SWIG_0(Image.getCPtr(image1), image1, inverse), true);
  }

  public static Image fFTShift(Image image1) {
    return new Image(SimpleITKJNI.fFTShift__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image fastApproximateRank(Image image1, double rank, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.fastApproximateRank__SWIG_0(Image.getCPtr(image1), image1, rank, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image fastApproximateRank(Image image1, double rank) {
    return new Image(SimpleITKJNI.fastApproximateRank__SWIG_1(Image.getCPtr(image1), image1, rank), true);
  }

  public static Image fastApproximateRank(Image image1) {
    return new Image(SimpleITKJNI.fastApproximateRank__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image fastMarchingBase(Image image1, VectorUIntList trialPoints, double normalizationFactor, double stoppingValue, FastMarchingBaseImageFilter.TopologyCheckType topologyCheck, VectorDouble initialTrialValues) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor, stoppingValue, topologyCheck.swigValue(), VectorDouble.getCPtr(initialTrialValues), initialTrialValues), true);
  }

  public static Image fastMarchingBase(Image image1, VectorUIntList trialPoints, double normalizationFactor, double stoppingValue, FastMarchingBaseImageFilter.TopologyCheckType topologyCheck) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor, stoppingValue, topologyCheck.swigValue()), true);
  }

  public static Image fastMarchingBase(Image image1, VectorUIntList trialPoints, double normalizationFactor, double stoppingValue) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor, stoppingValue), true);
  }

  public static Image fastMarchingBase(Image image1, VectorUIntList trialPoints, double normalizationFactor) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor), true);
  }

  public static Image fastMarchingBase(Image image1, VectorUIntList trialPoints) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints), true);
  }

  public static Image fastMarchingBase(Image image1) {
    return new Image(SimpleITKJNI.fastMarchingBase__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image fastMarching(Image image1, VectorUIntList trialPoints, double normalizationFactor, double stoppingValue, VectorDouble initialTrialValues) {
    return new Image(SimpleITKJNI.fastMarching__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor, stoppingValue, VectorDouble.getCPtr(initialTrialValues), initialTrialValues), true);
  }

  public static Image fastMarching(Image image1, VectorUIntList trialPoints, double normalizationFactor, double stoppingValue) {
    return new Image(SimpleITKJNI.fastMarching__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor, stoppingValue), true);
  }

  public static Image fastMarching(Image image1, VectorUIntList trialPoints, double normalizationFactor) {
    return new Image(SimpleITKJNI.fastMarching__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, normalizationFactor), true);
  }

  public static Image fastMarching(Image image1, VectorUIntList trialPoints) {
    return new Image(SimpleITKJNI.fastMarching__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints), true);
  }

  public static Image fastMarching(Image image1) {
    return new Image(SimpleITKJNI.fastMarching__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints, long numberOfTargets, VectorUIntList targetPoints, double targetOffset, double normalizationFactor, VectorDouble initialTrialValues) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, numberOfTargets, VectorUIntList.getCPtr(targetPoints), targetPoints, targetOffset, normalizationFactor, VectorDouble.getCPtr(initialTrialValues), initialTrialValues), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints, long numberOfTargets, VectorUIntList targetPoints, double targetOffset, double normalizationFactor) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, numberOfTargets, VectorUIntList.getCPtr(targetPoints), targetPoints, targetOffset, normalizationFactor), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints, long numberOfTargets, VectorUIntList targetPoints, double targetOffset) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, numberOfTargets, VectorUIntList.getCPtr(targetPoints), targetPoints, targetOffset), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints, long numberOfTargets, VectorUIntList targetPoints) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, numberOfTargets, VectorUIntList.getCPtr(targetPoints), targetPoints), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints, long numberOfTargets) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints, numberOfTargets), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1, VectorUIntList trialPoints) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_5(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(trialPoints), trialPoints), true);
  }

  public static Image fastMarchingUpwindGradient(Image image1) {
    return new Image(SimpleITKJNI.fastMarchingUpwindGradient__SWIG_6(Image.getCPtr(image1), image1), true);
  }

  public static Image flip(Image image1, VectorBool flipAxes, boolean flipAboutOrigin) {
    return new Image(SimpleITKJNI.flip__SWIG_0(Image.getCPtr(image1), image1, VectorBool.getCPtr(flipAxes), flipAxes, flipAboutOrigin), true);
  }

  public static Image flip(Image image1, VectorBool flipAxes) {
    return new Image(SimpleITKJNI.flip__SWIG_1(Image.getCPtr(image1), image1, VectorBool.getCPtr(flipAxes), flipAxes), true);
  }

  public static Image flip(Image image1) {
    return new Image(SimpleITKJNI.flip__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image forwardFFT(Image image1) {
    return new Image(SimpleITKJNI.forwardFFT(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double frequency, VectorDouble origin, VectorDouble spacing, VectorDouble direction) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_0(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, frequency, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double frequency, VectorDouble origin, VectorDouble spacing) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_1(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, frequency, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double frequency, VectorDouble origin) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_2(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, frequency, VectorDouble.getCPtr(origin), origin), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double frequency) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_3(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, frequency), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_4(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_5(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType, VectorUInt32 size) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_6(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource(PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.gaborSource__SWIG_7(outputPixelType.swigValue()), true);
  }

  /**
Image itk::simple::GaborSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double frequency=0.4, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;())

Generate an n-dimensional image of a Gabor filter.


This function directly calls the execute method of GaborImageSource in order to support a procedural API


See:
 itk::simple::GaborImageSource for the object oriented interface


*/
public  static Image gaborSource() {
    return new Image(SimpleITKJNI.gaborSource__SWIG_8(), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double scale, VectorDouble origin, VectorDouble spacing, VectorDouble direction, boolean normalized) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_0(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction, normalized), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double scale, VectorDouble origin, VectorDouble spacing, VectorDouble direction) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_1(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double scale, VectorDouble origin, VectorDouble spacing) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_2(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double scale, VectorDouble origin) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_3(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, scale, VectorDouble.getCPtr(origin), origin), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean, double scale) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_4(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean, scale), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble mean) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_5(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(mean), mean), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_6(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType, VectorUInt32 size) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_7(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource(PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_8(outputPixelType.swigValue()), true);
  }

  /**
Image itk::simple::GaussianSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 16.0), std::vector&lt; double &gt; mean=std::vector&lt; double
&gt;(3, 32.0), double scale=255, std::vector&lt; double &gt;
origin=std::vector&lt; double &gt;(3, 0.0), std::vector&lt; double
&gt; spacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; direction=std::vector&lt; double &gt;(), bool
normalized=false)

Generate an n-dimensional image of a Gaussian.


This function directly calls the execute method of GaussianImageSource in order to support a procedural API


See:
 itk::simple::GaussianImageSource for the object oriented interface


*/
public  static Image gaussianSource() {
    return new Image(SimpleITKJNI.gaussianSource__SWIG_9(), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, long numberOfIterations, boolean reverseExpansionDirection) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling, numberOfIterations, reverseExpansionDirection), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling, long numberOfIterations) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling, numberOfIterations), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, double advectionScaling) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, advectionScaling), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage, double maximumRMSError) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError), true);
  }

  public static Image geodesicActiveContourLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.geodesicActiveContourLevelSet__SWIG_6(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image gradientAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter, long conductanceScalingUpdateInterval, long numberOfIterations) {
    return new Image(SimpleITKJNI.gradientAnisotropicDiffusion__SWIG_0(Image.getCPtr(image1), image1, timeStep, conductanceParameter, conductanceScalingUpdateInterval, numberOfIterations), true);
  }

  public static Image gradientAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter, long conductanceScalingUpdateInterval) {
    return new Image(SimpleITKJNI.gradientAnisotropicDiffusion__SWIG_1(Image.getCPtr(image1), image1, timeStep, conductanceParameter, conductanceScalingUpdateInterval), true);
  }

  public static Image gradientAnisotropicDiffusion(Image image1, double timeStep, double conductanceParameter) {
    return new Image(SimpleITKJNI.gradientAnisotropicDiffusion__SWIG_2(Image.getCPtr(image1), image1, timeStep, conductanceParameter), true);
  }

  public static Image gradientAnisotropicDiffusion(Image image1, double timeStep) {
    return new Image(SimpleITKJNI.gradientAnisotropicDiffusion__SWIG_3(Image.getCPtr(image1), image1, timeStep), true);
  }

  public static Image gradientAnisotropicDiffusion(Image image1) {
    return new Image(SimpleITKJNI.gradientAnisotropicDiffusion__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image gradient(Image image1, boolean useImageSpacing, boolean useImageDirection) {
    return new Image(SimpleITKJNI.gradient__SWIG_0(Image.getCPtr(image1), image1, useImageSpacing, useImageDirection), true);
  }

  public static Image gradient(Image image1, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.gradient__SWIG_1(Image.getCPtr(image1), image1, useImageSpacing), true);
  }

  public static Image gradient(Image image1) {
    return new Image(SimpleITKJNI.gradient__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image gradientMagnitude(Image image1, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.gradientMagnitude__SWIG_0(Image.getCPtr(image1), image1, useImageSpacing), true);
  }

  public static Image gradientMagnitude(Image image1) {
    return new Image(SimpleITKJNI.gradientMagnitude__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image gradientMagnitudeRecursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.gradientMagnitudeRecursiveGaussian__SWIG_0(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale), true);
  }

  public static Image gradientMagnitudeRecursiveGaussian(Image image1, double sigma) {
    return new Image(SimpleITKJNI.gradientMagnitudeRecursiveGaussian__SWIG_1(Image.getCPtr(image1), image1, sigma), true);
  }

  public static Image gradientMagnitudeRecursiveGaussian(Image image1) {
    return new Image(SimpleITKJNI.gradientMagnitudeRecursiveGaussian__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image gradientRecursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale, boolean useImageDirection) {
    return new Image(SimpleITKJNI.gradientRecursiveGaussian__SWIG_0(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale, useImageDirection), true);
  }

  public static Image gradientRecursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.gradientRecursiveGaussian__SWIG_1(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale), true);
  }

  public static Image gradientRecursiveGaussian(Image image1, double sigma) {
    return new Image(SimpleITKJNI.gradientRecursiveGaussian__SWIG_2(Image.getCPtr(image1), image1, sigma), true);
  }

  public static Image gradientRecursiveGaussian(Image image1) {
    return new Image(SimpleITKJNI.gradientRecursiveGaussian__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleConnectedClosing(Image image1, VectorUInt32 seed, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleConnectedClosing__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed), seed, fullyConnected), true);
  }

  public static Image grayscaleConnectedClosing(Image image1, VectorUInt32 seed) {
    return new Image(SimpleITKJNI.grayscaleConnectedClosing__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed), seed), true);
  }

  public static Image grayscaleConnectedClosing(Image image1) {
    return new Image(SimpleITKJNI.grayscaleConnectedClosing__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleConnectedOpening(Image image1, VectorUInt32 seed, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleConnectedOpening__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed), seed, fullyConnected), true);
  }

  public static Image grayscaleConnectedOpening(Image image1, VectorUInt32 seed) {
    return new Image(SimpleITKJNI.grayscaleConnectedOpening__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed), seed), true);
  }

  public static Image grayscaleConnectedOpening(Image image1) {
    return new Image(SimpleITKJNI.grayscaleConnectedOpening__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleDilate(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.grayscaleDilate__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image grayscaleDilate(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.grayscaleDilate__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image grayscaleDilate(Image image1) {
    return new Image(SimpleITKJNI.grayscaleDilate__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleErode(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.grayscaleErode__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image grayscaleErode(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.grayscaleErode__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image grayscaleErode(Image image1) {
    return new Image(SimpleITKJNI.grayscaleErode__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleFillhole(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleFillhole__SWIG_0(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image grayscaleFillhole(Image image1) {
    return new Image(SimpleITKJNI.grayscaleFillhole__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleGeodesicDilate(Image image1, Image image2, boolean runOneIteration, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleGeodesicDilate__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, runOneIteration, fullyConnected), true);
  }

  public static Image grayscaleGeodesicDilate(Image image1, Image image2, boolean runOneIteration) {
    return new Image(SimpleITKJNI.grayscaleGeodesicDilate__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, runOneIteration), true);
  }

  public static Image grayscaleGeodesicDilate(Image image1, Image image2) {
    return new Image(SimpleITKJNI.grayscaleGeodesicDilate__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image grayscaleGeodesicErode(Image image1, Image image2, boolean runOneIteration, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleGeodesicErode__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, runOneIteration, fullyConnected), true);
  }

  public static Image grayscaleGeodesicErode(Image image1, Image image2, boolean runOneIteration) {
    return new Image(SimpleITKJNI.grayscaleGeodesicErode__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, runOneIteration), true);
  }

  public static Image grayscaleGeodesicErode(Image image1, Image image2) {
    return new Image(SimpleITKJNI.grayscaleGeodesicErode__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image grayscaleGrindPeak(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.grayscaleGrindPeak__SWIG_0(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image grayscaleGrindPeak(Image image1) {
    return new Image(SimpleITKJNI.grayscaleGrindPeak__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleMorphologicalClosing(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean safeBorder) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalClosing__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), safeBorder), true);
  }

  public static Image grayscaleMorphologicalClosing(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalClosing__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image grayscaleMorphologicalClosing(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalClosing__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image grayscaleMorphologicalClosing(Image image1) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalClosing__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image grayscaleMorphologicalOpening(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean safeBorder) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalOpening__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), safeBorder), true);
  }

  public static Image grayscaleMorphologicalOpening(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalOpening__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image grayscaleMorphologicalOpening(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalOpening__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image grayscaleMorphologicalOpening(Image image1) {
    return new Image(SimpleITKJNI.grayscaleMorphologicalOpening__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, Image image2) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(Image image1, double constant) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::GreaterEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greaterEqual(double constant, Image image2) {
    return new Image(SimpleITKJNI.greaterEqual__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, Image image2) {
    return new Image(SimpleITKJNI.greater__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(Image image1, double constant) {
    return new Image(SimpleITKJNI.greater__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.greater__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Greater(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image greater(double constant, Image image2) {
    return new Image(SimpleITKJNI.greater__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset, double scale, VectorDouble origin, VectorDouble spacing, VectorDouble direction, VectorBool whichDimensions) {
    return new Image(SimpleITKJNI.gridSource__SWIG_0(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction, VectorBool.getCPtr(whichDimensions), whichDimensions), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset, double scale, VectorDouble origin, VectorDouble spacing, VectorDouble direction) {
    return new Image(SimpleITKJNI.gridSource__SWIG_1(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset, double scale, VectorDouble origin, VectorDouble spacing) {
    return new Image(SimpleITKJNI.gridSource__SWIG_2(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset, scale, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset, double scale, VectorDouble origin) {
    return new Image(SimpleITKJNI.gridSource__SWIG_3(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset, scale, VectorDouble.getCPtr(origin), origin), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset, double scale) {
    return new Image(SimpleITKJNI.gridSource__SWIG_4(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset, scale), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing, VectorDouble gridOffset) {
    return new Image(SimpleITKJNI.gridSource__SWIG_5(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing, VectorDouble.getCPtr(gridOffset), gridOffset), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma, VectorDouble gridSpacing) {
    return new Image(SimpleITKJNI.gridSource__SWIG_6(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma, VectorDouble.getCPtr(gridSpacing), gridSpacing), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble sigma) {
    return new Image(SimpleITKJNI.gridSource__SWIG_7(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(sigma), sigma), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType, VectorUInt32 size) {
    return new Image(SimpleITKJNI.gridSource__SWIG_8(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource(PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.gridSource__SWIG_9(outputPixelType.swigValue()), true);
  }

  /**
Image itk::simple::GridSource(PixelIDValueEnum outputPixelType=itk::simple::sitkFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; sigma=std::vector&lt; double
&gt;(3, 0.5), std::vector&lt; double &gt; gridSpacing=std::vector&lt;
double &gt;(3, 4.0), std::vector&lt; double &gt;
gridOffset=std::vector&lt; double &gt;(3, 0.0), double scale=255.0,
std::vector&lt; double &gt; origin=std::vector&lt; double &gt;(3,
0.0), std::vector&lt; double &gt; spacing=std::vector&lt; double
&gt;(3, 1.0), std::vector&lt; double &gt; direction=std::vector&lt;
double &gt;(), std::vector&lt; bool &gt;
whichDimensions=std::vector&lt; bool &gt;(3, true))

Generate an n-dimensional image of a grid.


This function directly calls the execute method of GridImageSource in order to support a procedural API


See:
 itk::simple::GridImageSource for the object oriented interface


*/
public  static Image gridSource() {
    return new Image(SimpleITKJNI.gridSource__SWIG_10(), true);
  }

  public static Image hConcave(Image image1, double height, boolean fullyConnected) {
    return new Image(SimpleITKJNI.hConcave__SWIG_0(Image.getCPtr(image1), image1, height, fullyConnected), true);
  }

  public static Image hConcave(Image image1, double height) {
    return new Image(SimpleITKJNI.hConcave__SWIG_1(Image.getCPtr(image1), image1, height), true);
  }

  public static Image hConcave(Image image1) {
    return new Image(SimpleITKJNI.hConcave__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image hConvex(Image image1, double height, boolean fullyConnected) {
    return new Image(SimpleITKJNI.hConvex__SWIG_0(Image.getCPtr(image1), image1, height, fullyConnected), true);
  }

  public static Image hConvex(Image image1, double height) {
    return new Image(SimpleITKJNI.hConvex__SWIG_1(Image.getCPtr(image1), image1, height), true);
  }

  public static Image hConvex(Image image1) {
    return new Image(SimpleITKJNI.hConvex__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image hMaxima(Image image1, double height) {
    return new Image(SimpleITKJNI.hMaxima__SWIG_0(Image.getCPtr(image1), image1, height), true);
  }

  public static Image hMaxima(Image image1) {
    return new Image(SimpleITKJNI.hMaxima__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image hMinima(Image image1, double height, boolean fullyConnected) {
    return new Image(SimpleITKJNI.hMinima__SWIG_0(Image.getCPtr(image1), image1, height, fullyConnected), true);
  }

  public static Image hMinima(Image image1, double height) {
    return new Image(SimpleITKJNI.hMinima__SWIG_1(Image.getCPtr(image1), image1, height), true);
  }

  public static Image hMinima(Image image1) {
    return new Image(SimpleITKJNI.hMinima__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image halfHermitianToRealInverseFFT(Image image1, boolean actualXDimensionIsOdd) {
    return new Image(SimpleITKJNI.halfHermitianToRealInverseFFT__SWIG_0(Image.getCPtr(image1), image1, actualXDimensionIsOdd), true);
  }

  public static Image halfHermitianToRealInverseFFT(Image image1) {
    return new Image(SimpleITKJNI.halfHermitianToRealInverseFFT__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image histogramMatching(Image image, Image referenceImage, long numberOfHistogramLevels, long numberOfMatchPoints, boolean thresholdAtMeanIntensity) {
    return new Image(SimpleITKJNI.histogramMatching__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(referenceImage), referenceImage, numberOfHistogramLevels, numberOfMatchPoints, thresholdAtMeanIntensity), true);
  }

  public static Image histogramMatching(Image image, Image referenceImage, long numberOfHistogramLevels, long numberOfMatchPoints) {
    return new Image(SimpleITKJNI.histogramMatching__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(referenceImage), referenceImage, numberOfHistogramLevels, numberOfMatchPoints), true);
  }

  public static Image histogramMatching(Image image, Image referenceImage, long numberOfHistogramLevels) {
    return new Image(SimpleITKJNI.histogramMatching__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(referenceImage), referenceImage, numberOfHistogramLevels), true);
  }

  public static Image histogramMatching(Image image, Image referenceImage) {
    return new Image(SimpleITKJNI.histogramMatching__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(referenceImage), referenceImage), true);
  }

  public static Image huangThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image huangThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image huangThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image huangThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image huangThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image huangThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image huangThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image huangThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image huangThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image huangThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image huangThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image huangThreshold(Image image) {
    return new Image(SimpleITKJNI.huangThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image intensityWindowing(Image image1, double windowMinimum, double windowMaximum, double outputMinimum, double outputMaximum) {
    return new Image(SimpleITKJNI.intensityWindowing__SWIG_0(Image.getCPtr(image1), image1, windowMinimum, windowMaximum, outputMinimum, outputMaximum), true);
  }

  public static Image intensityWindowing(Image image1, double windowMinimum, double windowMaximum, double outputMinimum) {
    return new Image(SimpleITKJNI.intensityWindowing__SWIG_1(Image.getCPtr(image1), image1, windowMinimum, windowMaximum, outputMinimum), true);
  }

  public static Image intensityWindowing(Image image1, double windowMinimum, double windowMaximum) {
    return new Image(SimpleITKJNI.intensityWindowing__SWIG_2(Image.getCPtr(image1), image1, windowMinimum, windowMaximum), true);
  }

  public static Image intensityWindowing(Image image1, double windowMinimum) {
    return new Image(SimpleITKJNI.intensityWindowing__SWIG_3(Image.getCPtr(image1), image1, windowMinimum), true);
  }

  public static Image intensityWindowing(Image image1) {
    return new Image(SimpleITKJNI.intensityWindowing__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image intermodesThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image intermodesThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image intermodesThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image intermodesThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image intermodesThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image intermodesThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image intermodesThreshold(Image image) {
    return new Image(SimpleITKJNI.intermodesThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image inverseDeconvolution(Image image1, Image image2, double kernelZeroMagnitudeThreshold, boolean normalize, InverseDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, InverseDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.inverseDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, kernelZeroMagnitudeThreshold, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image inverseDeconvolution(Image image1, Image image2, double kernelZeroMagnitudeThreshold, boolean normalize, InverseDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.inverseDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, kernelZeroMagnitudeThreshold, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image inverseDeconvolution(Image image1, Image image2, double kernelZeroMagnitudeThreshold, boolean normalize) {
    return new Image(SimpleITKJNI.inverseDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, kernelZeroMagnitudeThreshold, normalize), true);
  }

  public static Image inverseDeconvolution(Image image1, Image image2, double kernelZeroMagnitudeThreshold) {
    return new Image(SimpleITKJNI.inverseDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, kernelZeroMagnitudeThreshold), true);
  }

  public static Image inverseDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.inverseDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image inverseDisplacementField(Image image1, VectorUInt32 size, VectorDouble outputOrigin, VectorDouble outputSpacing, long subsamplingFactor) {
    return new Image(SimpleITKJNI.inverseDisplacementField__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, subsamplingFactor), true);
  }

  public static Image inverseDisplacementField(Image image1, VectorUInt32 size, VectorDouble outputOrigin, VectorDouble outputSpacing) {
    return new Image(SimpleITKJNI.inverseDisplacementField__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing), true);
  }

  public static Image inverseDisplacementField(Image image1, VectorUInt32 size, VectorDouble outputOrigin) {
    return new Image(SimpleITKJNI.inverseDisplacementField__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin), true);
  }

  public static Image inverseDisplacementField(Image image1, VectorUInt32 size) {
    return new Image(SimpleITKJNI.inverseDisplacementField__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size), true);
  }

  public static Image inverseDisplacementField(Image image1) {
    return new Image(SimpleITKJNI.inverseDisplacementField__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image inverseFFT(Image image1) {
    return new Image(SimpleITKJNI.inverseFFT(Image.getCPtr(image1), image1), true);
  }

  public static Image invertDisplacementField(Image image1, long maximumNumberOfIterations, double maxErrorToleranceThreshold, double meanErrorToleranceThreshold, boolean enforceBoundaryCondition) {
    return new Image(SimpleITKJNI.invertDisplacementField__SWIG_0(Image.getCPtr(image1), image1, maximumNumberOfIterations, maxErrorToleranceThreshold, meanErrorToleranceThreshold, enforceBoundaryCondition), true);
  }

  public static Image invertDisplacementField(Image image1, long maximumNumberOfIterations, double maxErrorToleranceThreshold, double meanErrorToleranceThreshold) {
    return new Image(SimpleITKJNI.invertDisplacementField__SWIG_1(Image.getCPtr(image1), image1, maximumNumberOfIterations, maxErrorToleranceThreshold, meanErrorToleranceThreshold), true);
  }

  public static Image invertDisplacementField(Image image1, long maximumNumberOfIterations, double maxErrorToleranceThreshold) {
    return new Image(SimpleITKJNI.invertDisplacementField__SWIG_2(Image.getCPtr(image1), image1, maximumNumberOfIterations, maxErrorToleranceThreshold), true);
  }

  public static Image invertDisplacementField(Image image1, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.invertDisplacementField__SWIG_3(Image.getCPtr(image1), image1, maximumNumberOfIterations), true);
  }

  public static Image invertDisplacementField(Image image1) {
    return new Image(SimpleITKJNI.invertDisplacementField__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image invertIntensity(Image image1, double maximum) {
    return new Image(SimpleITKJNI.invertIntensity__SWIG_0(Image.getCPtr(image1), image1, maximum), true);
  }

  public static Image invertIntensity(Image image1) {
    return new Image(SimpleITKJNI.invertIntensity__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image isoContourDistance(Image image1, double levelSetValue, double farValue) {
    return new Image(SimpleITKJNI.isoContourDistance__SWIG_0(Image.getCPtr(image1), image1, levelSetValue, farValue), true);
  }

  public static Image isoContourDistance(Image image1, double levelSetValue) {
    return new Image(SimpleITKJNI.isoContourDistance__SWIG_1(Image.getCPtr(image1), image1, levelSetValue), true);
  }

  public static Image isoContourDistance(Image image1) {
    return new Image(SimpleITKJNI.isoContourDistance__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image isoDataThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image isoDataThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image isoDataThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image isoDataThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image isoDataThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image isoDataThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image isoDataThreshold(Image image) {
    return new Image(SimpleITKJNI.isoDataThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double lower, double upper, short replaceValue, double isolatedValueTolerance, boolean findUpperThreshold) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, lower, upper, replaceValue, isolatedValueTolerance, findUpperThreshold), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double lower, double upper, short replaceValue, double isolatedValueTolerance) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, lower, upper, replaceValue, isolatedValueTolerance), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double lower, double upper, short replaceValue) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, lower, upper, replaceValue), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double lower, double upper) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, lower, upper), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double lower) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, lower), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1, VectorUInt32 seed2) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_5(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2), true);
  }

  public static Image isolatedConnected(Image image1, VectorUInt32 seed1) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_6(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1), true);
  }

  public static Image isolatedConnected(Image image1) {
    return new Image(SimpleITKJNI.isolatedConnected__SWIG_7(Image.getCPtr(image1), image1), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double threshold, double upperValueLimit, double isolatedValueTolerance, short replaceValue1, short replaceValue2) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, threshold, upperValueLimit, isolatedValueTolerance, replaceValue1, replaceValue2), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double threshold, double upperValueLimit, double isolatedValueTolerance, short replaceValue1) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, threshold, upperValueLimit, isolatedValueTolerance, replaceValue1), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double threshold, double upperValueLimit, double isolatedValueTolerance) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, threshold, upperValueLimit, isolatedValueTolerance), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double threshold, double upperValueLimit) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, threshold, upperValueLimit), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2, double threshold) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2, threshold), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1, VectorUInt32 seed2) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_5(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1, VectorUInt32.getCPtr(seed2), seed2), true);
  }

  public static Image isolatedWatershed(Image image1, VectorUInt32 seed1) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_6(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(seed1), seed1), true);
  }

  public static Image isolatedWatershed(Image image1) {
    return new Image(SimpleITKJNI.isolatedWatershed__SWIG_7(Image.getCPtr(image1), image1), true);
  }

  public static Image iterativeInverseDisplacementField(Image image1, long numberOfIterations, double stopValue) {
    return new Image(SimpleITKJNI.iterativeInverseDisplacementField__SWIG_0(Image.getCPtr(image1), image1, numberOfIterations, stopValue), true);
  }

  public static Image iterativeInverseDisplacementField(Image image1, long numberOfIterations) {
    return new Image(SimpleITKJNI.iterativeInverseDisplacementField__SWIG_1(Image.getCPtr(image1), image1, numberOfIterations), true);
  }

  public static Image iterativeInverseDisplacementField(Image image1) {
    return new Image(SimpleITKJNI.iterativeInverseDisplacementField__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image joinSeries(VectorOfImage images, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_0(VectorOfImage.getCPtr(images), images, origin, spacing), true);
  }

  public static Image joinSeries(VectorOfImage images, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_1(VectorOfImage.getCPtr(images), images, origin), true);
  }

  public static Image joinSeries(VectorOfImage images) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_2(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image joinSeries(Image image1, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_3(Image.getCPtr(image1), image1, origin, spacing), true);
  }

  public static Image joinSeries(Image image1, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_4(Image.getCPtr(image1), image1, origin), true);
  }

  public static Image joinSeries(Image image1) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image joinSeries(Image image1, Image image2, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_6(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, origin, spacing), true);
  }

  public static Image joinSeries(Image image1, Image image2, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_7(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, origin), true);
  }

  public static Image joinSeries(Image image1, Image image2) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, origin, spacing), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, origin), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_12(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, origin, spacing), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_13(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, origin), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_14(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4, Image image5, double origin, double spacing) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_15(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, origin, spacing), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4, Image image5, double origin) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_16(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, origin), true);
  }

  public static Image joinSeries(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.joinSeries__SWIG_17(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image kittlerIllingworthThreshold(Image image) {
    return new Image(SimpleITKJNI.kittlerIllingworthThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image labelContour(Image image1, boolean fullyConnected, double backgroundValue) {
    return new Image(SimpleITKJNI.labelContour__SWIG_0(Image.getCPtr(image1), image1, fullyConnected, backgroundValue), true);
  }

  public static Image labelContour(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.labelContour__SWIG_1(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image labelContour(Image image1) {
    return new Image(SimpleITKJNI.labelContour__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image labelImageToLabelMap(Image image1, double backgroundValue) {
    return new Image(SimpleITKJNI.labelImageToLabelMap__SWIG_0(Image.getCPtr(image1), image1, backgroundValue), true);
  }

  public static Image labelImageToLabelMap(Image image1) {
    return new Image(SimpleITKJNI.labelImageToLabelMap__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius, VectorUInt32 contourThickness, long sliceDimension, LabelMapContourOverlayImageFilter.ContourTypeType contourType, LabelMapContourOverlayImageFilter.PriorityType priority, VectorUInt8 colormap) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_0(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius, VectorUInt32.getCPtr(contourThickness), contourThickness, sliceDimension, contourType.swigValue(), priority.swigValue(), VectorUInt8.getCPtr(colormap), colormap), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius, VectorUInt32 contourThickness, long sliceDimension, LabelMapContourOverlayImageFilter.ContourTypeType contourType, LabelMapContourOverlayImageFilter.PriorityType priority) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_1(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius, VectorUInt32.getCPtr(contourThickness), contourThickness, sliceDimension, contourType.swigValue(), priority.swigValue()), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius, VectorUInt32 contourThickness, long sliceDimension, LabelMapContourOverlayImageFilter.ContourTypeType contourType) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_2(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius, VectorUInt32.getCPtr(contourThickness), contourThickness, sliceDimension, contourType.swigValue()), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius, VectorUInt32 contourThickness, long sliceDimension) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_3(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius, VectorUInt32.getCPtr(contourThickness), contourThickness, sliceDimension), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius, VectorUInt32 contourThickness) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_4(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius, VectorUInt32.getCPtr(contourThickness), contourThickness), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt32 dilationRadius) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_5(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt32.getCPtr(dilationRadius), dilationRadius), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage, double opacity) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_6(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity), true);
  }

  public static Image labelMapContourOverlay(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.labelMapContourOverlay__SWIG_7(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage, java.math.BigInteger label, double backgroundValue, boolean negated, boolean crop, VectorUInt32 cropBorder) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_0(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, label, backgroundValue, negated, crop, VectorUInt32.getCPtr(cropBorder), cropBorder), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage, java.math.BigInteger label, double backgroundValue, boolean negated, boolean crop) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_1(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, label, backgroundValue, negated, crop), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage, java.math.BigInteger label, double backgroundValue, boolean negated) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_2(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, label, backgroundValue, negated), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage, java.math.BigInteger label, double backgroundValue) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_3(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, label, backgroundValue), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage, java.math.BigInteger label) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_4(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, label), true);
  }

  public static Image labelMapMask(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.labelMapMask__SWIG_5(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image labelMapOverlay(Image labelMapImage, Image featureImage, double opacity, VectorUInt8 colormap) {
    return new Image(SimpleITKJNI.labelMapOverlay__SWIG_0(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity, VectorUInt8.getCPtr(colormap), colormap), true);
  }

  public static Image labelMapOverlay(Image labelMapImage, Image featureImage, double opacity) {
    return new Image(SimpleITKJNI.labelMapOverlay__SWIG_1(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage, opacity), true);
  }

  public static Image labelMapOverlay(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.labelMapOverlay__SWIG_2(Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image labelMapToBinary(Image image1, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.labelMapToBinary__SWIG_0(Image.getCPtr(image1), image1, backgroundValue, foregroundValue), true);
  }

  public static Image labelMapToBinary(Image image1, double backgroundValue) {
    return new Image(SimpleITKJNI.labelMapToBinary__SWIG_1(Image.getCPtr(image1), image1, backgroundValue), true);
  }

  public static Image labelMapToBinary(Image image1) {
    return new Image(SimpleITKJNI.labelMapToBinary__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image labelMapToLabel(Image image1) {
    return new Image(SimpleITKJNI.labelMapToLabel(Image.getCPtr(image1), image1), true);
  }

  public static Image labelMapToRGB(Image image1, VectorUInt8 colormap) {
    return new Image(SimpleITKJNI.labelMapToRGB__SWIG_0(Image.getCPtr(image1), image1, VectorUInt8.getCPtr(colormap), colormap), true);
  }

  public static Image labelMapToRGB(Image image1) {
    return new Image(SimpleITKJNI.labelMapToRGB__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image labelOverlay(Image image, Image labelImage, double opacity, double backgroundValue, VectorUInt8 colormap) {
    return new Image(SimpleITKJNI.labelOverlay__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage, opacity, backgroundValue, VectorUInt8.getCPtr(colormap), colormap), true);
  }

  public static Image labelOverlay(Image image, Image labelImage, double opacity, double backgroundValue) {
    return new Image(SimpleITKJNI.labelOverlay__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage, opacity, backgroundValue), true);
  }

  public static Image labelOverlay(Image image, Image labelImage, double opacity) {
    return new Image(SimpleITKJNI.labelOverlay__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage, opacity), true);
  }

  public static Image labelOverlay(Image image, Image labelImage) {
    return new Image(SimpleITKJNI.labelOverlay__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage), true);
  }

  public static Image labelToRGB(Image image1, double backgroundValue, VectorUInt8 colormap) {
    return new Image(SimpleITKJNI.labelToRGB__SWIG_0(Image.getCPtr(image1), image1, backgroundValue, VectorUInt8.getCPtr(colormap), colormap), true);
  }

  public static Image labelToRGB(Image image1, double backgroundValue) {
    return new Image(SimpleITKJNI.labelToRGB__SWIG_1(Image.getCPtr(image1), image1, backgroundValue), true);
  }

  public static Image labelToRGB(Image image1) {
    return new Image(SimpleITKJNI.labelToRGB__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image labelUniqueLabelMap(Image image1, boolean reverseOrdering) {
    return new Image(SimpleITKJNI.labelUniqueLabelMap__SWIG_0(Image.getCPtr(image1), image1, reverseOrdering), true);
  }

  public static Image labelUniqueLabelMap(Image image1) {
    return new Image(SimpleITKJNI.labelUniqueLabelMap__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image labelVoting(VectorOfImage images, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_0(VectorOfImage.getCPtr(images), images, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(VectorOfImage images) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_1(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image labelVoting(Image image1, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_2(Image.getCPtr(image1), image1, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(Image image1) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image labelVoting(Image image1, Image image2, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(Image image1, Image image2) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_6(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_7(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3, Image image4, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3, Image image4, Image image5, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, labelForUndecidedPixels), true);
  }

  public static Image labelVoting(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.labelVoting__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize, LandweberDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, LandweberDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize, LandweberDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2, double alpha) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha), true);
  }

  public static Image landweberDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.landweberDeconvolution__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image laplacian(Image image1, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.laplacian__SWIG_0(Image.getCPtr(image1), image1, useImageSpacing), true);
  }

  public static Image laplacian(Image image1) {
    return new Image(SimpleITKJNI.laplacian__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image laplacianRecursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.laplacianRecursiveGaussian__SWIG_0(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale), true);
  }

  public static Image laplacianRecursiveGaussian(Image image1, double sigma) {
    return new Image(SimpleITKJNI.laplacianRecursiveGaussian__SWIG_1(Image.getCPtr(image1), image1, sigma), true);
  }

  public static Image laplacianRecursiveGaussian(Image image1) {
    return new Image(SimpleITKJNI.laplacianRecursiveGaussian__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations, boolean reverseExpansionDirection) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations, reverseExpansionDirection), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage, double maximumRMSError) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError), true);
  }

  public static Image laplacianSegmentationLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.laplacianSegmentationLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image laplacianSharpening(Image image1, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.laplacianSharpening__SWIG_0(Image.getCPtr(image1), image1, useImageSpacing), true);
  }

  public static Image laplacianSharpening(Image image1) {
    return new Image(SimpleITKJNI.laplacianSharpening__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, Image image2) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(Image image1, double constant) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::LessEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image lessEqual(double constant, Image image2) {
    return new Image(SimpleITKJNI.lessEqual__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, Image image2) {
    return new Image(SimpleITKJNI.less__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(Image image1, double constant) {
    return new Image(SimpleITKJNI.less__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.less__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::Less(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image less(double constant, Image image2) {
    return new Image(SimpleITKJNI.less__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image liThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image liThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image liThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image liThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image liThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image liThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image liThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image liThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image liThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image liThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image liThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image liThreshold(Image image) {
    return new Image(SimpleITKJNI.liThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image log10(Image image1) {
    return new Image(SimpleITKJNI.log10(Image.getCPtr(image1), image1), true);
  }

  public static Image log(Image image1) {
    return new Image(SimpleITKJNI.log(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::MagnitudeAndPhaseToComplex(Image &amp;&amp;image1, double constant)
*/
public  static Image magnitudeAndPhaseToComplex(Image image1, Image image2) {
    return new Image(SimpleITKJNI.magnitudeAndPhaseToComplex__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::MagnitudeAndPhaseToComplex(Image &amp;&amp;image1, double constant)
*/
public  static Image magnitudeAndPhaseToComplex(Image image1, double constant) {
    return new Image(SimpleITKJNI.magnitudeAndPhaseToComplex__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::MagnitudeAndPhaseToComplex(Image &amp;&amp;image1, double constant)
*/
public  static Image magnitudeAndPhaseToComplex(double constant, Image image2) {
    return new Image(SimpleITKJNI.magnitudeAndPhaseToComplex__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image mask(Image image, Image maskImage, double outsideValue, double maskingValue) {
    return new Image(SimpleITKJNI.mask__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, outsideValue, maskingValue), true);
  }

  public static Image mask(Image image, Image maskImage, double outsideValue) {
    return new Image(SimpleITKJNI.mask__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, outsideValue), true);
  }

  public static Image mask(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.mask__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image maskNegated(Image image, Image maskImage, double outsideValue, double maskingValue) {
    return new Image(SimpleITKJNI.maskNegated__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, outsideValue, maskingValue), true);
  }

  public static Image maskNegated(Image image, Image maskImage, double outsideValue) {
    return new Image(SimpleITKJNI.maskNegated__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, outsideValue), true);
  }

  public static Image maskNegated(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.maskNegated__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image maskedAssign(Image image, Image maskImage, Image assignImage, double assignConstant) {
    return new Image(SimpleITKJNI.maskedAssign__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, Image.getCPtr(assignImage), assignImage, assignConstant), true);
  }

  public static Image maskedAssign(Image image, Image maskImage, Image assignImage) {
    return new Image(SimpleITKJNI.maskedAssign__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, Image.getCPtr(assignImage), assignImage), true);
  }

  public static Image maskedAssign(Image image, Image maskImage, double assignConstant) {
    return new Image(SimpleITKJNI.maskedAssign__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, assignConstant), true);
  }

  public static Image maskedAssign(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.maskedAssign__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image maskedFFTNormalizedCorrelation(Image fixedImage, Image movingImage, Image fixedImageMask, Image movingImageMask, java.math.BigInteger requiredNumberOfOverlappingPixels, float requiredFractionOfOverlappingPixels) {
    return new Image(SimpleITKJNI.maskedFFTNormalizedCorrelation__SWIG_0(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(fixedImageMask), fixedImageMask, Image.getCPtr(movingImageMask), movingImageMask, requiredNumberOfOverlappingPixels, requiredFractionOfOverlappingPixels), true);
  }

  public static Image maskedFFTNormalizedCorrelation(Image fixedImage, Image movingImage, Image fixedImageMask, Image movingImageMask, java.math.BigInteger requiredNumberOfOverlappingPixels) {
    return new Image(SimpleITKJNI.maskedFFTNormalizedCorrelation__SWIG_1(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(fixedImageMask), fixedImageMask, Image.getCPtr(movingImageMask), movingImageMask, requiredNumberOfOverlappingPixels), true);
  }

  public static Image maskedFFTNormalizedCorrelation(Image fixedImage, Image movingImage, Image fixedImageMask, Image movingImageMask) {
    return new Image(SimpleITKJNI.maskedFFTNormalizedCorrelation__SWIG_2(Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(fixedImageMask), fixedImageMask, Image.getCPtr(movingImageMask), movingImageMask), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image maximumEntropyThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image maximumEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image maximumEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image maximumEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image maximumEntropyThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image maximumEntropyThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image maximumEntropyThreshold(Image image) {
    return new Image(SimpleITKJNI.maximumEntropyThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  /**
Image itk::simple::Maximum(Image &amp;&amp;image1, double constant)
*/
public  static Image maximum(Image image1, Image image2) {
    return new Image(SimpleITKJNI.maximum__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Maximum(Image &amp;&amp;image1, double constant)
*/
public  static Image maximum(Image image1, double constant) {
    return new Image(SimpleITKJNI.maximum__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Maximum(Image &amp;&amp;image1, double constant)
*/
public  static Image maximum(double constant, Image image2) {
    return new Image(SimpleITKJNI.maximum__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image maximumProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.maximumProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image maximumProjection(Image image1) {
    return new Image(SimpleITKJNI.maximumProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image mean(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.mean__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image mean(Image image1) {
    return new Image(SimpleITKJNI.mean__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image meanProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.meanProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image meanProjection(Image image1) {
    return new Image(SimpleITKJNI.meanProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image median(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.median__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image median(Image image1) {
    return new Image(SimpleITKJNI.median__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image medianProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.medianProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image medianProjection(Image image1) {
    return new Image(SimpleITKJNI.medianProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image mergeLabelMap(VectorOfImage images, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_0(VectorOfImage.getCPtr(images), images, method.swigValue()), true);
  }

  public static Image mergeLabelMap(VectorOfImage images) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_1(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image mergeLabelMap(Image image1, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_2(Image.getCPtr(image1), image1, method.swigValue()), true);
  }

  public static Image mergeLabelMap(Image image1) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, method.swigValue()), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_6(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, method.swigValue()), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_7(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3, Image image4, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, method.swigValue()), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3, Image image4, Image image5, MergeLabelMapFilter.MethodType method) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, method.swigValue()), true);
  }

  public static Image mergeLabelMap(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.mergeLabelMap__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image minMaxCurvatureFlow(Image image1, double timeStep, long numberOfIterations, int stencilRadius) {
    return new Image(SimpleITKJNI.minMaxCurvatureFlow__SWIG_0(Image.getCPtr(image1), image1, timeStep, numberOfIterations, stencilRadius), true);
  }

  public static Image minMaxCurvatureFlow(Image image1, double timeStep, long numberOfIterations) {
    return new Image(SimpleITKJNI.minMaxCurvatureFlow__SWIG_1(Image.getCPtr(image1), image1, timeStep, numberOfIterations), true);
  }

  public static Image minMaxCurvatureFlow(Image image1, double timeStep) {
    return new Image(SimpleITKJNI.minMaxCurvatureFlow__SWIG_2(Image.getCPtr(image1), image1, timeStep), true);
  }

  public static Image minMaxCurvatureFlow(Image image1) {
    return new Image(SimpleITKJNI.minMaxCurvatureFlow__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Minimum(Image &amp;&amp;image1, double constant)
*/
public  static Image minimum(Image image1, Image image2) {
    return new Image(SimpleITKJNI.minimum__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Minimum(Image &amp;&amp;image1, double constant)
*/
public  static Image minimum(Image image1, double constant) {
    return new Image(SimpleITKJNI.minimum__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Minimum(Image &amp;&amp;image1, double constant)
*/
public  static Image minimum(double constant, Image image2) {
    return new Image(SimpleITKJNI.minimum__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image minimumProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.minimumProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image minimumProjection(Image image1) {
    return new Image(SimpleITKJNI.minimumProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image mirrorPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound, double decayBase) {
    return new Image(SimpleITKJNI.mirrorPad__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound, decayBase), true);
  }

  public static Image mirrorPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound) {
    return new Image(SimpleITKJNI.mirrorPad__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound), true);
  }

  public static Image mirrorPad(Image image1, VectorUInt32 padLowerBound) {
    return new Image(SimpleITKJNI.mirrorPad__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound), true);
  }

  public static Image mirrorPad(Image image1) {
    return new Image(SimpleITKJNI.mirrorPad__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Modulus(uint32_t constant, const Image &amp;image2)
*/
public  static Image modulus(Image image1, Image image2) {
    return new Image(SimpleITKJNI.modulus__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Modulus(uint32_t constant, const Image &amp;image2)
*/
public  static Image modulus(Image image1, long constant) {
    return new Image(SimpleITKJNI.modulus__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Modulus(uint32_t constant, const Image &amp;image2)
*/
public  static Image modulus(long constant, Image image2) {
    return new Image(SimpleITKJNI.modulus__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image momentsThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image momentsThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image momentsThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image momentsThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image momentsThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image momentsThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image momentsThreshold(Image image) {
    return new Image(SimpleITKJNI.momentsThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image morphologicalGradient(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.morphologicalGradient__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image morphologicalGradient(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.morphologicalGradient__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image morphologicalGradient(Image image1) {
    return new Image(SimpleITKJNI.morphologicalGradient__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image morphologicalWatershedFromMarkers(Image image, Image markerImage, boolean markWatershedLine, boolean fullyConnected) {
    return new Image(SimpleITKJNI.morphologicalWatershedFromMarkers__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(markerImage), markerImage, markWatershedLine, fullyConnected), true);
  }

  public static Image morphologicalWatershedFromMarkers(Image image, Image markerImage, boolean markWatershedLine) {
    return new Image(SimpleITKJNI.morphologicalWatershedFromMarkers__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(markerImage), markerImage, markWatershedLine), true);
  }

  public static Image morphologicalWatershedFromMarkers(Image image, Image markerImage) {
    return new Image(SimpleITKJNI.morphologicalWatershedFromMarkers__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(markerImage), markerImage), true);
  }

  public static Image morphologicalWatershed(Image image1, double level, boolean markWatershedLine, boolean fullyConnected) {
    return new Image(SimpleITKJNI.morphologicalWatershed__SWIG_0(Image.getCPtr(image1), image1, level, markWatershedLine, fullyConnected), true);
  }

  public static Image morphologicalWatershed(Image image1, double level, boolean markWatershedLine) {
    return new Image(SimpleITKJNI.morphologicalWatershed__SWIG_1(Image.getCPtr(image1), image1, level, markWatershedLine), true);
  }

  public static Image morphologicalWatershed(Image image1, double level) {
    return new Image(SimpleITKJNI.morphologicalWatershed__SWIG_2(Image.getCPtr(image1), image1, level), true);
  }

  public static Image morphologicalWatershed(Image image1) {
    return new Image(SimpleITKJNI.morphologicalWatershed__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image multiLabelSTAPLE(VectorOfImage images, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_0(VectorOfImage.getCPtr(images), images, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(VectorOfImage images, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_1(VectorOfImage.getCPtr(images), images, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(VectorOfImage images, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_2(VectorOfImage.getCPtr(images), images, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(VectorOfImage images, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_3(VectorOfImage.getCPtr(images), images, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(VectorOfImage images) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_4(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image multiLabelSTAPLE(Image image1, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_5(Image.getCPtr(image1), image1, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(Image image1, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_6(Image.getCPtr(image1), image1, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(Image image1, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_7(Image.getCPtr(image1), image1, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(Image image1, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_8(Image.getCPtr(image1), image1, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(Image image1) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_9(Image.getCPtr(image1), image1), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_12(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_13(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_14(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_15(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_16(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_17(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_18(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_19(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_20(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_21(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_22(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_23(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_24(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations, VectorFloat priorProbabilities) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_25(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations, VectorFloat.getCPtr(priorProbabilities), priorProbabilities), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_26(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, labelForUndecidedPixels, terminationUpdateThreshold, maximumNumberOfIterations), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, java.math.BigInteger labelForUndecidedPixels, float terminationUpdateThreshold) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_27(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, labelForUndecidedPixels, terminationUpdateThreshold), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, java.math.BigInteger labelForUndecidedPixels) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_28(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, labelForUndecidedPixels), true);
  }

  public static Image multiLabelSTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.multiLabelSTAPLE__SWIG_29(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  /**
Image itk::simple::Multiply(Image &amp;&amp;image1, double constant)
*/
public  static Image multiply(Image image1, Image image2) {
    return new Image(SimpleITKJNI.multiply__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Multiply(Image &amp;&amp;image1, double constant)
*/
public  static Image multiply(Image image1, double constant) {
    return new Image(SimpleITKJNI.multiply__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Multiply(Image &amp;&amp;image1, double constant)
*/
public  static Image multiply(double constant, Image image2) {
    return new Image(SimpleITKJNI.multiply__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder, boolean useMaskLabel, short maskLabel) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder, useMaskLabel, maskLabel), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder, boolean useMaskLabel) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder, useMaskLabel), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_6(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_7(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage, double convergenceThreshold) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_8(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, convergenceThreshold), true);
  }

  public static Image n4BiasFieldCorrection(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_9(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder, boolean useMaskLabel, short maskLabel) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_10(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder, useMaskLabel, maskLabel), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder, boolean useMaskLabel) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_11(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder, useMaskLabel), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints, long splineOrder) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_12(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints, splineOrder), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins, VectorUInt32 numberOfControlPoints) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_13(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins, VectorUInt32.getCPtr(numberOfControlPoints), numberOfControlPoints), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_14(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise, numberOfHistogramBins), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum, double wienerFilterNoise) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_15(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum, wienerFilterNoise), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations, double biasFieldFullWidthAtHalfMaximum) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_16(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations, biasFieldFullWidthAtHalfMaximum), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold, VectorUInt32 maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_17(Image.getCPtr(image), image, convergenceThreshold, VectorUInt32.getCPtr(maximumNumberOfIterations), maximumNumberOfIterations), true);
  }

  public static Image n4BiasFieldCorrection(Image image, double convergenceThreshold) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_18(Image.getCPtr(image), image, convergenceThreshold), true);
  }

  public static Image n4BiasFieldCorrection(Image image) {
    return new Image(SimpleITKJNI.n4BiasFieldCorrection__SWIG_19(Image.getCPtr(image), image), true);
  }

  public static Image naryAdd(VectorOfImage images) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_0(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image naryAdd(Image image1) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image naryAdd(Image image1, Image image2) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image naryAdd(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image naryAdd(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image naryAdd(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.naryAdd__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image naryMaximum(VectorOfImage images) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_0(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image naryMaximum(Image image1) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image naryMaximum(Image image1, Image image2) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image naryMaximum(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image naryMaximum(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image naryMaximum(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.naryMaximum__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image neighborhoodConnected(Image image1, VectorUIntList seedList, double lower, double upper, VectorUInt32 radius, double replaceValue) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper, VectorUInt32.getCPtr(radius), radius, replaceValue), true);
  }

  public static Image neighborhoodConnected(Image image1, VectorUIntList seedList, double lower, double upper, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image neighborhoodConnected(Image image1, VectorUIntList seedList, double lower, double upper) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower, upper), true);
  }

  public static Image neighborhoodConnected(Image image1, VectorUIntList seedList, double lower) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, lower), true);
  }

  public static Image neighborhoodConnected(Image image1, VectorUIntList seedList) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList), true);
  }

  public static Image neighborhoodConnected(Image image1) {
    return new Image(SimpleITKJNI.neighborhoodConnected__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image noise(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.noise__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image noise(Image image1) {
    return new Image(SimpleITKJNI.noise__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image normalize(Image image1) {
    return new Image(SimpleITKJNI.normalize(Image.getCPtr(image1), image1), true);
  }

  public static Image normalizeToConstant(Image image1, double constant) {
    return new Image(SimpleITKJNI.normalizeToConstant__SWIG_0(Image.getCPtr(image1), image1, constant), true);
  }

  public static Image normalizeToConstant(Image image1) {
    return new Image(SimpleITKJNI.normalizeToConstant__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image normalizedCorrelation(Image image, Image maskImage, Image templateImage) {
    return new Image(SimpleITKJNI.normalizedCorrelation(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, Image.getCPtr(templateImage), templateImage), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, Image image2) {
    return new Image(SimpleITKJNI.notEqual__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, double constant, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_3(Image.getCPtr(image1), image1, constant, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, double constant, short backgroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_4(Image.getCPtr(image1), image1, constant, backgroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(Image image1, double constant) {
    return new Image(SimpleITKJNI.notEqual__SWIG_5(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(double constant, Image image2, short backgroundValue, short foregroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_6(constant, Image.getCPtr(image2), image2, backgroundValue, foregroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(double constant, Image image2, short backgroundValue) {
    return new Image(SimpleITKJNI.notEqual__SWIG_7(constant, Image.getCPtr(image2), image2, backgroundValue), true);
  }

  /**
Image itk::simple::NotEqual(Image &amp;&amp;image1, double constant, uint8_t backgroundValue=0u,
uint8_t foregroundValue=1u)
*/
public  static Image notEqual(double constant, Image image2) {
    return new Image(SimpleITKJNI.notEqual__SWIG_8(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image not(Image image1) {
    return new Image(SimpleITKJNI.not(Image.getCPtr(image1), image1), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha, double beta, double gamma, boolean scaleObjectnessMeasure, long objectDimension, boolean brightObject) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_0(Image.getCPtr(image1), image1, alpha, beta, gamma, scaleObjectnessMeasure, objectDimension, brightObject), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha, double beta, double gamma, boolean scaleObjectnessMeasure, long objectDimension) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_1(Image.getCPtr(image1), image1, alpha, beta, gamma, scaleObjectnessMeasure, objectDimension), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha, double beta, double gamma, boolean scaleObjectnessMeasure) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_2(Image.getCPtr(image1), image1, alpha, beta, gamma, scaleObjectnessMeasure), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha, double beta, double gamma) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_3(Image.getCPtr(image1), image1, alpha, beta, gamma), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha, double beta) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_4(Image.getCPtr(image1), image1, alpha, beta), true);
  }

  public static Image objectnessMeasure(Image image1, double alpha) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_5(Image.getCPtr(image1), image1, alpha), true);
  }

  public static Image objectnessMeasure(Image image1) {
    return new Image(SimpleITKJNI.objectnessMeasure__SWIG_6(Image.getCPtr(image1), image1), true);
  }

  public static Image openingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean fullyConnected, boolean preserveIntensities) {
    return new Image(SimpleITKJNI.openingByReconstruction__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), fullyConnected, preserveIntensities), true);
  }

  public static Image openingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean fullyConnected) {
    return new Image(SimpleITKJNI.openingByReconstruction__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), fullyConnected), true);
  }

  public static Image openingByReconstruction(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.openingByReconstruction__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image openingByReconstruction(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.openingByReconstruction__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image openingByReconstruction(Image image1) {
    return new Image(SimpleITKJNI.openingByReconstruction__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Or(int constant, const Image &amp;image2)
*/
public  static Image or(Image image1, Image image2) {
    return new Image(SimpleITKJNI.or__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Or(int constant, const Image &amp;image2)
*/
public  static Image or(Image image1, int constant) {
    return new Image(SimpleITKJNI.or__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Or(int constant, const Image &amp;image2)
*/
public  static Image or(int constant, Image image2) {
    return new Image(SimpleITKJNI.or__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image otsuMultipleThresholds(Image image1, short numberOfThresholds, short labelOffset, long numberOfHistogramBins, boolean valleyEmphasis, boolean returnBinMidpoint) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_0(Image.getCPtr(image1), image1, numberOfThresholds, labelOffset, numberOfHistogramBins, valleyEmphasis, returnBinMidpoint), true);
  }

  public static Image otsuMultipleThresholds(Image image1, short numberOfThresholds, short labelOffset, long numberOfHistogramBins, boolean valleyEmphasis) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_1(Image.getCPtr(image1), image1, numberOfThresholds, labelOffset, numberOfHistogramBins, valleyEmphasis), true);
  }

  public static Image otsuMultipleThresholds(Image image1, short numberOfThresholds, short labelOffset, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_2(Image.getCPtr(image1), image1, numberOfThresholds, labelOffset, numberOfHistogramBins), true);
  }

  public static Image otsuMultipleThresholds(Image image1, short numberOfThresholds, short labelOffset) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_3(Image.getCPtr(image1), image1, numberOfThresholds, labelOffset), true);
  }

  public static Image otsuMultipleThresholds(Image image1, short numberOfThresholds) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_4(Image.getCPtr(image1), image1, numberOfThresholds), true);
  }

  public static Image otsuMultipleThresholds(Image image1) {
    return new Image(SimpleITKJNI.otsuMultipleThresholds__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue, boolean returnBinMidpoint) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue, returnBinMidpoint), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image otsuThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_6(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image otsuThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue, boolean returnBinMidpoint) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue, returnBinMidpoint), true);
  }

  public static Image otsuThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image otsuThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image otsuThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_10(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image otsuThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_11(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image otsuThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_12(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image otsuThreshold(Image image) {
    return new Image(SimpleITKJNI.otsuThreshold__SWIG_13(Image.getCPtr(image), image), true);
  }

  public static Image permuteAxes(Image image1, VectorUInt32 order) {
    return new Image(SimpleITKJNI.permuteAxes__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(order), order), true);
  }

  public static Image permuteAxes(Image image1) {
    return new Image(SimpleITKJNI.permuteAxes__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble origin, VectorDouble spacing, VectorDouble direction) {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_0(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing, VectorDouble.getCPtr(direction), direction), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble origin, VectorDouble spacing) {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_1(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(origin), origin, VectorDouble.getCPtr(spacing), spacing), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource(PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble origin) {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_2(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(origin), origin), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource(PixelIDValueEnum outputPixelType, VectorUInt32 size) {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_3(outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource(PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_4(outputPixelType.swigValue()), true);
  }

  /**
Image itk::simple::PhysicalPointSource(PixelIDValueEnum outputPixelType=itk::simple::sitkVectorFloat32,
std::vector&lt; unsigned int &gt; size=std::vector&lt; unsigned int
&gt;(3, 64), std::vector&lt; double &gt; origin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt; spacing=std::vector&lt;
double &gt;(3, 1.0), std::vector&lt; double &gt;
direction=std::vector&lt; double &gt;())

Generate an image of the physical locations of each pixel.


This function directly calls the execute method of PhysicalPointImageSource in order to support a procedural API


See:
 itk::simple::PhysicalPointImageSource for the object oriented interface


*/
public  static Image physicalPointSource() {
    return new Image(SimpleITKJNI.physicalPointSource__SWIG_5(), true);
  }

  /**
Image itk::simple::Pow(Image &amp;&amp;image1, double constant)
*/
public  static Image pow(Image image1, Image image2) {
    return new Image(SimpleITKJNI.pow__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Pow(Image &amp;&amp;image1, double constant)
*/
public  static Image pow(Image image1, double constant) {
    return new Image(SimpleITKJNI.pow__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Pow(Image &amp;&amp;image1, double constant)
*/
public  static Image pow(double constant, Image image2) {
    return new Image(SimpleITKJNI.pow__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize, ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, ProjectedLandweberDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize, ProjectedLandweberDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations, boolean normalize) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations, normalize), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2, double alpha, int numberOfIterations) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha, numberOfIterations), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2, double alpha) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, alpha), true);
  }

  public static Image projectedLandweberDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.projectedLandweberDeconvolution__SWIG_5(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image rank(Image image1, double rank, VectorUInt32 radius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.rank__SWIG_0(Image.getCPtr(image1), image1, rank, VectorUInt32.getCPtr(radius), radius, kernelType.swigValue()), true);
  }

  public static Image rank(Image image1, double rank, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.rank__SWIG_1(Image.getCPtr(image1), image1, rank, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image rank(Image image1, double rank) {
    return new Image(SimpleITKJNI.rank__SWIG_2(Image.getCPtr(image1), image1, rank), true);
  }

  public static Image rank(Image image1) {
    return new Image(SimpleITKJNI.rank__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image realAndImaginaryToComplex(Image image1, Image image2) {
    return new Image(SimpleITKJNI.realAndImaginaryToComplex(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image realToHalfHermitianForwardFFT(Image image1) {
    return new Image(SimpleITKJNI.realToHalfHermitianForwardFFT(Image.getCPtr(image1), image1), true);
  }

  public static Image reconstructionByDilation(Image markerImage, Image maskImage, boolean fullyConnected, boolean useInternalCopy) {
    return new Image(SimpleITKJNI.reconstructionByDilation__SWIG_0(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, fullyConnected, useInternalCopy), true);
  }

  public static Image reconstructionByDilation(Image markerImage, Image maskImage, boolean fullyConnected) {
    return new Image(SimpleITKJNI.reconstructionByDilation__SWIG_1(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, fullyConnected), true);
  }

  public static Image reconstructionByDilation(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.reconstructionByDilation__SWIG_2(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image reconstructionByErosion(Image markerImage, Image maskImage, boolean fullyConnected, boolean useInternalCopy) {
    return new Image(SimpleITKJNI.reconstructionByErosion__SWIG_0(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, fullyConnected, useInternalCopy), true);
  }

  public static Image reconstructionByErosion(Image markerImage, Image maskImage, boolean fullyConnected) {
    return new Image(SimpleITKJNI.reconstructionByErosion__SWIG_1(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage, fullyConnected), true);
  }

  public static Image reconstructionByErosion(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.reconstructionByErosion__SWIG_2(Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image recursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale, RecursiveGaussianImageFilter.OrderType order, long direction) {
    return new Image(SimpleITKJNI.recursiveGaussian__SWIG_0(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale, order.swigValue(), direction), true);
  }

  public static Image recursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale, RecursiveGaussianImageFilter.OrderType order) {
    return new Image(SimpleITKJNI.recursiveGaussian__SWIG_1(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale, order.swigValue()), true);
  }

  public static Image recursiveGaussian(Image image1, double sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.recursiveGaussian__SWIG_2(Image.getCPtr(image1), image1, sigma, normalizeAcrossScale), true);
  }

  public static Image recursiveGaussian(Image image1, double sigma) {
    return new Image(SimpleITKJNI.recursiveGaussian__SWIG_3(Image.getCPtr(image1), image1, sigma), true);
  }

  public static Image recursiveGaussian(Image image1) {
    return new Image(SimpleITKJNI.recursiveGaussian__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image regionOfInterest(Image image1, VectorUInt32 size, VectorInt32 index) {
    return new Image(SimpleITKJNI.regionOfInterest__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size, VectorInt32.getCPtr(index), index), true);
  }

  public static Image regionOfInterest(Image image1, VectorUInt32 size) {
    return new Image(SimpleITKJNI.regionOfInterest__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(size), size), true);
  }

  public static Image regionOfInterest(Image image1) {
    return new Image(SimpleITKJNI.regionOfInterest__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image regionalMaxima(Image image1, double backgroundValue, double foregroundValue, boolean fullyConnected, boolean flatIsMaxima) {
    return new Image(SimpleITKJNI.regionalMaxima__SWIG_0(Image.getCPtr(image1), image1, backgroundValue, foregroundValue, fullyConnected, flatIsMaxima), true);
  }

  public static Image regionalMaxima(Image image1, double backgroundValue, double foregroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.regionalMaxima__SWIG_1(Image.getCPtr(image1), image1, backgroundValue, foregroundValue, fullyConnected), true);
  }

  public static Image regionalMaxima(Image image1, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.regionalMaxima__SWIG_2(Image.getCPtr(image1), image1, backgroundValue, foregroundValue), true);
  }

  public static Image regionalMaxima(Image image1, double backgroundValue) {
    return new Image(SimpleITKJNI.regionalMaxima__SWIG_3(Image.getCPtr(image1), image1, backgroundValue), true);
  }

  public static Image regionalMaxima(Image image1) {
    return new Image(SimpleITKJNI.regionalMaxima__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image regionalMinima(Image image1, double backgroundValue, double foregroundValue, boolean fullyConnected, boolean flatIsMinima) {
    return new Image(SimpleITKJNI.regionalMinima__SWIG_0(Image.getCPtr(image1), image1, backgroundValue, foregroundValue, fullyConnected, flatIsMinima), true);
  }

  public static Image regionalMinima(Image image1, double backgroundValue, double foregroundValue, boolean fullyConnected) {
    return new Image(SimpleITKJNI.regionalMinima__SWIG_1(Image.getCPtr(image1), image1, backgroundValue, foregroundValue, fullyConnected), true);
  }

  public static Image regionalMinima(Image image1, double backgroundValue, double foregroundValue) {
    return new Image(SimpleITKJNI.regionalMinima__SWIG_2(Image.getCPtr(image1), image1, backgroundValue, foregroundValue), true);
  }

  public static Image regionalMinima(Image image1, double backgroundValue) {
    return new Image(SimpleITKJNI.regionalMinima__SWIG_3(Image.getCPtr(image1), image1, backgroundValue), true);
  }

  public static Image regionalMinima(Image image1) {
    return new Image(SimpleITKJNI.regionalMinima__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image reinitializeLevelSet(Image image1, double levelSetValue, boolean narrowBanding, double inputNarrowBandwidth, double outputNarrowBandwidth) {
    return new Image(SimpleITKJNI.reinitializeLevelSet__SWIG_0(Image.getCPtr(image1), image1, levelSetValue, narrowBanding, inputNarrowBandwidth, outputNarrowBandwidth), true);
  }

  public static Image reinitializeLevelSet(Image image1, double levelSetValue, boolean narrowBanding, double inputNarrowBandwidth) {
    return new Image(SimpleITKJNI.reinitializeLevelSet__SWIG_1(Image.getCPtr(image1), image1, levelSetValue, narrowBanding, inputNarrowBandwidth), true);
  }

  public static Image reinitializeLevelSet(Image image1, double levelSetValue, boolean narrowBanding) {
    return new Image(SimpleITKJNI.reinitializeLevelSet__SWIG_2(Image.getCPtr(image1), image1, levelSetValue, narrowBanding), true);
  }

  public static Image reinitializeLevelSet(Image image1, double levelSetValue) {
    return new Image(SimpleITKJNI.reinitializeLevelSet__SWIG_3(Image.getCPtr(image1), image1, levelSetValue), true);
  }

  public static Image reinitializeLevelSet(Image image1) {
    return new Image(SimpleITKJNI.reinitializeLevelSet__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image relabelComponent(Image image1, java.math.BigInteger minimumObjectSize, boolean sortByObjectSize) {
    return new Image(SimpleITKJNI.relabelComponent__SWIG_0(Image.getCPtr(image1), image1, minimumObjectSize, sortByObjectSize), true);
  }

  public static Image relabelComponent(Image image1, java.math.BigInteger minimumObjectSize) {
    return new Image(SimpleITKJNI.relabelComponent__SWIG_1(Image.getCPtr(image1), image1, minimumObjectSize), true);
  }

  public static Image relabelComponent(Image image1) {
    return new Image(SimpleITKJNI.relabelComponent__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image relabelLabelMap(Image image1, boolean reverseOrdering) {
    return new Image(SimpleITKJNI.relabelLabelMap__SWIG_0(Image.getCPtr(image1), image1, reverseOrdering), true);
  }

  public static Image relabelLabelMap(Image image1) {
    return new Image(SimpleITKJNI.relabelLabelMap__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image renyiEntropyThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image renyiEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image renyiEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image renyiEntropyThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image renyiEntropyThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image renyiEntropyThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image renyiEntropyThreshold(Image image) {
    return new Image(SimpleITKJNI.renyiEntropyThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image rescaleIntensity(Image image1, double outputMinimum, double outputMaximum) {
    return new Image(SimpleITKJNI.rescaleIntensity__SWIG_0(Image.getCPtr(image1), image1, outputMinimum, outputMaximum), true);
  }

  public static Image rescaleIntensity(Image image1, double outputMinimum) {
    return new Image(SimpleITKJNI.rescaleIntensity__SWIG_1(Image.getCPtr(image1), image1, outputMinimum), true);
  }

  public static Image rescaleIntensity(Image image1) {
    return new Image(SimpleITKJNI.rescaleIntensity__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image richardsonLucyDeconvolution(Image image1, Image image2, int numberOfIterations, boolean normalize, RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.richardsonLucyDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, numberOfIterations, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image richardsonLucyDeconvolution(Image image1, Image image2, int numberOfIterations, boolean normalize, RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.richardsonLucyDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, numberOfIterations, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image richardsonLucyDeconvolution(Image image1, Image image2, int numberOfIterations, boolean normalize) {
    return new Image(SimpleITKJNI.richardsonLucyDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, numberOfIterations, normalize), true);
  }

  public static Image richardsonLucyDeconvolution(Image image1, Image image2, int numberOfIterations) {
    return new Image(SimpleITKJNI.richardsonLucyDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, numberOfIterations), true);
  }

  public static Image richardsonLucyDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.richardsonLucyDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image round(Image image1) {
    return new Image(SimpleITKJNI.round(Image.getCPtr(image1), image1), true);
  }

  public static Image sLIC(Image image1, VectorUInt32 superGridSize, double spatialProximityWeight, long maximumNumberOfIterations, boolean enforceConnectivity, boolean initializationPerturbation) {
    return new Image(SimpleITKJNI.sLIC__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(superGridSize), superGridSize, spatialProximityWeight, maximumNumberOfIterations, enforceConnectivity, initializationPerturbation), true);
  }

  public static Image sLIC(Image image1, VectorUInt32 superGridSize, double spatialProximityWeight, long maximumNumberOfIterations, boolean enforceConnectivity) {
    return new Image(SimpleITKJNI.sLIC__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(superGridSize), superGridSize, spatialProximityWeight, maximumNumberOfIterations, enforceConnectivity), true);
  }

  public static Image sLIC(Image image1, VectorUInt32 superGridSize, double spatialProximityWeight, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.sLIC__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(superGridSize), superGridSize, spatialProximityWeight, maximumNumberOfIterations), true);
  }

  public static Image sLIC(Image image1, VectorUInt32 superGridSize, double spatialProximityWeight) {
    return new Image(SimpleITKJNI.sLIC__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(superGridSize), superGridSize, spatialProximityWeight), true);
  }

  public static Image sLIC(Image image1, VectorUInt32 superGridSize) {
    return new Image(SimpleITKJNI.sLIC__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(superGridSize), superGridSize), true);
  }

  public static Image sLIC(Image image1) {
    return new Image(SimpleITKJNI.sLIC__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image sTAPLE(VectorOfImage images, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_0(VectorOfImage.getCPtr(images), images, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(VectorOfImage images, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_1(VectorOfImage.getCPtr(images), images, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(VectorOfImage images, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_2(VectorOfImage.getCPtr(images), images, confidenceWeight), true);
  }

  public static Image sTAPLE(VectorOfImage images) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_3(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image sTAPLE(Image image1, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_4(Image.getCPtr(image1), image1, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(Image image1, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_5(Image.getCPtr(image1), image1, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(Image image1, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_6(Image.getCPtr(image1), image1, confidenceWeight), true);
  }

  public static Image sTAPLE(Image image1) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_7(Image.getCPtr(image1), image1), true);
  }

  public static Image sTAPLE(Image image1, Image image2, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(Image image1, Image image2, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(Image image1, Image image2, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, confidenceWeight), true);
  }

  public static Image sTAPLE(Image image1, Image image2) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_12(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_13(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_14(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, confidenceWeight), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_15(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_16(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_17(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_18(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, confidenceWeight), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_19(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, double confidenceWeight, double foregroundValue, long maximumIterations) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_20(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, confidenceWeight, foregroundValue, maximumIterations), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, double confidenceWeight, double foregroundValue) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_21(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, confidenceWeight, foregroundValue), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5, double confidenceWeight) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_22(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, confidenceWeight), true);
  }

  public static Image sTAPLE(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.sTAPLE__SWIG_23(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image saltAndPepperNoise(Image image1, double probability, long seed) {
    return new Image(SimpleITKJNI.saltAndPepperNoise__SWIG_0(Image.getCPtr(image1), image1, probability, seed), true);
  }

  public static Image saltAndPepperNoise(Image image1, double probability) {
    return new Image(SimpleITKJNI.saltAndPepperNoise__SWIG_1(Image.getCPtr(image1), image1, probability), true);
  }

  public static Image saltAndPepperNoise(Image image1) {
    return new Image(SimpleITKJNI.saltAndPepperNoise__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight, double volume, double volumeMatchingWeight, ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType heavisideStepFunction, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight, reinitializationSmoothingWeight, volume, volumeMatchingWeight, heavisideStepFunction.swigValue(), useImageSpacing), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight, double volume, double volumeMatchingWeight, ScalarChanAndVeseDenseLevelSetImageFilter.HeavisideStepFunctionType heavisideStepFunction) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight, reinitializationSmoothingWeight, volume, volumeMatchingWeight, heavisideStepFunction.swigValue()), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight, double volume, double volumeMatchingWeight) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight, reinitializationSmoothingWeight, volume, volumeMatchingWeight), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight, double volume) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight, reinitializationSmoothingWeight, volume), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight, double reinitializationSmoothingWeight) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight, reinitializationSmoothingWeight), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight, double areaWeight) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight, areaWeight), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon, double curvatureWeight) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_6(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon, curvatureWeight), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2, double epsilon) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_7(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2, epsilon), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1, double lambda2) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_8(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1, lambda2), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations, double lambda1) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_9(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations, lambda1), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError, long numberOfIterations) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_10(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, numberOfIterations), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage, double maximumRMSError) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_11(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError), true);
  }

  public static Image scalarChanAndVeseDenseLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.scalarChanAndVeseDenseLevelSet__SWIG_12(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image scalarConnectedComponent(Image image, Image maskImage, double distanceThreshold, boolean fullyConnected) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, distanceThreshold, fullyConnected), true);
  }

  public static Image scalarConnectedComponent(Image image, Image maskImage, double distanceThreshold) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, distanceThreshold), true);
  }

  public static Image scalarConnectedComponent(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image scalarConnectedComponent(Image image, double distanceThreshold, boolean fullyConnected) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_3(Image.getCPtr(image), image, distanceThreshold, fullyConnected), true);
  }

  public static Image scalarConnectedComponent(Image image, double distanceThreshold) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_4(Image.getCPtr(image), image, distanceThreshold), true);
  }

  public static Image scalarConnectedComponent(Image image) {
    return new Image(SimpleITKJNI.scalarConnectedComponent__SWIG_5(Image.getCPtr(image), image), true);
  }

  public static Image scalarImageKmeans(Image image1, VectorDouble classWithInitialMean, boolean useNonContiguousLabels) {
    return new Image(SimpleITKJNI.scalarImageKmeans__SWIG_0(Image.getCPtr(image1), image1, VectorDouble.getCPtr(classWithInitialMean), classWithInitialMean, useNonContiguousLabels), true);
  }

  public static Image scalarImageKmeans(Image image1, VectorDouble classWithInitialMean) {
    return new Image(SimpleITKJNI.scalarImageKmeans__SWIG_1(Image.getCPtr(image1), image1, VectorDouble.getCPtr(classWithInitialMean), classWithInitialMean), true);
  }

  public static Image scalarImageKmeans(Image image1) {
    return new Image(SimpleITKJNI.scalarImageKmeans__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image scalarToRGBColormap(Image image1, ScalarToRGBColormapImageFilter.ColormapType colormap, boolean useInputImageExtremaForScaling) {
    return new Image(SimpleITKJNI.scalarToRGBColormap__SWIG_0(Image.getCPtr(image1), image1, colormap.swigValue(), useInputImageExtremaForScaling), true);
  }

  public static Image scalarToRGBColormap(Image image1, ScalarToRGBColormapImageFilter.ColormapType colormap) {
    return new Image(SimpleITKJNI.scalarToRGBColormap__SWIG_1(Image.getCPtr(image1), image1, colormap.swigValue()), true);
  }

  public static Image scalarToRGBColormap(Image image1) {
    return new Image(SimpleITKJNI.scalarToRGBColormap__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image shanbhagThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image shanbhagThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image shanbhagThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image shanbhagThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image shanbhagThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image shanbhagThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image shanbhagThreshold(Image image) {
    return new Image(SimpleITKJNI.shanbhagThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations, boolean reverseExpansionDirection) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations, reverseExpansionDirection), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling, double curvatureScaling) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling, curvatureScaling), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage, double maximumRMSError, double propagationScaling) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError, propagationScaling), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage, double maximumRMSError) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, maximumRMSError), true);
  }

  public static Image shapeDetectionLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.shapeDetectionLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image shiftScale(Image image1, double shift, double scale, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.shiftScale__SWIG_0(Image.getCPtr(image1), image1, shift, scale, outputPixelType.swigValue()), true);
  }

  public static Image shiftScale(Image image1, double shift, double scale) {
    return new Image(SimpleITKJNI.shiftScale__SWIG_1(Image.getCPtr(image1), image1, shift, scale), true);
  }

  public static Image shiftScale(Image image1, double shift) {
    return new Image(SimpleITKJNI.shiftScale__SWIG_2(Image.getCPtr(image1), image1, shift), true);
  }

  public static Image shiftScale(Image image1) {
    return new Image(SimpleITKJNI.shiftScale__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image shotNoise(Image image1, double scale, long seed) {
    return new Image(SimpleITKJNI.shotNoise__SWIG_0(Image.getCPtr(image1), image1, scale, seed), true);
  }

  public static Image shotNoise(Image image1, double scale) {
    return new Image(SimpleITKJNI.shotNoise__SWIG_1(Image.getCPtr(image1), image1, scale), true);
  }

  public static Image shotNoise(Image image1) {
    return new Image(SimpleITKJNI.shotNoise__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image shrink(Image image1, VectorUInt32 shrinkFactors) {
    return new Image(SimpleITKJNI.shrink__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(shrinkFactors), shrinkFactors), true);
  }

  public static Image shrink(Image image1) {
    return new Image(SimpleITKJNI.shrink__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image sigmoid(Image image1, double alpha, double beta, double outputMaximum, double outputMinimum) {
    return new Image(SimpleITKJNI.sigmoid__SWIG_0(Image.getCPtr(image1), image1, alpha, beta, outputMaximum, outputMinimum), true);
  }

  public static Image sigmoid(Image image1, double alpha, double beta, double outputMaximum) {
    return new Image(SimpleITKJNI.sigmoid__SWIG_1(Image.getCPtr(image1), image1, alpha, beta, outputMaximum), true);
  }

  public static Image sigmoid(Image image1, double alpha, double beta) {
    return new Image(SimpleITKJNI.sigmoid__SWIG_2(Image.getCPtr(image1), image1, alpha, beta), true);
  }

  public static Image sigmoid(Image image1, double alpha) {
    return new Image(SimpleITKJNI.sigmoid__SWIG_3(Image.getCPtr(image1), image1, alpha), true);
  }

  public static Image sigmoid(Image image1) {
    return new Image(SimpleITKJNI.sigmoid__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image signedDanielssonDistanceMap(Image image1, boolean insideIsPositive, boolean squaredDistance, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.signedDanielssonDistanceMap__SWIG_0(Image.getCPtr(image1), image1, insideIsPositive, squaredDistance, useImageSpacing), true);
  }

  public static Image signedDanielssonDistanceMap(Image image1, boolean insideIsPositive, boolean squaredDistance) {
    return new Image(SimpleITKJNI.signedDanielssonDistanceMap__SWIG_1(Image.getCPtr(image1), image1, insideIsPositive, squaredDistance), true);
  }

  public static Image signedDanielssonDistanceMap(Image image1, boolean insideIsPositive) {
    return new Image(SimpleITKJNI.signedDanielssonDistanceMap__SWIG_2(Image.getCPtr(image1), image1, insideIsPositive), true);
  }

  public static Image signedDanielssonDistanceMap(Image image1) {
    return new Image(SimpleITKJNI.signedDanielssonDistanceMap__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image signedMaurerDistanceMap(Image image1, boolean insideIsPositive, boolean squaredDistance, boolean useImageSpacing, double backgroundValue) {
    return new Image(SimpleITKJNI.signedMaurerDistanceMap__SWIG_0(Image.getCPtr(image1), image1, insideIsPositive, squaredDistance, useImageSpacing, backgroundValue), true);
  }

  public static Image signedMaurerDistanceMap(Image image1, boolean insideIsPositive, boolean squaredDistance, boolean useImageSpacing) {
    return new Image(SimpleITKJNI.signedMaurerDistanceMap__SWIG_1(Image.getCPtr(image1), image1, insideIsPositive, squaredDistance, useImageSpacing), true);
  }

  public static Image signedMaurerDistanceMap(Image image1, boolean insideIsPositive, boolean squaredDistance) {
    return new Image(SimpleITKJNI.signedMaurerDistanceMap__SWIG_2(Image.getCPtr(image1), image1, insideIsPositive, squaredDistance), true);
  }

  public static Image signedMaurerDistanceMap(Image image1, boolean insideIsPositive) {
    return new Image(SimpleITKJNI.signedMaurerDistanceMap__SWIG_3(Image.getCPtr(image1), image1, insideIsPositive), true);
  }

  public static Image signedMaurerDistanceMap(Image image1) {
    return new Image(SimpleITKJNI.signedMaurerDistanceMap__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image simpleContourExtractor(Image image1, double inputForegroundValue, double inputBackgroundValue, VectorUInt32 radius, double outputForegroundValue, double outputBackgroundValue) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_0(Image.getCPtr(image1), image1, inputForegroundValue, inputBackgroundValue, VectorUInt32.getCPtr(radius), radius, outputForegroundValue, outputBackgroundValue), true);
  }

  public static Image simpleContourExtractor(Image image1, double inputForegroundValue, double inputBackgroundValue, VectorUInt32 radius, double outputForegroundValue) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_1(Image.getCPtr(image1), image1, inputForegroundValue, inputBackgroundValue, VectorUInt32.getCPtr(radius), radius, outputForegroundValue), true);
  }

  public static Image simpleContourExtractor(Image image1, double inputForegroundValue, double inputBackgroundValue, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_2(Image.getCPtr(image1), image1, inputForegroundValue, inputBackgroundValue, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image simpleContourExtractor(Image image1, double inputForegroundValue, double inputBackgroundValue) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_3(Image.getCPtr(image1), image1, inputForegroundValue, inputBackgroundValue), true);
  }

  public static Image simpleContourExtractor(Image image1, double inputForegroundValue) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_4(Image.getCPtr(image1), image1, inputForegroundValue), true);
  }

  public static Image simpleContourExtractor(Image image1) {
    return new Image(SimpleITKJNI.simpleContourExtractor__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image sin(Image image1) {
    return new Image(SimpleITKJNI.sin(Image.getCPtr(image1), image1), true);
  }

  public static Image slice(Image image1, VectorInt32 start, VectorInt32 stop, VectorInt32 step) {
    return new Image(SimpleITKJNI.slice__SWIG_0(Image.getCPtr(image1), image1, VectorInt32.getCPtr(start), start, VectorInt32.getCPtr(stop), stop, VectorInt32.getCPtr(step), step), true);
  }

  public static Image slice(Image image1, VectorInt32 start, VectorInt32 stop) {
    return new Image(SimpleITKJNI.slice__SWIG_1(Image.getCPtr(image1), image1, VectorInt32.getCPtr(start), start, VectorInt32.getCPtr(stop), stop), true);
  }

  public static Image slice(Image image1, VectorInt32 start) {
    return new Image(SimpleITKJNI.slice__SWIG_2(Image.getCPtr(image1), image1, VectorInt32.getCPtr(start), start), true);
  }

  public static Image slice(Image image1) {
    return new Image(SimpleITKJNI.slice__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussian(const Image &amp;image1, double sigma, bool
normalizeAcrossScale=false)

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter in order to support a procedural API


See:
 itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface


*/
public  static Image smoothingRecursiveGaussian(Image image1, VectorDouble sigma, boolean normalizeAcrossScale) {
    return new Image(SimpleITKJNI.smoothingRecursiveGaussian__SWIG_2(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigma), sigma, normalizeAcrossScale), true);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussian(const Image &amp;image1, double sigma, bool
normalizeAcrossScale=false)

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter in order to support a procedural API


See:
 itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface


*/
public  static Image smoothingRecursiveGaussian(Image image1, VectorDouble sigma) {
    return new Image(SimpleITKJNI.smoothingRecursiveGaussian__SWIG_3(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigma), sigma), true);
  }

  /**
Image itk::simple::SmoothingRecursiveGaussian(const Image &amp;image1, double sigma, bool
normalizeAcrossScale=false)

Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.


This function directly calls the execute method of SmoothingRecursiveGaussianImageFilter in order to support a procedural API


See:
 itk::simple::SmoothingRecursiveGaussianImageFilter for the object oriented interface


*/
public  static Image smoothingRecursiveGaussian(Image image1) {
    return new Image(SimpleITKJNI.smoothingRecursiveGaussian__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image sobelEdgeDetection(Image image1) {
    return new Image(SimpleITKJNI.sobelEdgeDetection(Image.getCPtr(image1), image1), true);
  }

  public static Image speckleNoise(Image image1, double standardDeviation, long seed) {
    return new Image(SimpleITKJNI.speckleNoise__SWIG_0(Image.getCPtr(image1), image1, standardDeviation, seed), true);
  }

  public static Image speckleNoise(Image image1, double standardDeviation) {
    return new Image(SimpleITKJNI.speckleNoise__SWIG_1(Image.getCPtr(image1), image1, standardDeviation), true);
  }

  public static Image speckleNoise(Image image1) {
    return new Image(SimpleITKJNI.speckleNoise__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image sqrt(Image image1) {
    return new Image(SimpleITKJNI.sqrt(Image.getCPtr(image1), image1), true);
  }

  public static Image square(Image image1) {
    return new Image(SimpleITKJNI.square(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::SquaredDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image squaredDifference(Image image1, Image image2) {
    return new Image(SimpleITKJNI.squaredDifference__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::SquaredDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image squaredDifference(Image image1, double constant) {
    return new Image(SimpleITKJNI.squaredDifference__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::SquaredDifference(Image &amp;&amp;image1, double constant)
*/
public  static Image squaredDifference(double constant, Image image2) {
    return new Image(SimpleITKJNI.squaredDifference__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image standardDeviationProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.standardDeviationProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image standardDeviationProjection(Image image1) {
    return new Image(SimpleITKJNI.standardDeviationProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image stochasticFractalDimension(Image image, Image maskImage, VectorUInt32 neighborhoodRadius) {
    return new Image(SimpleITKJNI.stochasticFractalDimension__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, VectorUInt32.getCPtr(neighborhoodRadius), neighborhoodRadius), true);
  }

  public static Image stochasticFractalDimension(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.stochasticFractalDimension__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image stochasticFractalDimension(Image image, VectorUInt32 neighborhoodRadius) {
    return new Image(SimpleITKJNI.stochasticFractalDimension__SWIG_2(Image.getCPtr(image), image, VectorUInt32.getCPtr(neighborhoodRadius), neighborhoodRadius), true);
  }

  public static Image stochasticFractalDimension(Image image) {
    return new Image(SimpleITKJNI.stochasticFractalDimension__SWIG_3(Image.getCPtr(image), image), true);
  }

  /**
Image itk::simple::Subtract(Image &amp;&amp;image1, double constant)
*/
public  static Image subtract(Image image1, Image image2) {
    return new Image(SimpleITKJNI.subtract__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Subtract(Image &amp;&amp;image1, double constant)
*/
public  static Image subtract(Image image1, double constant) {
    return new Image(SimpleITKJNI.subtract__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Subtract(Image &amp;&amp;image1, double constant)
*/
public  static Image subtract(double constant, Image image2) {
    return new Image(SimpleITKJNI.subtract__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image sumProjection(Image image1, long projectionDimension) {
    return new Image(SimpleITKJNI.sumProjection__SWIG_0(Image.getCPtr(image1), image1, projectionDimension), true);
  }

  public static Image sumProjection(Image image1) {
    return new Image(SimpleITKJNI.sumProjection__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image tan(Image image1) {
    return new Image(SimpleITKJNI.tan(Image.getCPtr(image1), image1), true);
  }

  public static Image ternaryAdd(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.ternaryAdd(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image ternaryMagnitude(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.ternaryMagnitude(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image ternaryMagnitudeSquared(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.ternaryMagnitudeSquared(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image threshold(Image image1, double lower, double upper, double outsideValue) {
    return new Image(SimpleITKJNI.threshold__SWIG_0(Image.getCPtr(image1), image1, lower, upper, outsideValue), true);
  }

  public static Image threshold(Image image1, double lower, double upper) {
    return new Image(SimpleITKJNI.threshold__SWIG_1(Image.getCPtr(image1), image1, lower, upper), true);
  }

  public static Image threshold(Image image1, double lower) {
    return new Image(SimpleITKJNI.threshold__SWIG_2(Image.getCPtr(image1), image1, lower), true);
  }

  public static Image threshold(Image image1) {
    return new Image(SimpleITKJNI.threshold__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image thresholdMaximumConnectedComponents(Image image1, long minimumObjectSizeInPixels, double upperBoundary, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.thresholdMaximumConnectedComponents__SWIG_0(Image.getCPtr(image1), image1, minimumObjectSizeInPixels, upperBoundary, insideValue, outsideValue), true);
  }

  public static Image thresholdMaximumConnectedComponents(Image image1, long minimumObjectSizeInPixels, double upperBoundary, short insideValue) {
    return new Image(SimpleITKJNI.thresholdMaximumConnectedComponents__SWIG_1(Image.getCPtr(image1), image1, minimumObjectSizeInPixels, upperBoundary, insideValue), true);
  }

  public static Image thresholdMaximumConnectedComponents(Image image1, long minimumObjectSizeInPixels, double upperBoundary) {
    return new Image(SimpleITKJNI.thresholdMaximumConnectedComponents__SWIG_2(Image.getCPtr(image1), image1, minimumObjectSizeInPixels, upperBoundary), true);
  }

  public static Image thresholdMaximumConnectedComponents(Image image1, long minimumObjectSizeInPixels) {
    return new Image(SimpleITKJNI.thresholdMaximumConnectedComponents__SWIG_3(Image.getCPtr(image1), image1, minimumObjectSizeInPixels), true);
  }

  public static Image thresholdMaximumConnectedComponents(Image image1) {
    return new Image(SimpleITKJNI.thresholdMaximumConnectedComponents__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations, boolean reverseExpansionDirection) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_0(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations, reverseExpansionDirection), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold, double maximumRMSError, double propagationScaling, double curvatureScaling, long numberOfIterations) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_1(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold, maximumRMSError, propagationScaling, curvatureScaling, numberOfIterations), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold, double maximumRMSError, double propagationScaling, double curvatureScaling) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_2(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold, maximumRMSError, propagationScaling, curvatureScaling), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold, double maximumRMSError, double propagationScaling) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_3(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold, maximumRMSError, propagationScaling), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold, double maximumRMSError) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_4(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold, maximumRMSError), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold, double upperThreshold) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_5(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold, upperThreshold), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage, double lowerThreshold) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_6(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage, lowerThreshold), true);
  }

  public static Image thresholdSegmentationLevelSet(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.thresholdSegmentationLevelSet__SWIG_7(Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

  public static Image tikhonovDeconvolution(Image image1, Image image2, double regularizationConstant, boolean normalize, TikhonovDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, TikhonovDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.tikhonovDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, regularizationConstant, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image tikhonovDeconvolution(Image image1, Image image2, double regularizationConstant, boolean normalize, TikhonovDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.tikhonovDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, regularizationConstant, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image tikhonovDeconvolution(Image image1, Image image2, double regularizationConstant, boolean normalize) {
    return new Image(SimpleITKJNI.tikhonovDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, regularizationConstant, normalize), true);
  }

  public static Image tikhonovDeconvolution(Image image1, Image image2, double regularizationConstant) {
    return new Image(SimpleITKJNI.tikhonovDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, regularizationConstant), true);
  }

  public static Image tikhonovDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.tikhonovDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image tile(VectorOfImage images, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_0(VectorOfImage.getCPtr(images), images, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(VectorOfImage images, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_1(VectorOfImage.getCPtr(images), images, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(VectorOfImage images) {
    return new Image(SimpleITKJNI.tile__SWIG_2(VectorOfImage.getCPtr(images), images), true);
  }

  public static Image tile(Image image1, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(Image image1, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(Image image1) {
    return new Image(SimpleITKJNI.tile__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image tile(Image image1, Image image2, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_6(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(Image image1, Image image2, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_7(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(Image image1, Image image2) {
    return new Image(SimpleITKJNI.tile__SWIG_8(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_9(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_10(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.tile__SWIG_11(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_12(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_13(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.tile__SWIG_14(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4, Image image5, VectorUInt32 layout, double defaultPixelValue) {
    return new Image(SimpleITKJNI.tile__SWIG_15(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, VectorUInt32.getCPtr(layout), layout, defaultPixelValue), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4, Image image5, VectorUInt32 layout) {
    return new Image(SimpleITKJNI.tile__SWIG_16(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5, VectorUInt32.getCPtr(layout), layout), true);
  }

  public static Image tile(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.tile__SWIG_17(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public static Image toboggan(Image image1) {
    return new Image(SimpleITKJNI.toboggan(Image.getCPtr(image1), image1), true);
  }

  public static Image transformGeometry(Image image, Transform transform) {
    return new Image(SimpleITKJNI.transformGeometry(Image.getCPtr(image), image, Transform.getCPtr(transform), transform), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform, PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_0(Transform.getCPtr(transform), transform, outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform, PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble outputOrigin, VectorDouble outputSpacing) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_1(Transform.getCPtr(transform), transform, outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform, PixelIDValueEnum outputPixelType, VectorUInt32 size, VectorDouble outputOrigin) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_2(Transform.getCPtr(transform), transform, outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size, VectorDouble.getCPtr(outputOrigin), outputOrigin), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform, PixelIDValueEnum outputPixelType, VectorUInt32 size) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_3(Transform.getCPtr(transform), transform, outputPixelType.swigValue(), VectorUInt32.getCPtr(size), size), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_4(Transform.getCPtr(transform), transform, outputPixelType.swigValue()), true);
  }

  /**
Image itk::simple::TransformToDisplacementField(const Transform &amp;transform, PixelIDValueEnum
outputPixelType=itk::simple::sitkVectorFloat64, std::vector&lt;
unsigned int &gt; size=std::vector&lt; unsigned int &gt;(3, 64),
std::vector&lt; double &gt; outputOrigin=std::vector&lt; double
&gt;(3, 0.0), std::vector&lt; double &gt;
outputSpacing=std::vector&lt; double &gt;(3, 1.0), std::vector&lt;
double &gt; outputDirection=std::vector&lt; double &gt;())

Generate a displacement field from a coordinate transform.


This function directly calls the execute method of TransformToDisplacementFieldFilter in order to support a procedural API


See:
 itk::simple::TransformToDisplacementFieldFilter for the object oriented interface


*/
public  static Image transformToDisplacementField(Transform transform) {
    return new Image(SimpleITKJNI.transformToDisplacementField__SWIG_5(Transform.getCPtr(transform), transform), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image triangleThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image triangleThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image triangleThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image triangleThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image triangleThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image triangleThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image triangleThreshold(Image image) {
    return new Image(SimpleITKJNI.triangleThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image unaryMinus(Image image1) {
    return new Image(SimpleITKJNI.unaryMinus(Image.getCPtr(image1), image1), true);
  }

  public static Image unsharpMask(Image image1, VectorDouble sigmas, double amount, double threshold, boolean clamp) {
    return new Image(SimpleITKJNI.unsharpMask__SWIG_0(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigmas), sigmas, amount, threshold, clamp), true);
  }

  public static Image unsharpMask(Image image1, VectorDouble sigmas, double amount, double threshold) {
    return new Image(SimpleITKJNI.unsharpMask__SWIG_1(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigmas), sigmas, amount, threshold), true);
  }

  public static Image unsharpMask(Image image1, VectorDouble sigmas, double amount) {
    return new Image(SimpleITKJNI.unsharpMask__SWIG_2(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigmas), sigmas, amount), true);
  }

  public static Image unsharpMask(Image image1, VectorDouble sigmas) {
    return new Image(SimpleITKJNI.unsharpMask__SWIG_3(Image.getCPtr(image1), image1, VectorDouble.getCPtr(sigmas), sigmas), true);
  }

  public static Image unsharpMask(Image image1) {
    return new Image(SimpleITKJNI.unsharpMask__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image valuedRegionalMaxima(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.valuedRegionalMaxima__SWIG_0(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image valuedRegionalMaxima(Image image1) {
    return new Image(SimpleITKJNI.valuedRegionalMaxima__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image valuedRegionalMinima(Image image1, boolean fullyConnected) {
    return new Image(SimpleITKJNI.valuedRegionalMinima__SWIG_0(Image.getCPtr(image1), image1, fullyConnected), true);
  }

  public static Image valuedRegionalMinima(Image image1) {
    return new Image(SimpleITKJNI.valuedRegionalMinima__SWIG_1(Image.getCPtr(image1), image1), true);
  }

  public static Image vectorConfidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier, long initialNeighborhoodRadius, short replaceValue) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_0(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier, initialNeighborhoodRadius, replaceValue), true);
  }

  public static Image vectorConfidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier, long initialNeighborhoodRadius) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_1(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier, initialNeighborhoodRadius), true);
  }

  public static Image vectorConfidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations, double multiplier) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_2(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations, multiplier), true);
  }

  public static Image vectorConfidenceConnected(Image image1, VectorUIntList seedList, long numberOfIterations) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_3(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList, numberOfIterations), true);
  }

  public static Image vectorConfidenceConnected(Image image1, VectorUIntList seedList) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_4(Image.getCPtr(image1), image1, VectorUIntList.getCPtr(seedList), seedList), true);
  }

  public static Image vectorConfidenceConnected(Image image1) {
    return new Image(SimpleITKJNI.vectorConfidenceConnected__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image vectorConnectedComponent(Image image1, double distanceThreshold, boolean fullyConnected) {
    return new Image(SimpleITKJNI.vectorConnectedComponent__SWIG_0(Image.getCPtr(image1), image1, distanceThreshold, fullyConnected), true);
  }

  public static Image vectorConnectedComponent(Image image1, double distanceThreshold) {
    return new Image(SimpleITKJNI.vectorConnectedComponent__SWIG_1(Image.getCPtr(image1), image1, distanceThreshold), true);
  }

  public static Image vectorConnectedComponent(Image image1) {
    return new Image(SimpleITKJNI.vectorConnectedComponent__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image vectorIndexSelectionCast(Image image1, long index, PixelIDValueEnum outputPixelType) {
    return new Image(SimpleITKJNI.vectorIndexSelectionCast__SWIG_0(Image.getCPtr(image1), image1, index, outputPixelType.swigValue()), true);
  }

  public static Image vectorIndexSelectionCast(Image image1, long index) {
    return new Image(SimpleITKJNI.vectorIndexSelectionCast__SWIG_1(Image.getCPtr(image1), image1, index), true);
  }

  public static Image vectorIndexSelectionCast(Image image1) {
    return new Image(SimpleITKJNI.vectorIndexSelectionCast__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image vectorMagnitude(Image image1) {
    return new Image(SimpleITKJNI.vectorMagnitude(Image.getCPtr(image1), image1), true);
  }

  public static Image votingBinaryHoleFilling(Image image1, VectorUInt32 radius, long majorityThreshold, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.votingBinaryHoleFilling__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, majorityThreshold, foregroundValue, backgroundValue), true);
  }

  public static Image votingBinaryHoleFilling(Image image1, VectorUInt32 radius, long majorityThreshold, double foregroundValue) {
    return new Image(SimpleITKJNI.votingBinaryHoleFilling__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, majorityThreshold, foregroundValue), true);
  }

  public static Image votingBinaryHoleFilling(Image image1, VectorUInt32 radius, long majorityThreshold) {
    return new Image(SimpleITKJNI.votingBinaryHoleFilling__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, majorityThreshold), true);
  }

  public static Image votingBinaryHoleFilling(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.votingBinaryHoleFilling__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image votingBinaryHoleFilling(Image image1) {
    return new Image(SimpleITKJNI.votingBinaryHoleFilling__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image votingBinary(Image image1, VectorUInt32 radius, long birthThreshold, long survivalThreshold, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, birthThreshold, survivalThreshold, foregroundValue, backgroundValue), true);
  }

  public static Image votingBinary(Image image1, VectorUInt32 radius, long birthThreshold, long survivalThreshold, double foregroundValue) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, birthThreshold, survivalThreshold, foregroundValue), true);
  }

  public static Image votingBinary(Image image1, VectorUInt32 radius, long birthThreshold, long survivalThreshold) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, birthThreshold, survivalThreshold), true);
  }

  public static Image votingBinary(Image image1, VectorUInt32 radius, long birthThreshold) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, birthThreshold), true);
  }

  public static Image votingBinary(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image votingBinary(Image image1) {
    return new Image(SimpleITKJNI.votingBinary__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1, VectorUInt32 radius, long maximumNumberOfIterations, long majorityThreshold, double foregroundValue, double backgroundValue) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, maximumNumberOfIterations, majorityThreshold, foregroundValue, backgroundValue), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1, VectorUInt32 radius, long maximumNumberOfIterations, long majorityThreshold, double foregroundValue) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, maximumNumberOfIterations, majorityThreshold, foregroundValue), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1, VectorUInt32 radius, long maximumNumberOfIterations, long majorityThreshold) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, maximumNumberOfIterations, majorityThreshold), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1, VectorUInt32 radius, long maximumNumberOfIterations) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_3(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius, maximumNumberOfIterations), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1, VectorUInt32 radius) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_4(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(radius), radius), true);
  }

  public static Image votingBinaryIterativeHoleFilling(Image image1) {
    return new Image(SimpleITKJNI.votingBinaryIterativeHoleFilling__SWIG_5(Image.getCPtr(image1), image1), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator, VectorUInt32 outputSize, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection, double edgePaddingValue) {
    return new Image(SimpleITKJNI.warp__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue(), VectorUInt32.getCPtr(outputSize), outputSize, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection, edgePaddingValue), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator, VectorUInt32 outputSize, VectorDouble outputOrigin, VectorDouble outputSpacing, VectorDouble outputDirection) {
    return new Image(SimpleITKJNI.warp__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue(), VectorUInt32.getCPtr(outputSize), outputSize, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing, VectorDouble.getCPtr(outputDirection), outputDirection), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator, VectorUInt32 outputSize, VectorDouble outputOrigin, VectorDouble outputSpacing) {
    return new Image(SimpleITKJNI.warp__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue(), VectorUInt32.getCPtr(outputSize), outputSize, VectorDouble.getCPtr(outputOrigin), outputOrigin, VectorDouble.getCPtr(outputSpacing), outputSpacing), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator, VectorUInt32 outputSize, VectorDouble outputOrigin) {
    return new Image(SimpleITKJNI.warp__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue(), VectorUInt32.getCPtr(outputSize), outputSize, VectorDouble.getCPtr(outputOrigin), outputOrigin), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator, VectorUInt32 outputSize) {
    return new Image(SimpleITKJNI.warp__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue(), VectorUInt32.getCPtr(outputSize), outputSize), true);
  }

  public static Image warp(Image image, Image displacementField, InterpolatorEnum interpolator) {
    return new Image(SimpleITKJNI.warp__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField, interpolator.swigValue()), true);
  }

  public static Image warp(Image image, Image displacementField) {
    return new Image(SimpleITKJNI.warp__SWIG_6(Image.getCPtr(image), image, Image.getCPtr(displacementField), displacementField), true);
  }

  public static Image whiteTopHat(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType, boolean safeBorder) {
    return new Image(SimpleITKJNI.whiteTopHat__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue(), safeBorder), true);
  }

  public static Image whiteTopHat(Image image1, VectorUInt32 kernelRadius, KernelEnum kernelType) {
    return new Image(SimpleITKJNI.whiteTopHat__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius, kernelType.swigValue()), true);
  }

  public static Image whiteTopHat(Image image1, VectorUInt32 kernelRadius) {
    return new Image(SimpleITKJNI.whiteTopHat__SWIG_2(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(kernelRadius), kernelRadius), true);
  }

  public static Image whiteTopHat(Image image1) {
    return new Image(SimpleITKJNI.whiteTopHat__SWIG_3(Image.getCPtr(image1), image1), true);
  }

  public static Image wienerDeconvolution(Image image1, Image image2, double noiseVariance, boolean normalize, WienerDeconvolutionImageFilter.BoundaryConditionType boundaryCondition, WienerDeconvolutionImageFilter.OutputRegionModeType outputRegionMode) {
    return new Image(SimpleITKJNI.wienerDeconvolution__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, noiseVariance, normalize, boundaryCondition.swigValue(), outputRegionMode.swigValue()), true);
  }

  public static Image wienerDeconvolution(Image image1, Image image2, double noiseVariance, boolean normalize, WienerDeconvolutionImageFilter.BoundaryConditionType boundaryCondition) {
    return new Image(SimpleITKJNI.wienerDeconvolution__SWIG_1(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, noiseVariance, normalize, boundaryCondition.swigValue()), true);
  }

  public static Image wienerDeconvolution(Image image1, Image image2, double noiseVariance, boolean normalize) {
    return new Image(SimpleITKJNI.wienerDeconvolution__SWIG_2(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, noiseVariance, normalize), true);
  }

  public static Image wienerDeconvolution(Image image1, Image image2, double noiseVariance) {
    return new Image(SimpleITKJNI.wienerDeconvolution__SWIG_3(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, noiseVariance), true);
  }

  public static Image wienerDeconvolution(Image image1, Image image2) {
    return new Image(SimpleITKJNI.wienerDeconvolution__SWIG_4(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public static Image wrapPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound) {
    return new Image(SimpleITKJNI.wrapPad__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound), true);
  }

  public static Image wrapPad(Image image1, VectorUInt32 padLowerBound) {
    return new Image(SimpleITKJNI.wrapPad__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound), true);
  }

  public static Image wrapPad(Image image1) {
    return new Image(SimpleITKJNI.wrapPad__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::Xor(int constant, const Image &amp;image2)
*/
public  static Image xor(Image image1, Image image2) {
    return new Image(SimpleITKJNI.xor__SWIG_0(Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Xor(int constant, const Image &amp;image2)
*/
public  static Image xor(Image image1, int constant) {
    return new Image(SimpleITKJNI.xor__SWIG_1(Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Xor(int constant, const Image &amp;image2)
*/
public  static Image xor(int constant, Image image2) {
    return new Image(SimpleITKJNI.xor__SWIG_2(constant, Image.getCPtr(image2), image2), true);
  }

  public static Image yenThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_0(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image yenThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_1(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image yenThreshold(Image image, Image maskImage, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_2(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image yenThreshold(Image image, Image maskImage, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_3(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue, outsideValue), true);
  }

  public static Image yenThreshold(Image image, Image maskImage, short insideValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_4(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, insideValue), true);
  }

  public static Image yenThreshold(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_5(Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  public static Image yenThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput, short maskValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_6(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput, maskValue), true);
  }

  public static Image yenThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins, boolean maskOutput) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_7(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins, maskOutput), true);
  }

  public static Image yenThreshold(Image image, short insideValue, short outsideValue, long numberOfHistogramBins) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_8(Image.getCPtr(image), image, insideValue, outsideValue, numberOfHistogramBins), true);
  }

  public static Image yenThreshold(Image image, short insideValue, short outsideValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_9(Image.getCPtr(image), image, insideValue, outsideValue), true);
  }

  public static Image yenThreshold(Image image, short insideValue) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_10(Image.getCPtr(image), image, insideValue), true);
  }

  public static Image yenThreshold(Image image) {
    return new Image(SimpleITKJNI.yenThreshold__SWIG_11(Image.getCPtr(image), image), true);
  }

  public static Image zeroCrossingBasedEdgeDetection(Image image1, double variance, short foregroundValue, short backgroundValue, double maximumError) {
    return new Image(SimpleITKJNI.zeroCrossingBasedEdgeDetection__SWIG_0(Image.getCPtr(image1), image1, variance, foregroundValue, backgroundValue, maximumError), true);
  }

  public static Image zeroCrossingBasedEdgeDetection(Image image1, double variance, short foregroundValue, short backgroundValue) {
    return new Image(SimpleITKJNI.zeroCrossingBasedEdgeDetection__SWIG_1(Image.getCPtr(image1), image1, variance, foregroundValue, backgroundValue), true);
  }

  public static Image zeroCrossingBasedEdgeDetection(Image image1, double variance, short foregroundValue) {
    return new Image(SimpleITKJNI.zeroCrossingBasedEdgeDetection__SWIG_2(Image.getCPtr(image1), image1, variance, foregroundValue), true);
  }

  public static Image zeroCrossingBasedEdgeDetection(Image image1, double variance) {
    return new Image(SimpleITKJNI.zeroCrossingBasedEdgeDetection__SWIG_3(Image.getCPtr(image1), image1, variance), true);
  }

  public static Image zeroCrossingBasedEdgeDetection(Image image1) {
    return new Image(SimpleITKJNI.zeroCrossingBasedEdgeDetection__SWIG_4(Image.getCPtr(image1), image1), true);
  }

  public static Image zeroCrossing(Image image1, short foregroundValue, short backgroundValue) {
    return new Image(SimpleITKJNI.zeroCrossing__SWIG_0(Image.getCPtr(image1), image1, foregroundValue, backgroundValue), true);
  }

  public static Image zeroCrossing(Image image1, short foregroundValue) {
    return new Image(SimpleITKJNI.zeroCrossing__SWIG_1(Image.getCPtr(image1), image1, foregroundValue), true);
  }

  public static Image zeroCrossing(Image image1) {
    return new Image(SimpleITKJNI.zeroCrossing__SWIG_2(Image.getCPtr(image1), image1), true);
  }

  public static Image zeroFluxNeumannPad(Image image1, VectorUInt32 padLowerBound, VectorUInt32 padUpperBound) {
    return new Image(SimpleITKJNI.zeroFluxNeumannPad__SWIG_0(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound, VectorUInt32.getCPtr(padUpperBound), padUpperBound), true);
  }

  public static Image zeroFluxNeumannPad(Image image1, VectorUInt32 padLowerBound) {
    return new Image(SimpleITKJNI.zeroFluxNeumannPad__SWIG_1(Image.getCPtr(image1), image1, VectorUInt32.getCPtr(padLowerBound), padLowerBound), true);
  }

  public static Image zeroFluxNeumannPad(Image image1) {
    return new Image(SimpleITKJNI.zeroFluxNeumannPad__SWIG_2(Image.getCPtr(image1), image1), true);
  }

}
