/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.cluster.routing.UnassignedInfo;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public final class AllocationDecision
extends Enum<AllocationDecision>
implements Writeable {
    public static final /* enum */ AllocationDecision YES = new AllocationDecision(0);
    public static final /* enum */ AllocationDecision THROTTLED = new AllocationDecision(1);
    public static final /* enum */ AllocationDecision NO = new AllocationDecision(2);
    public static final /* enum */ AllocationDecision WORSE_BALANCE = new AllocationDecision(3);
    public static final /* enum */ AllocationDecision AWAITING_INFO = new AllocationDecision(4);
    public static final /* enum */ AllocationDecision ALLOCATION_DELAYED = new AllocationDecision(5);
    public static final /* enum */ AllocationDecision NO_VALID_SHARD_COPY = new AllocationDecision(6);
    public static final /* enum */ AllocationDecision NO_ATTEMPT = new AllocationDecision(7);
    private final byte id;
    private static final /* synthetic */ AllocationDecision[] $VALUES;

    public static AllocationDecision[] values() {
        return (AllocationDecision[])$VALUES.clone();
    }

    public static AllocationDecision valueOf(String name) {
        return Enum.valueOf(AllocationDecision.class, name);
    }

    private AllocationDecision(byte id) {
        this.id = id;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public static AllocationDecision readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 0: {
                return YES;
            }
            case 1: {
                return THROTTLED;
            }
            case 2: {
                return NO;
            }
            case 3: {
                return WORSE_BALANCE;
            }
            case 4: {
                return AWAITING_INFO;
            }
            case 5: {
                return ALLOCATION_DELAYED;
            }
            case 6: {
                return NO_VALID_SHARD_COPY;
            }
            case 7: {
                return NO_ATTEMPT;
            }
        }
        throw new IllegalArgumentException("Unknown value [" + id + "]");
    }

    public static AllocationDecision fromAllocationStatus(UnassignedInfo.AllocationStatus allocationStatus) {
        if (allocationStatus == null) {
            return YES;
        }
        switch (allocationStatus) {
            case DECIDERS_THROTTLED: {
                return THROTTLED;
            }
            case FETCHING_SHARD_DATA: {
                return AWAITING_INFO;
            }
            case DELAYED_ALLOCATION: {
                return ALLOCATION_DELAYED;
            }
            case NO_VALID_SHARD_COPY: {
                return NO_VALID_SHARD_COPY;
            }
            case NO_ATTEMPT: {
                return NO_ATTEMPT;
            }
        }
        assert (allocationStatus == UnassignedInfo.AllocationStatus.DECIDERS_NO) : "unhandled AllocationStatus type [" + String.valueOf((Object)allocationStatus) + "]";
        return NO;
    }

    public static AllocationDecision fromDecisionType(Decision.Type type) {
        switch (type) {
            case YES: {
                return YES;
            }
            case THROTTLE: {
                return THROTTLED;
            }
        }
        assert (type == Decision.Type.NO);
        return NO;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    private static /* synthetic */ AllocationDecision[] $values() {
        return new AllocationDecision[]{YES, THROTTLED, NO, WORSE_BALANCE, AWAITING_INFO, ALLOCATION_DELAYED, NO_VALID_SHARD_COPY, NO_ATTEMPT};
    }

    static {
        $VALUES = AllocationDecision.$values();
    }
}

