/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.ShapeTools;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.PolylineController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PolylinePanel
extends JPanel
implements DialogView {
    private final PolylineController controller;
    private JLabel thicknessLabel;
    private JSpinner thicknessSpinner;
    private JLabel arrowsStyleLabel;
    private JComboBox arrowsStyleComboBox;
    private JLabel joinStyleLabel;
    private JComboBox joinStyleComboBox;
    private JLabel dashStyleLabel;
    private JComboBox dashStyleComboBox;
    private JLabel dashOffsetLabel;
    private JSpinner dashOffsetSpinner;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private NullableCheckBox visibleIn3DViewCheckBox;
    private String dialogTitle;

    public PolylinePanel(UserPreferences userPreferences, PolylineController polylineController) {
        super(new GridBagLayout());
        this.controller = polylineController;
        this.createComponents(userPreferences, polylineController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(UserPreferences userPreferences, final PolylineController polylineController) {
        Cloneable cloneable;
        this.thicknessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "thicknessLabel.text", userPreferences.getLengthUnit().getName()));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, userPreferences.getLengthUnit().getMinimumLength(), 50.0f);
        this.thicknessSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setNullable(polylineController.getThickness() == null);
        nullableSpinnerLengthModel.setLength(polylineController.getThickness());
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                polylineController.setThickness(nullableSpinnerLengthModel.getLength());
            }
        });
        polylineController.addPropertyChangeListener(PolylineController.Property.THICKNESS, new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength(polylineController.getThickness());
            }
        });
        this.arrowsStyleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "arrowsStyleLabel.text", new Object[0]));
        ArrowsStyle[] arrowsStyleArray = ArrowsStyle.getArrowsStyle();
        if (polylineController.getCapStyle() == null) {
            ArrayList<ArrowsStyle> arrayList = new ArrayList<ArrowsStyle>();
            arrayList.add(null);
            arrayList.addAll(Arrays.asList(arrowsStyleArray));
            arrowsStyleArray = arrayList.toArray(new ArrowsStyle[arrayList.size()]);
        }
        this.arrowsStyleComboBox = new JComboBox<ArrowsStyle>(new DefaultComboBoxModel<ArrowsStyle>(arrowsStyleArray));
        this.arrowsStyleComboBox.setMaximumRowCount(arrowsStyleArray.length);
        final float f = SwingTools.getResolutionScale();
        this.arrowsStyleComboBox.setRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                final ArrowsStyle arrowsStyle = (ArrowsStyle)object;
                Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                this.setIcon(new Icon(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public int getIconWidth() {
                        return Math.round(64.0f * f);
                    }

                    @Override
                    public int getIconHeight() {
                        return Math.round(16.0f * f);
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        if (arrowsStyle != null) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            graphics2D.scale(f, f);
                            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                                graphics2D.translate(0, 2);
                            }
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            graphics2D.setColor(jList.getForeground());
                            int n3 = 64;
                            graphics2D.setStroke(new BasicStroke(2.0f));
                            graphics2D.drawLine(6, 8, n3 - 6, 8);
                            switch (arrowsStyle.getStartArrowStyle()) {
                                case NONE: {
                                    break;
                                }
                                case DISC: {
                                    graphics2D.fillOval(4, 4, 9, 9);
                                    break;
                                }
                                case OPEN: {
                                    graphics2D.drawPolyline(new int[]{15, 5, 15}, new int[]{4, 8, 12}, 3);
                                    break;
                                }
                                case DELTA: {
                                    graphics2D.fillPolygon(new int[]{3, 15, 15}, new int[]{8, 3, 13}, 3);
                                }
                            }
                            switch (arrowsStyle.getEndArrowStyle()) {
                                case NONE: {
                                    break;
                                }
                                case DISC: {
                                    graphics2D.fillOval(n3 - 12, 4, 9, 9);
                                    break;
                                }
                                case OPEN: {
                                    graphics2D.drawPolyline(new int[]{n3 - 14, n3 - 4, n3 - 14}, new int[]{4, 8, 12}, 3);
                                    break;
                                }
                                case DELTA: {
                                    graphics2D.fillPolygon(new int[]{n3 - 2, n3 - 14, n3 - 14}, new int[]{8, 3, 13}, 3);
                                }
                            }
                        }
                    }
                });
                return component;
            }
        });
        this.arrowsStyleComboBox.addItemListener(new ItemListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ArrowsStyle arrowsStyle = (ArrowsStyle)this.this$0.arrowsStyleComboBox.getSelectedItem();
                if (arrowsStyle != null) {
                    polylineController.setStartArrowStyle(arrowsStyle.getStartArrowStyle());
                    polylineController.setEndArrowStyle(arrowsStyle.getEndArrowStyle());
                } else {
                    polylineController.setStartArrowStyle(null);
                    polylineController.setEndArrowStyle(null);
                }
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Polyline.ArrowStyle arrowStyle = polylineController.getStartArrowStyle();
                Polyline.ArrowStyle arrowStyle2 = polylineController.getEndArrowStyle();
                if (arrowStyle != null && arrowStyle2 != null) {
                    this.this$0.arrowsStyleComboBox.setSelectedItem(new ArrowsStyle(arrowStyle, arrowStyle2));
                } else {
                    this.this$0.arrowsStyleComboBox.setSelectedItem(null);
                }
                this.this$0.arrowsStyleLabel.setEnabled(polylineController.isArrowsStyleEditable());
                this.this$0.arrowsStyleComboBox.setEnabled(polylineController.isArrowsStyleEditable());
            }
        };
        polylineController.addPropertyChangeListener(PolylineController.Property.START_ARROW_STYLE, propertyChangeListener);
        polylineController.addPropertyChangeListener(PolylineController.Property.END_ARROW_STYLE, propertyChangeListener);
        propertyChangeListener.propertyChange(null);
        this.joinStyleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "joinStyleLabel.text", new Object[0]));
        Polyline.JoinStyle[] joinStyleArray = Polyline.JoinStyle.values();
        if (polylineController.getJoinStyle() == null) {
            cloneable = new ArrayList<Polyline.JoinStyle>();
            cloneable.add(null);
            cloneable.addAll(Arrays.asList(joinStyleArray));
            joinStyleArray = cloneable.toArray(new Polyline.JoinStyle[cloneable.size()]);
        }
        this.joinStyleComboBox = new JComboBox<Polyline.JoinStyle>(new DefaultComboBoxModel<Polyline.JoinStyle>(joinStyleArray));
        cloneable = new GeneralPath();
        ((Path2D.Float)cloneable).moveTo(4.0f, 4.0f);
        ((Path2D.Float)cloneable).lineTo(58.0f, 4.0f);
        ((Path2D.Float)cloneable).lineTo(36.0f, 14.0f);
        final Arc2D.Float float_ = new Arc2D.Float(-7.0f, 6.0f, 80.0f, 40.0f, 47.0f, 86.0f, 0);
        this.joinStyleComboBox.setRenderer(new DefaultListCellRenderer(this, (GeneralPath)cloneable){
            final /* synthetic */ GeneralPath val$joinPath;
            final /* synthetic */ PolylinePanel this$0;
            {
                this.val$joinPath = generalPath;
                this.this$0 = polylinePanel;
            }

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                final Polyline.JoinStyle joinStyle = (Polyline.JoinStyle)((Object)object);
                Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                this.setIcon(new Icon(){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public int getIconWidth() {
                        return Math.round(64.0f * f);
                    }

                    @Override
                    public int getIconHeight() {
                        return Math.round(16.0f * f);
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        if (joinStyle != null) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            graphics2D.scale(f, f);
                            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                                graphics2D.translate(0, 2);
                            }
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            graphics2D.setColor(jList.getForeground());
                            graphics2D.setStroke(SwingTools.getStroke(6.0f, Polyline.CapStyle.BUTT, joinStyle, Polyline.DashStyle.SOLID));
                            if (joinStyle == Polyline.JoinStyle.CURVED) {
                                graphics2D.draw(float_);
                            } else {
                                graphics2D.draw(val$joinPath);
                            }
                        }
                    }
                });
                return component;
            }
        });
        this.joinStyleComboBox.addItemListener(new ItemListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                polylineController.setJoinStyle((Polyline.JoinStyle)((Object)this.this$0.joinStyleComboBox.getSelectedItem()));
            }
        });
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.this$0.joinStyleLabel.setEnabled(polylineController.isJoinStyleEditable());
                this.this$0.joinStyleComboBox.setEnabled(polylineController.isJoinStyleEditable());
                this.this$0.joinStyleComboBox.setSelectedItem((Object)polylineController.getJoinStyle());
            }
        };
        polylineController.addPropertyChangeListener(PolylineController.Property.JOIN_STYLE, propertyChangeListener2);
        propertyChangeListener2.propertyChange(null);
        this.dashStyleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "dashStyleLabel.text", new Object[0]));
        ArrayList<Polyline.DashStyle> arrayList = new ArrayList<Polyline.DashStyle>(Arrays.asList(Polyline.DashStyle.values()));
        if (polylineController.getDashStyle() != Polyline.DashStyle.CUSTOMIZED) {
            arrayList.remove((Object)Polyline.DashStyle.CUSTOMIZED);
        }
        if (polylineController.getDashStyle() == null) {
            arrayList.add(0, null);
        }
        this.dashStyleComboBox = new JComboBox<Polyline.DashStyle>(new DefaultComboBoxModel<Polyline.DashStyle>(arrayList.toArray(new Polyline.DashStyle[arrayList.size()])));
        this.dashStyleComboBox.setRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                final Polyline.DashStyle dashStyle = (Polyline.DashStyle)((Object)object);
                Component component = super.getListCellRendererComponent((JList<?>)jList, "", n, bl, bl2);
                this.setIcon(new Icon(){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public int getIconWidth() {
                        return Math.round(64.0f * f);
                    }

                    @Override
                    public int getIconHeight() {
                        return Math.round(16.0f * f);
                    }

                    @Override
                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        if (dashStyle != null) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            graphics2D.scale(f, f);
                            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                                graphics2D.translate(0, 2);
                            }
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            graphics2D.setColor(jList.getForeground());
                            float f2 = polylineController.getDashOffset() != null ? polylineController.getDashOffset().floatValue() : 0.0f;
                            graphics2D.setStroke(ShapeTools.getStroke(2.0f, Polyline.CapStyle.BUTT, Polyline.JoinStyle.MITER, dashStyle != Polyline.DashStyle.CUSTOMIZED ? dashStyle.getDashPattern() : polylineController.getDashPattern(), f2));
                            graphics2D.drawLine(4, 8, this.getIconWidth() - 4, 8);
                        }
                    }
                });
                return component;
            }
        });
        this.dashStyleComboBox.setSelectedItem((Object)polylineController.getDashStyle());
        this.dashStyleComboBox.addItemListener(new ItemListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                polylineController.setDashStyle((Polyline.DashStyle)((Object)this.this$0.dashStyleComboBox.getSelectedItem()));
            }
        });
        polylineController.addPropertyChangeListener(PolylineController.Property.DASH_STYLE, new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.this$0.dashStyleComboBox.setSelectedItem((Object)polylineController.getDashStyle());
                this.this$0.dashOffsetSpinner.setEnabled(polylineController.getDashStyle() != Polyline.DashStyle.SOLID);
            }
        });
        this.dashOffsetLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "dashOffsetLabel.text", new Object[0]));
        final NullableSpinner.NullableSpinnerNumberModel nullableSpinnerNumberModel = new NullableSpinner.NullableSpinnerNumberModel(0.0f, 0.0f, 100.0f, 5.0f);
        this.dashOffsetSpinner = new NullableSpinner(nullableSpinnerNumberModel);
        nullableSpinnerNumberModel.setNullable(polylineController.getDashOffset() == null);
        nullableSpinnerNumberModel.setValue(polylineController.getDashOffset() != null ? Float.valueOf(polylineController.getDashOffset().floatValue() * 100.0f) : null);
        nullableSpinnerNumberModel.addChangeListener(new ChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                polylineController.setDashOffset(nullableSpinnerNumberModel.getValue() != null ? Float.valueOf(((Number)nullableSpinnerNumberModel.getValue()).floatValue() / 100.0f) : null);
            }
        });
        polylineController.addPropertyChangeListener(PolylineController.Property.DASH_OFFSET, new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerNumberModel.setValue(polylineController.getDashOffset() != null ? Float.valueOf(polylineController.getDashOffset().floatValue() * 100.0f) : null);
                this.this$0.dashStyleComboBox.repaint();
            }
        });
        this.dashOffsetSpinner.setEnabled(polylineController.getDashStyle() != Polyline.DashStyle.SOLID);
        this.colorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "colorLabel.text", new Object[0]));
        this.colorButton = new ColorButton(userPreferences);
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(PolylinePanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(polylineController.getColor());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                polylineController.setColor(this.this$0.colorButton.getColor());
            }
        });
        polylineController.addPropertyChangeListener(PolylineController.Property.COLOR, new PropertyChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.this$0.colorButton.setColor(polylineController.getColor());
            }
        });
        this.visibleIn3DViewCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, PolylinePanel.class, "visibleIn3DViewCheckBox.text", new Object[0]));
        if (polylineController.isElevationEnabled() != null) {
            this.visibleIn3DViewCheckBox.setValue(polylineController.isElevationEnabled());
        } else {
            this.visibleIn3DViewCheckBox.setNullable(true);
            this.visibleIn3DViewCheckBox.setValue(null);
        }
        this.visibleIn3DViewCheckBox.addChangeListener(new ChangeListener(){
            final /* synthetic */ PolylinePanel this$0;
            {
                this.this$0 = polylinePanel;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (this.this$0.visibleIn3DViewCheckBox.isNullable()) {
                    this.this$0.visibleIn3DViewCheckBox.setNullable(false);
                }
                if (Boolean.FALSE.equals(this.this$0.visibleIn3DViewCheckBox.getValue())) {
                    polylineController.setElevation(null);
                } else {
                    polylineController.setElevation(Float.valueOf(0.0f));
                }
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(PolylinePanel.class, "polyline.title", new Object[0]);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.thicknessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "thicknessLabel.mnemonic", new Object[0])).getKeyCode());
            this.thicknessLabel.setLabelFor(this.thicknessSpinner);
            this.arrowsStyleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "arrowsStyleLabel.mnemonic", new Object[0])).getKeyCode());
            this.arrowsStyleLabel.setLabelFor(this.arrowsStyleComboBox);
            this.joinStyleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "joinStyleLabel.mnemonic", new Object[0])).getKeyCode());
            this.joinStyleLabel.setLabelFor(this.joinStyleComboBox);
            this.dashStyleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "dashStyleLabel.mnemonic", new Object[0])).getKeyCode());
            this.dashStyleLabel.setLabelFor(this.dashStyleComboBox);
            this.dashOffsetLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "dashOffsetLabel.mnemonic", new Object[0])).getKeyCode());
            this.dashOffsetLabel.setLabelFor(this.dashOffsetSpinner);
            this.colorLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "colorLabel.mnemonic", new Object[0])).getKeyCode());
            this.colorLabel.setLabelFor(this.colorButton);
            this.visibleIn3DViewCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(PolylinePanel.class, "visibleIn3DViewCheckBox.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        Insets insets = new Insets(0, 0, n2, n2);
        this.add((Component)this.thicknessLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        Insets insets2 = new Insets(0, 0, n2, 0);
        this.add((Component)this.thicknessSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.arrowsStyleLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.arrowsStyleComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.joinStyleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.joinStyleComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.dashStyleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.dashStyleComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.dashOffsetLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.dashOffsetSpinner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)this.colorLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        this.add((Component)this.colorButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, OperatingSystem.isMacOSX() ? 2 : -1, n2, OperatingSystem.isMacOSX() ? 3 : -1), 0, 0));
        this.add((Component)this.visibleIn3DViewCheckBox, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, ((JSpinner.DefaultEditor)this.thicknessSpinner.getEditor()).getTextField()) == 0 && this.controller != null) {
            this.controller.modifyPolylines();
        }
    }

    private static class ArrowsStyle {
        private static List<ArrowsStyle> arrowsStyle;
        private final Polyline.ArrowStyle startArrowStyle;
        private final Polyline.ArrowStyle endArrowStyle;

        public ArrowsStyle(Polyline.ArrowStyle arrowStyle, Polyline.ArrowStyle arrowStyle2) {
            this.startArrowStyle = arrowStyle;
            this.endArrowStyle = arrowStyle2;
        }

        public Polyline.ArrowStyle getStartArrowStyle() {
            return this.startArrowStyle;
        }

        public Polyline.ArrowStyle getEndArrowStyle() {
            return this.endArrowStyle;
        }

        public int hashCode() {
            int n = 0;
            if (this.startArrowStyle != null) {
                n = this.startArrowStyle.hashCode();
            }
            if (this.endArrowStyle != null) {
                n += this.endArrowStyle.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof ArrowsStyle) {
                ArrowsStyle arrowsStyle = (ArrowsStyle)object;
                return this.startArrowStyle == arrowsStyle.startArrowStyle && this.endArrowStyle == arrowsStyle.endArrowStyle;
            }
            return false;
        }

        public static ArrowsStyle[] getArrowsStyle() {
            if (arrowsStyle == null) {
                Polyline.ArrowStyle[] arrowStyleArray = Polyline.ArrowStyle.values();
                arrowsStyle = new ArrayList<ArrowsStyle>(arrowStyleArray.length * arrowStyleArray.length);
                for (Polyline.ArrowStyle arrowStyle : arrowStyleArray) {
                    for (Polyline.ArrowStyle arrowStyle2 : arrowStyleArray) {
                        arrowsStyle.add(new ArrowsStyle(arrowStyle, arrowStyle2));
                    }
                }
            }
            return arrowsStyle.toArray(new ArrowsStyle[arrowsStyle.size()]);
        }
    }
}

