/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class WildcardProperty
extends DocValuesPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, WildcardProperty> {
    @Nullable
    private final String normalizer;
    @Nullable
    private final String nullValue;
    public static final JsonpDeserializer<WildcardProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardProperty::setupWildcardPropertyDeserializer);

    private WildcardProperty(Builder builder) {
        super(builder);
        this.normalizer = builder.normalizer;
        this.nullValue = builder.nullValue;
    }

    public static WildcardProperty of(Function<Builder, ObjectBuilder<WildcardProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Wildcard;
    }

    @Nullable
    public final String normalizer() {
        return this.normalizer;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "wildcard");
        super.serializeInternal(generator, mapper);
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupWildcardPropertyDeserializer(ObjectDeserializer<Builder> op) {
        WildcardProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.normalizer);
        result = 31 * result + Objects.hashCode(this.nullValue);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardProperty other = (WildcardProperty)o;
        return Objects.equals(this.normalizer, other.normalizer) && Objects.equals(this.nullValue, other.nullValue);
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, WildcardProperty> {
        @Nullable
        private String normalizer;
        @Nullable
        private String nullValue;

        public Builder() {
        }

        private Builder(WildcardProperty o) {
            super(o);
            this.normalizer = o.normalizer;
            this.nullValue = o.nullValue;
        }

        private Builder(Builder o) {
            super(o);
            this.normalizer = o.normalizer;
            this.nullValue = o.nullValue;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        @Nonnull
        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Override
        @Nonnull
        public WildcardProperty build() {
            this._checkSingleUse();
            return new WildcardProperty(this);
        }
    }
}

