/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.security.GetNodeCertificatesResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetNodeCertificatesRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetNodeCertificatesRequest> {
    @Nullable
    private final String certType;
    @Nonnull
    private final String nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<GetNodeCertificatesRequest, GetNodeCertificatesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetNodeCertificatesRequest, GetNodeCertificatesResponse>(request -> "GET", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/certificates/");
        SimpleEndpoint.pathEncode(request.nodeId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetNodeCertificatesResponse._DESERIALIZER);

    private GetNodeCertificatesRequest(Builder builder) {
        super(builder);
        this.certType = builder.certType;
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.timeout = builder.timeout;
    }

    public static GetNodeCertificatesRequest of(Function<Builder, ObjectBuilder<GetNodeCertificatesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String certType() {
        return this.certType;
    }

    @Nonnull
    public final String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.certType != null) {
            params.put("cert_type", this.certType);
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.certType);
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetNodeCertificatesRequest other = (GetNodeCertificatesRequest)o;
        return Objects.equals(this.certType, other.certType) && this.nodeId.equals(other.nodeId) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetNodeCertificatesRequest> {
        @Nullable
        private String certType;
        private String nodeId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(GetNodeCertificatesRequest o) {
            super(o);
            this.certType = o.certType;
            this.nodeId = o.nodeId;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.certType = o.certType;
            this.nodeId = o.nodeId;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder certType(@Nullable String value) {
            this.certType = value;
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public GetNodeCertificatesRequest build() {
            this._checkSingleUse();
            return new GetNodeCertificatesRequest(this);
        }
    }
}

