/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jooq.tools.json.JSONObject;
import org.jooq.tools.json.JSONParser;
import org.jooq.tools.json.ParseException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;

public class ShardIndexingPressureMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ShardIndexingPressureMetricsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private static final Logger LOG = LogManager.getLogger(ShardIndexingPressureMetricsCollector.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JSONParser parser = new JSONParser();
    public static final String SHARD_INDEXING_PRESSURE_CLASS_NAME = "org.opensearch.index.ShardIndexingPressure";
    public static final String CLUSTER_SERVICE_CLASS_NAME = "org.opensearch.cluster.service.ClusterService";
    public static final String INDEXING_PRESSURE_CLASS_NAME = "org.opensearch.index.IndexingPressure";
    public static final String SHARD_INDEXING_PRESSURE_STORE_CLASS_NAME = "org.opensearch.index.ShardIndexingPressureStore";
    public static final String INDEXING_PRESSURE_FIELD_NAME = "indexingPressure";
    public static final String SHARD_INDEXING_PRESSURE_FIELD_NAME = "shardIndexingPressure";
    public static final String SHARD_INDEXING_PRESSURE_STORE_FIELD_NAME = "shardIndexingPressureStore";
    public static final String SHARD_INDEXING_PRESSURE_HOT_STORE_FIELD_NAME = "shardIndexingPressureHotStore";
    private static final Integer MAX_HOT_STORE_LIMIT = 50;
    private final ConfigOverridesWrapper configOverridesWrapper;
    private final PerformanceAnalyzerController controller;
    private StringBuilder value = new StringBuilder();

    public ShardIndexingPressureMetricsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "ShardIndexingPressureMetricsCollector", (MeasurementSet)StatMetrics.SHARD_INDEXING_PRESSURE_COLLECTOR_EXECUTION_TIME, StatExceptionCode.SHARD_INDEXING_PRESSURE_COLLECTOR_ERROR);
        this.configOverridesWrapper = configOverridesWrapper;
        this.controller = controller;
    }

    public void collectMetrics(long startTime) {
        if (this.controller.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        ClusterService clusterService = OpenSearchResources.INSTANCE.getClusterService();
        if (Objects.isNull(clusterService)) {
            return;
        }
        try {
            Object indexingPressure = this.getField(CLUSTER_SERVICE_CLASS_NAME, INDEXING_PRESSURE_FIELD_NAME).get(clusterService);
            Object shardIndexingPressure = this.getField(INDEXING_PRESSURE_CLASS_NAME, SHARD_INDEXING_PRESSURE_FIELD_NAME).get(indexingPressure);
            Object shardIndexingPressureStore = this.getField(SHARD_INDEXING_PRESSURE_CLASS_NAME, SHARD_INDEXING_PRESSURE_STORE_FIELD_NAME).get(shardIndexingPressure);
            Map shardIndexingPressureHotStore = (Map)this.getField(SHARD_INDEXING_PRESSURE_STORE_CLASS_NAME, SHARD_INDEXING_PRESSURE_HOT_STORE_FIELD_NAME).get(shardIndexingPressureStore);
            this.value.setLength(0);
            shardIndexingPressureHotStore.entrySet().stream().limit(MAX_HOT_STORE_LIMIT.intValue()).forEach(storeObject -> {
                JSONObject shardId;
                JSONObject tracker;
                try {
                    tracker = (JSONObject)parser.parse(mapper.writeValueAsString(storeObject.getValue()));
                    shardId = (JSONObject)parser.parse(mapper.writeValueAsString(tracker.get((Object)"shardId")));
                }
                catch (JsonProcessingException | ParseException e) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> ((ShardIndexingPressureMetricsCollector)this).getCollectorName();
                    supplierArray[1] = ((Exception)e)::getMessage;
                    LOG.debug("[ {} ] Exception raised while parsing Shard Indexing Pressure fields: {} ", supplierArray);
                    StatsCollector.instance().logException(StatExceptionCode.SHARD_INDEXING_PRESSURE_COLLECTOR_ERROR);
                    return;
                }
                this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
                this.value.append(new ShardIndexingPressureStatus(AllMetrics.IndexingStage.COORDINATING.toString(), shardId.get((Object)"indexName").toString(), shardId.get((Object)"id").toString(), Long.parseLong(tracker.get((Object)"coordinatingRejections").toString()), Long.parseLong(tracker.get((Object)"currentCoordinatingBytes").toString()), Long.parseLong(tracker.get((Object)"primaryAndCoordinatingLimits").toString()), Double.longBitsToDouble(Long.parseLong(tracker.get((Object)"coordinatingThroughputMovingAverage").toString())), Long.parseLong(tracker.get((Object)"lastSuccessfulCoordinatingRequestTimestamp").toString())).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
                this.value.append(new ShardIndexingPressureStatus(AllMetrics.IndexingStage.PRIMARY.toString(), shardId.get((Object)"indexName").toString(), shardId.get((Object)"id").toString(), Long.parseLong(tracker.get((Object)"primaryRejections").toString()), Long.parseLong(tracker.get((Object)"currentPrimaryBytes").toString()), Long.parseLong(tracker.get((Object)"primaryAndCoordinatingLimits").toString()), Double.longBitsToDouble(Long.parseLong(tracker.get((Object)"primaryThroughputMovingAverage").toString())), Long.parseLong(tracker.get((Object)"lastSuccessfulPrimaryRequestTimestamp").toString())).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
                this.value.append(new ShardIndexingPressureStatus(AllMetrics.IndexingStage.REPLICA.toString(), shardId.get((Object)"indexName").toString(), shardId.get((Object)"id").toString(), Long.parseLong(tracker.get((Object)"replicaRejections").toString()), Long.parseLong(tracker.get((Object)"currentReplicaBytes").toString()), Long.parseLong(tracker.get((Object)"replicaLimits").toString()), Double.longBitsToDouble(Long.parseLong(tracker.get((Object)"replicaThroughputMovingAverage").toString())), Long.parseLong(tracker.get((Object)"lastSuccessfulReplicaRequestTimestamp").toString())).serialize()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
            });
            if (this.value.length() != 0) {
                this.saveMetricValues(this.value.toString(), startTime, new String[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((ShardIndexingPressureMetricsCollector)this).getCollectorName();
            supplierArray[1] = e::getMessage;
            LOG.debug("[ {} ] Exception raised while getting Shard Indexing Pressure fields: {} ", supplierArray);
            StatsCollector.instance().logException(StatExceptionCode.SHARD_INDEXING_PRESSURE_COLLECTOR_ERROR);
        }
    }

    Field getField(String className, String fieldName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> clusterServiceClass = Class.forName(className);
        Field indexingPressureField = clusterServiceClass.getDeclaredField(fieldName);
        indexingPressureField.setAccessible(true);
        return indexingPressureField;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"shard_indexing_pressure_metrics"});
    }

    static class ShardIndexingPressureStatus
    extends MetricStatus {
        private final String indexingStage;
        private final String indexName;
        private final String shardId;
        private final long rejectionCount;
        private final long currentBytes;
        private final long currentLimits;
        private final double averageWindowThroughput;
        private final long lastSuccessfulTimestamp;

        public ShardIndexingPressureStatus(String indexingStage, String indexName, String shardId, long rejectionCount, long currentBytes, long currentLimits, double averageWindowThroughput, long lastSuccessfulTimestamp) {
            this.indexingStage = indexingStage;
            this.indexName = indexName;
            this.shardId = shardId;
            this.rejectionCount = rejectionCount;
            this.currentBytes = currentBytes;
            this.currentLimits = currentLimits;
            this.averageWindowThroughput = averageWindowThroughput;
            this.lastSuccessfulTimestamp = lastSuccessfulTimestamp;
        }

        @JsonProperty(value="IndexingStage")
        public String getIndexingStage() {
            return this.indexingStage;
        }

        @JsonProperty(value="IndexName")
        public String getIndexName() {
            return this.indexName;
        }

        @JsonProperty(value="ShardID")
        public String getShardId() {
            return this.shardId;
        }

        @JsonProperty(value="Indexing_Pressure_Rejection_Count")
        public long getRejectionCount() {
            return this.rejectionCount;
        }

        @JsonProperty(value="Indexing_Pressure_Current_Bytes")
        public long getCurrentBytes() {
            return this.currentBytes;
        }

        @JsonProperty(value="Indexing_Pressure_Current_Limits")
        public long getCurrentLimits() {
            return this.currentLimits;
        }

        @JsonProperty(value="Indexing_Pressure_Average_Window_Throughput")
        public double getAverageWindowThroughput() {
            return this.averageWindowThroughput;
        }

        @JsonProperty(value="Indexing_Pressure_Last_Successful_Timestamp")
        public long getLastSuccessfulTimestamp() {
            return this.lastSuccessfulTimestamp;
        }
    }
}

