/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class ThreadedTaskController
implements Controller {
    private static ExecutorService tasksExecutor;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final Callable<Void> threadedTask;
    private final String taskMessage;
    private final ExceptionHandler exceptionHandler;
    private ThreadedTaskView view;
    private Future<?> task;

    public ThreadedTaskController(Callable<Void> callable, String string, ExceptionHandler exceptionHandler, UserPreferences userPreferences, ViewFactory viewFactory) {
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.threadedTask = callable;
        this.taskMessage = string;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public ThreadedTaskView getView() {
        if (this.view == null) {
            this.view = this.viewFactory.createThreadedTaskView(this.taskMessage, this.preferences, this);
        }
        return this.view;
    }

    public void executeTask(final View view) {
        if (tasksExecutor == null) {
            tasksExecutor = Executors.newSingleThreadExecutor();
        }
        this.task = tasksExecutor.submit(new FutureTask<Void>(this, this.threadedTask){
            final /* synthetic */ ThreadedTaskController this$0;
            {
                this.this$0 = threadedTaskController;
                super(callable);
            }

            @Override
            public void run() {
                this.this$0.getView().invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.getView().setTaskRunning(true, view);
                    }
                });
                super.run();
            }

            @Override
            protected void done() {
                this.this$0.getView().invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.getView().setTaskRunning(false, view);
                        this.this$1.this$0.task = null;
                    }
                });
                try {
                    this.get();
                }
                catch (ExecutionException executionException) {
                    final Throwable throwable = executionException.getCause();
                    if (throwable instanceof Exception) {
                        this.this$0.getView().invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.exceptionHandler.handleException((Exception)throwable);
                            }
                        });
                    } else {
                        throwable.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.this$0.getView().invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.exceptionHandler.handleException(interruptedException);
                        }
                    });
                }
            }
        });
    }

    public void cancelTask() {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public boolean isTaskRunning() {
        return this.task != null && !this.task.isDone();
    }

    public static interface ExceptionHandler {
        public void handleException(Exception var1);
    }
}

