/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math.geom;

import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.math.Matrix4f;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.geom.AABBox;

public class Frustum {
    protected final Plane[] planes = new Plane[6];
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;
    public static final int NEAR = 4;
    public static final int FAR = 5;

    public Frustum() {
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Plane();
        }
    }

    public final Plane[] getPlanes() {
        return this.planes;
    }

    public final void updateByPlanes(Plane[] planeArray) {
        for (int i = 0; i < 6; ++i) {
            Plane plane = this.planes[i];
            Plane plane2 = planeArray[i];
            plane.d = plane2.d;
            System.arraycopy(plane2.n, 0, plane.n, 0, 3);
        }
    }

    public Matrix4f updateByFovDesc(Matrix4f matrix4f, FovDesc fovDesc) {
        matrix4f.setToPerspective(fovDesc.fovhv, fovDesc.zNear, fovDesc.zFar);
        matrix4f.updateFrustumPlanes(this);
        return matrix4f;
    }

    public void updateFrustumPlanes(Matrix4f matrix4f) {
        matrix4f.updateFrustumPlanes(this);
    }

    private static final boolean isOutsideImpl(Plane plane, AABBox aABBox) {
        Vec3f vec3f = aABBox.getLow();
        Vec3f vec3f2 = aABBox.getHigh();
        return !(plane.distanceTo(vec3f.x(), vec3f.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f2.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f2.y(), vec3f.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f.y(), vec3f2.z()) > 0.0f || plane.distanceTo(vec3f2.x(), vec3f.y(), vec3f2.z()) > 0.0f || plane.distanceTo(vec3f.x(), vec3f2.y(), vec3f2.z()) > 0.0f) && !(plane.distanceTo(vec3f2.x(), vec3f2.y(), vec3f2.z()) > 0.0f);
    }

    public final boolean isAABBoxOutside(AABBox aABBox) {
        for (int i = 0; i < 6; ++i) {
            if (!Frustum.isOutsideImpl(this.planes[i], aABBox)) continue;
            return true;
        }
        return false;
    }

    public final Location classifyPoint(Vec3f vec3f) {
        Location location = Location.INSIDE;
        for (int i = 0; i < 6; ++i) {
            float f = this.planes[i].distanceTo(vec3f);
            if (f < 0.0f) {
                return Location.OUTSIDE;
            }
            if (f != 0.0f) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isPointOutside(Vec3f vec3f) {
        return Location.OUTSIDE == this.classifyPoint(vec3f);
    }

    public final Location classifySphere(Vec3f vec3f, float f) {
        Location location = Location.INSIDE;
        for (int i = 0; i < 6; ++i) {
            float f2 = this.planes[i].distanceTo(vec3f);
            if (f2 < -f) {
                return Location.OUTSIDE;
            }
            if (!(f2 < f)) continue;
            location = Location.INTERSECT;
        }
        return location;
    }

    public final boolean isSphereOutside(Vec3f vec3f, float f) {
        return Location.OUTSIDE == this.classifySphere(vec3f, f);
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("Frustum[Planes[").append(System.lineSeparator()).append(" L: ").append(this.planes[0]).append(", ").append(System.lineSeparator()).append(" R: ").append(this.planes[1]).append(", ").append(System.lineSeparator()).append(" B: ").append(this.planes[2]).append(", ").append(System.lineSeparator()).append(" T: ").append(this.planes[3]).append(", ").append(System.lineSeparator()).append(" N: ").append(this.planes[4]).append(", ").append(System.lineSeparator()).append(" F: ").append(this.planes[5]).append("], ").append(System.lineSeparator()).append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public static class Plane {
        public final Vec3f n = new Vec3f();
        public float d;

        public final float distanceTo(float f, float f2, float f3) {
            return this.n.x() * f + this.n.y() * f2 + this.n.z() * f3 + this.d;
        }

        public final float distanceTo(Vec3f vec3f) {
            return this.n.x() * vec3f.x() + this.n.y() * vec3f.y() + this.n.z() * vec3f.z() + this.d;
        }

        public String toString() {
            return "Plane[ [ " + this.n + " ], " + this.d + "]";
        }
    }

    public static class FovDesc {
        public final FovHVHalves fovhv;
        public final float zNear;
        public final float zFar;

        public FovDesc(FovHVHalves fovHVHalves, float f, float f2) throws IllegalArgumentException {
            if (f <= 0.0f || f2 <= f) {
                throw new IllegalArgumentException("Requirements zNear > 0 and zFar > zNear, but zNear " + f + ", zFar " + f2);
            }
            this.fovhv = fovHVHalves;
            this.zNear = f;
            this.zFar = f2;
        }

        public final String toString() {
            return "FrustumFovDesc[" + this.fovhv.toStringInDegrees() + ", Z[" + this.zNear + " - " + this.zFar + "]]";
        }
    }

    public static enum Location {
        OUTSIDE,
        INSIDE,
        INTERSECT;

    }
}

