// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!
#ifndef _ATKMM_TEXT_H
#define _ATKMM_TEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/component.h> /* for Atk::CoordType */
#include <atk/atktext.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkText = struct _AtkText;
using AtkTextClass = struct _AtkTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API Text_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{

class ATKMM_API Attribute
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Attribute;
  using BaseObjectType = AtkAttribute;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  Attribute();
  Attribute(const Glib::ustring& name, const Glib::ustring& value);
  explicit Attribute(const AtkAttribute* gobject);
  ~Attribute();

  Attribute(const Attribute& other);
  Attribute& operator=(const Attribute& other);

  void swap(Attribute& other);

  Glib::ustring get_name() const;
  Glib::ustring get_value() const;

  /// Provides access to the underlying C GObject.
  AtkAttribute*       gobj()       { return &gobject_; }

  /// Provides access to the underlying C GObject.
  const AtkAttribute* gobj() const { return &gobject_; }

protected:
  AtkAttribute gobject_;


};

/** @relates Atk::Attribute */
inline void swap(Attribute& lhs, Attribute& rhs)
  { lhs.swap(rhs); }

struct AttributeTraits
{
  typedef Atk::Attribute      CppType;
  typedef const AtkAttribute* CType;
  typedef AtkAttribute*       CTypeNonConst;

  static CType to_c_type(CType item)          { return item; }
  static CType to_c_type(const CppType& item) { return item.gobj(); }
  static CppType to_cpp_type(CType item)      { return CppType(item); }
  static void release_c_type(CType item)      { g_free(const_cast<CTypeNonConst>(item)); }
};


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var BuiltinTextAttribute INVALID
 * Invalid attribute, like bad spelling or grammar.
 * 
 *  @var BuiltinTextAttribute LEFT_MARGIN
 * The pixel width of the left margin.
 * 
 *  @var BuiltinTextAttribute RIGHT_MARGIN
 * The pixel width of the right margin.
 * 
 *  @var BuiltinTextAttribute INDENT
 * The number of pixels that the text is indented.
 * 
 *  @var BuiltinTextAttribute INVISIBLE
 * Either "true" or "false" indicating whether text is visible or not.
 * 
 *  @var BuiltinTextAttribute EDITABLE
 * Either "true" or "false" indicating whether text is editable or not.
 * 
 *  @var BuiltinTextAttribute PIXELS_ABOVE_LINES
 * Pixels of blank space to leave above each newline-terminated line.
 * 
 *  @var BuiltinTextAttribute PIXELS_BELOW_LINES
 * Pixels of blank space to leave below each newline-terminated line.
 * 
 *  @var BuiltinTextAttribute PIXELS_INSIDE_WRAP
 * Pixels of blank space to leave between wrapped lines inside the same newline-terminated line (paragraph).
 * 
 *  @var BuiltinTextAttribute BG_FULL_HEIGHT
 * "true" or "false" whether to make the background color for each character the height of the highest font used on the current line, or the height of the font used for the current character.
 * 
 *  @var BuiltinTextAttribute RISE
 * Number of pixels that the characters are risen above the baseline. See also ATK_TEXT_ATTR_TEXT_POSITION.
 * 
 *  @var BuiltinTextAttribute UNDERLINE
 * "none", "single", "double", "low", or "error".
 * 
 *  @var BuiltinTextAttribute STRIKETHROUGH
 * "true" or "false" whether the text is strikethrough.
 * 
 *  @var BuiltinTextAttribute SIZE
 * The size of the characters in points. eg: 10.
 * 
 *  @var BuiltinTextAttribute SCALE
 * The scale of the characters. The value is a string representation of a double.
 * 
 *  @var BuiltinTextAttribute WEIGHT
 * The weight of the characters.
 * 
 *  @var BuiltinTextAttribute LANGUAGE
 * The language used.
 * 
 *  @var BuiltinTextAttribute FAMILY_NAME
 * The font family name.
 * 
 *  @var BuiltinTextAttribute BG_COLOR
 * The background color. The value is an RGB value of the format "%u,%u,%u".
 * 
 *  @var BuiltinTextAttribute FG_COLOR
 * The foreground color. The value is an RGB value of the format "%u,%u,%u".
 * 
 *  @var BuiltinTextAttribute BG_STIPPLE
 * "true" if a Gdk::Bitmap is set for stippling the background color.
 * 
 *  @var BuiltinTextAttribute FG_STIPPLE
 * "true" if a Gdk::Bitmap is set for stippling the foreground color.
 * 
 *  @var BuiltinTextAttribute WRAP_MODE
 * The wrap mode of the text, if any. Values are "none", "char", "word", or "word_char".
 * 
 *  @var BuiltinTextAttribute DIRECTION
 * The direction of the text, if set. Values are "none", "ltr" or "rtl".
 * 
 *  @var BuiltinTextAttribute JUSTIFICATION
 * The justification of the text, if set. Values are "left", "right", "center" or "fill".
 * 
 *  @var BuiltinTextAttribute STRETCH
 * The stretch of the text, if set. Values are "ultra_condensed", "extra_condensed", "condensed", "semi_condensed", "normal", "semi_expanded", "expanded", "extra_expanded" or "ultra_expanded".
 * 
 *  @var BuiltinTextAttribute VARIANT
 * The capitalization variant of the text, if set. Values are "normal" or "small_caps".
 * 
 *  @var BuiltinTextAttribute STYLE
 * The slant style of the text, if set. Values are "normal", "oblique" or "italic".
 * 
 *  @var BuiltinTextAttribute TEXT_POSITION
 * The vertical position with respect to the baseline. Values are "baseline", "super", or "sub". Note that a super or sub text attribute refers to position with respect to the baseline of the prior character.
 * 
 *  @var BuiltinTextAttribute LAST_DEFINED
 * Not a valid text attribute, used for finding end of enumeration.
 * 
 *  @enum BuiltinTextAttribute
 * 
 * Describes the text attributes supported
 *
 * @ingroup atkmmEnums
 */
enum class BuiltinTextAttribute
{
  INVALID,
  LEFT_MARGIN,
  RIGHT_MARGIN,
  INDENT,
  INVISIBLE,
  EDITABLE,
  PIXELS_ABOVE_LINES,
  PIXELS_BELOW_LINES,
  PIXELS_INSIDE_WRAP,
  BG_FULL_HEIGHT,
  RISE,
  UNDERLINE,
  STRIKETHROUGH,
  SIZE,
  SCALE,
  WEIGHT,
  LANGUAGE,
  FAMILY_NAME,
  BG_COLOR,
  FG_COLOR,
  BG_STIPPLE,
  FG_STIPPLE,
  WRAP_MODE,
  DIRECTION,
  JUSTIFICATION,
  STRETCH,
  VARIANT,
  STYLE,
  TEXT_POSITION,
  LAST_DEFINED
};


} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::BuiltinTextAttribute> : public Glib::Value_Enum<Atk::BuiltinTextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class ATKMM_API TextAttribute
{
private:
  int attribute_;

public:
  TextAttribute() : attribute_ (0) {}
  TextAttribute(BuiltinTextAttribute attribute) : attribute_(static_cast<int>(attribute)) {}

  // Behave like an ordinary enum.
  explicit TextAttribute(int attribute) : attribute_ (attribute) {}
  operator int() const { return attribute_; }

  static TextAttribute for_name(const Glib::ustring& name);
  static Glib::ustring get_name(TextAttribute attribute);
  static Glib::ustring get_value(TextAttribute attribute, int index);
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::TextAttribute> : public Glib::Value_Enum<Atk::TextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** The ATK interface implemented by components with text content.
 * This should be implemented by Atk::Objects on behalf of widgets that have text content which is either attributed
 * or otherwise non-trivial. Atk::Objects whose text content is simple, unattributed, and very brief may expose that
 * content via Atk::Object::get_name() instead; however if the text is editable, multi-line, typically longer than
 * three or four words, attributed, selectable, or if the object already uses the 'name' ATK property for other
 * information, this Text interface should be used to expose the text content. In the case of editable text content,
 * Atk::EditableText (a subtype of the Atk::Text interface) should be implemented instead.
 *
 * Atk::Text provides not only traversal facilities and change notification for text content, but also caret tracking
 * and glyph bounding box calculations. Note that the text strings are exposed as UTF-8, and are therefore potentially
 * multi-byte, and caret-to-byte offset mapping makes no assumptions about the character length; also bounding box
 * glyph-to-offset mapping may be complex for languages which use ligatures.
 */

class ATKMM_API Text : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Text;
  using CppClassType = Text_Class;
  using BaseObjectType = AtkText;
  using BaseClassType = AtkTextIface;

  // noncopyable
  Text(const Text&) = delete;
  Text& operator=(const Text&) = delete;

private:
  friend class Text_Class;
  static CppClassType text_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Text();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit Text(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit Text(AtkText* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Text(Text&& src) noexcept;
  Text& operator=(Text&& src) noexcept;

  ~Text() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkText*       gobj()       { return reinterpret_cast<AtkText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkText* gobj() const { return reinterpret_cast<AtkText*>(gobject_); }

private:


public:
  /** 
   *  @var ClipType NONE
   * No clipping to be done.
   * 
   *  @var ClipType MIN
   * Text clipped by min coordinate is omitted.
   * 
   *  @var ClipType MAX
   * Text clipped by max coordinate is omitted.
   * 
   *  @var ClipType BOTH
   * Only text fully within mix/max bound is retained.
   * 
   *  @enum ClipType
   * 
   * Describes the type of clipping required.
   *
   * @ingroup atkmmEnums
   */
  enum class ClipType
  {
    NONE,
    MIN,
    MAX,
    BOTH
  };


  /** 
   *  @var Granularity CHAR
   * Granularity is defined by the boundaries between characters
   * (including non-printing characters).
   * 
   *  @var Granularity WORD
   * Granularity is defined by the boundaries of a word,
   * starting at the beginning of the current word and finishing at the beginning of
   * the following one, if present.
   * 
   *  @var Granularity SENTENCE
   * Granularity is defined by the boundaries of a sentence,
   * starting at the beginning of the current sentence and finishing at the beginning of
   * the following one, if present.
   * 
   *  @var Granularity LINE
   * Granularity is defined by the boundaries of a line,
   * starting at the beginning of the current line and finishing at the beginning of
   * the following one, if present.
   * 
   *  @var Granularity PARAGRAPH
   * Granularity is defined by the boundaries of a paragraph,
   * starting at the beginning of the current paragraph and finishing at the beginning of
   * the following one, if present.
   * 
   *  @enum Granularity
   * 
   * Text granularity types used for specifying the granularity of the region of
   * text we are interested in.
   *
   * @ingroup atkmmEnums
   */
  enum class Granularity
  {
    CHAR,
    WORD,
    SENTENCE,
    LINE,
    PARAGRAPH
  };


  /** Gets the specified text.
   * 
   * @param start_offset A starting character offset within @a text.
   * @param end_offset An ending character offset within @a text, or -1 for the end of the string.
   * @return A newly allocated string containing the text from @a start_offset up
   * to, but not including @a end_offset.
   */
  Glib::ustring get_text(int start_offset, int end_offset) const;
  
  /** Gets the specified text.
   * 
   * @param offset A character offset within @a text.
   * @return The character at @a offset or 0 in the case of failure.
   */
  gunichar get_character_at_offset(int offset) const;
  
  
  /** Gets a portion of the text exposed through an Atk::Text according to a given @a offset
   * and a specific @a granularity, along with the start and end offsets defining the
   * boundaries of such a portion of text.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_CHAR the character at the
   * offset is returned.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_WORD the returned string
   * is from the word start at or before the offset to the word start after
   * the offset.
   * 
   * The returned string will contain the word at the offset if the offset
   * is inside a word and will contain the word before the offset if the
   * offset is not inside a word.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_SENTENCE the returned string
   * is from the sentence start at or before the offset to the sentence
   * start after the offset.
   * 
   * The returned string will contain the sentence at the offset if the offset
   * is inside a sentence and will contain the sentence before the offset
   * if the offset is not inside a sentence.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_LINE the returned string
   * is from the line start at or before the offset to the line
   * start after the offset.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_PARAGRAPH the returned string
   * is from the start of the paragraph at or before the offset to the start
   * of the following paragraph after the offset.
   * 
   * @newin{2,10}
   * 
   * @param offset Position.
   * @param granularity An Atk::TextGranularity.
   * @param start_offset The starting character offset of the returned string, or -1
   * in the case of error (e.g. invalid offset, not implemented).
   * @param end_offset The offset of the first character after the returned string,
   * or -1 in the case of error (e.g. invalid offset, not implemented).
   * @return A newly allocated string containing the text at
   * the @a offset bounded by the specified @a granularity.  Returns <tt>nullptr</tt> if the offset is invalid
   * or no implementation is available.
   */
  Glib::ustring get_string_at_offset(int offset, Granularity granularity, int& start_offset, int& end_offset);

  
  /** Gets the offset of the position of the caret (cursor).
   * 
   * @return The character offset of the position of the caret or -1 if
   * the caret is not located inside the element or in the case of
   * any other failure.
   */
  int get_caret_offset() const;
  
  /** If the extent can not be obtained (e.g.\ missing support), all of x, y, width,
   * height are set to -1.
   * 
   * Get the bounding box containing the glyph representing the character at 
   * a particular text offset.
   * 
   * @param offset The offset of the text character for which bounding information is required.
   * @param x Pointer for the x coordinate of the bounding box.
   * @param y Pointer for the y coordinate of the bounding box.
   * @param width Pointer for the width of the bounding box.
   * @param height Pointer for the height of the bounding box.
   * @param coords Specify whether coordinates are relative to the screen or widget window.
   */
  void get_character_extents(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;

 
  /** Creates an Atk::AttributeSet which consists of the attributes explicitly
   * set at the position @a offset in the text. @a start_offset and @a end_offset are
   * set to the start and end of the range around @a offset where the attributes are
   * invariant. See the enum AtkTextAttribute for types of text attributes that
   * can be returned. Note that other attributes may also be returned.
   * 
   * @param offset The offset at which to get the attributes.
   * @param start_offset The address to put the start offset of the range.
   * @param end_offset The address to put the end offset of the range.
   * @return An Atk::AttributeSet which contains the attributes explicitly set
   * at @a offset.
   */
  std::vector<Attribute> get_run_attributes(int offset, int& start_offset, int& end_offset) const;
  
  /** Creates an Atk::AttributeSet which consists of the default values of
   * attributes for the text. See the enum AtkTextAttribute for types of text
   * attributes that can be returned. Note that other attributes may also be
   * returned.
   * 
   * @return An Atk::AttributeSet which contains the default values of attributes.
   * at @a offset.
   */
  std::vector<Attribute> get_default_attributes() const;

  
  /** Gets the character count.
   * 
   * @return The number of characters or -1 in case of failure.
   */
  int get_character_count() const;
  
  /** Gets the offset of the character located at coordinates @a x and @a y. @a x and @a y
   * are interpreted as being relative to the screen or this widget's window
   * depending on @a coords.
   * 
   * @param x Screen x-position of character.
   * @param y Screen y-position of character.
   * @param coords Specify whether coordinates are relative to the screen or
   * widget window.
   * @return The offset to the character which is located at  the specified
   *  @a x and @a y coordinates of -1 in case of failure.
   */
  int get_offset_at_point(int x, int y, CoordType coords) const;
  
  /** Gets the number of selected regions.
   * 
   * @return The number of selected regions, or -1 in the case of failure.
   */
  int get_n_selections() const;
  
  /** Gets the text from the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset Passes back the starting character offset of the selected region.
   * @param end_offset Passes back the ending character offset (offset immediately past)
   * of the selected region.
   * @return A newly allocated string containing the selected text.
   */
  Glib::ustring get_selection(int selection_num, int& start_offset, int& end_offset) const;
  
  /** Adds a selection bounded by the specified offsets.
   * 
   * @param start_offset The starting character offset of the selected region.
   * @param end_offset The offset of the first character after the selected region.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool add_selection(int start_offset, int end_offset);
  
  /** Removes the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool remove_selection(int selection_num);
  
  /** Changes the start and end offset of the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset The new starting character offset of the selection.
   * @param end_offset The new end position of (e.g. offset immediately past) 
   * the selection.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool set_selection(int selection_num, int start_offset, int end_offset);
  
  /** Sets the caret (cursor) position to the specified @a offset.
   * 
   * In the case of rich-text content, this method should either grab focus
   * or move the sequential focus navigation starting point (if the application
   * supports this concept) as if the user had clicked on the new caret position.
   * Typically, this means that the target of this operation is the node containing
   * the new caret position or one of its ancestors. In other words, after this
   * method is called, if the user advances focus, it should move to the first
   * focusable node following the new caret position.
   * 
   * Calling this method should also scroll the application viewport in a way
   * that matches the behavior of the application's typical caret motion or tab
   * navigation as closely as possible. This also means that if the application's
   * caret motion or focus navigation does not trigger a scroll operation, this
   * method should not trigger one either. If the application does not have a caret
   * motion or focus navigation operation, this method should try to scroll the new
   * caret position into view while minimizing unnecessary scroll motion.
   * 
   * @param offset The character offset of the new caret position.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool set_caret_offset(int offset);

  typedef AtkTextRectangle Rectangle;

  
  /** Get the bounding box for text within the specified range.
   * 
   * If the extents can not be obtained (e.g. or missing support), the rectangle
   * fields are set to -1.
   * 
   * @newin{1,3}
   * 
   * @param start_offset The offset of the first text character for which boundary 
   * information is required.
   * @param end_offset The offset of the text character after the last character 
   * for which boundary information is required.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param rect A pointer to a AtkTextRectangle which is filled in by this function.
   */
  void get_range_extents(int start_offset, int end_offset, CoordType coord_type, Rectangle& rect);
  
  /** Get the ranges of text in the specified bounding box.
   * 
   * @newin{1,3}
   * 
   * @param rect An AtkTextRectangle giving the dimensions of the bounding box.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param x_clip_type Specify the horizontal clip type.
   * @param y_clip_type Specify the vertical clip type.
   * @return Array of AtkTextRange. The last
   * element of the array returned by this function will be <tt>nullptr</tt>.
   */
  AtkTextRange** get_bounded_ranges(const Rectangle& rect, CoordType coord_type, ClipType x_clip_type, ClipType y_clip_type);

  // AtkText::text-changed is deprecated in favor of text-insert and text-remove,
  // but code in gtk+/gtk/a11y still emits text-changed, 2019-07-23.
  // Deprecation of a signal probably means "don't emit" rather than "don't listen",
  // so let's keep it here.
  // Two no_default_handler because the wrapped C signals have no default handlers.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_changed(int position, int length)</tt>
   *
   * Flags: Run Last
   *
   * The "text-changed" signal is emitted when the text of the
   * object which implements the AtkText interface changes, This
   * signal will have a detail which is either "insert" or
   * "delete" which identifies whether the text change was an
   * insertion or a deletion.
   * 
   * Deprecated: 2.9.4: Use Atk::Object::signal_text_insert() or
   * Atk::Object::signal_text_remove() instead.
   * 
   * @param position The position (character offset) of the insertion or deletion.
   * @param length The length (in characters) of text inserted or deleted.
   */

  Glib::SignalProxyDetailed<void(int, int)> signal_text_changed(const Glib::ustring& insert_or_delete = {});

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_insert(int position, int length, const Glib::ustring& text)</tt>
   *
   * Flags: Run Last
   *
   * The "text-insert" signal is emitted when a new text is
   * inserted. If the signal was not triggered by the user
   * (e.g. typing or pasting text), the "system" detail should be
   * included.
   * 
   * @param position The position (character offset) of the insertion.
   * @param length The length (in characters) of text inserted.
   * @param text The new text inserted.
   */

  Glib::SignalProxyDetailed<void(int, int, const Glib::ustring&)> signal_text_insert(const Glib::ustring& system = {});

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_remove(int position, int length, const Glib::ustring& text)</tt>
   *
   * Flags: Run Last
   *
   * The "text-remove" signal is emitted when a new text is
   * removed. If the signal was not triggered by the user
   * (e.g. typing or pasting text), the "system" detail should be
   * included.
   * 
   * @param position The position (character offset) of the removal.
   * @param length The length (in characters) of text removed.
   * @param text The old text removed.
   */

  Glib::SignalProxyDetailed<void(int, int, const Glib::ustring&)> signal_text_remove(const Glib::ustring& system = {});

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_caret_moved(int location)</tt>
   *
   * Flags: Run Last
   *
   * The "text-caret-moved" signal is emitted when the caret
   * position of the text of an object which implements AtkText
   * changes.
   * 
   * @param location The new position of the text caret.
   */

  Glib::SignalProxy<void(int)> signal_text_caret_moved();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_selection_changed()</tt>
   *
   * Flags: Run Last
   *
   * The "text-selection-changed" signal is emitted when the
   * selected text of an object which implements AtkText changes.
   */

  Glib::SignalProxy<void()> signal_text_selection_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_attributes_changed()</tt>
   *
   * Flags: Run Last
   *
   * The "text-attributes-changed" signal is emitted when the text
   * attributes of the text of an object which implements AtkText
   * changes.
   */

  Glib::SignalProxy<void()> signal_text_attributes_changed();


protected:
 

    virtual Glib::ustring get_text_vfunc(int start_offset, int end_offset) const;

    virtual gunichar get_character_at_offset_vfunc(int offset) const;


  //_IGNORE_VFUNC(get_text_after_offset)
  //_IGNORE_VFUNC(get_text_at_offset)
  //_IGNORE_VFUNC(get_text_before_offset)

    virtual int get_caret_offset_vfunc() const;

    virtual void get_character_extents_vfunc(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;

    virtual AtkAttributeSet* get_run_attributes_vfunc(int offset, int& start_offset, int& end_offset) const;

    virtual AtkAttributeSet* get_default_attributes_vfunc() const;

    virtual int get_character_count_vfunc() const;

    virtual int get_offset_at_point_vfunc(int x, int y, CoordType coords) const;

    virtual int get_n_selections_vfunc() const;

    virtual Glib::ustring get_selection_vfunc(int selection_num, int& start_offset, int& end_offset) const;

    virtual bool add_selection_vfunc(int start_offset, int end_offset);

    virtual bool remove_selection_vfunc(int selection_num);

    virtual bool set_selection_vfunc(int selection_num, int start_offset, int end_offset);

    virtual bool set_caret_offset_vfunc(int offset);

  
  //TODO: Add get_range_extents(), and get_bounded_ranges() vfuncs when we can break ABI.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_text_changed().
  virtual void on_text_changed(int position, int length);
  /// This is a default handler for the signal signal_text_caret_moved().
  virtual void on_text_caret_moved(int location);
  /// This is a default handler for the signal signal_text_selection_changed().
  virtual void on_text_selection_changed();
  /// This is a default handler for the signal signal_text_attributes_changed().
  virtual void on_text_attributes_changed();


};

} // namespace Atk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::Text::ClipType> : public Glib::Value_Enum<Atk::Text::ClipType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::Text::Granularity> : public Glib::Value_Enum<Atk::Text::Granularity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Text
   */
  ATKMM_API
  Glib::RefPtr<Atk::Text> wrap(AtkText* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_TEXT_H */

