/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.model.erd.ERDUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDThemeSettings;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIActivator;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;

public class ERDGraphicalViewer
extends ScrollingGraphicalViewer
implements DBPEventListener {
    private static final Log log = Log.getLog(ERDGraphicalViewer.class);
    private final ERDEditorPart editor;
    private final ValidationMessageHandler messageHandler;
    private boolean loadContents = false;
    private final Map<DBPDataSourceContainer, DataSourceInfo> usedDataSources = new IdentityHashMap<DBPDataSourceContainer, DataSourceInfo>();

    public ERDGraphicalViewer(ERDEditorPart editor, ValidationMessageHandler messageHandler) {
        this.editor = editor;
        this.messageHandler = messageHandler;
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), MouseWheelZoomHandler.SINGLETON);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), MouseWheelHorizontalScrollHandler.SINGLETON);
    }

    public ERDEditorPart getEditor() {
        return this.editor;
    }

    public void setControl(Control control) {
        super.setControl(control);
        if (control != null) {
            ERDEditorAdapter.mapControl(control, this.editor);
            UIUtils.addFocusTracker((IServiceLocator)this.editor.getSite(), (String)"org.jkiss.dbeaver.erd.ERDEditor", (Control)control);
            ERDThemeSettings.instance.addPropertyListener("org.jkiss.dbeaver.erd.diagram.font", s -> this.applyThemeSettings(), control);
            this.applyThemeSettings();
        }
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.getControl() != null) {
            ERDEditorAdapter.unmapControl(this.getControl());
        }
        super.handleDispose(e);
    }

    public ValidationMessageHandler getValidationHandler() {
        return this.messageHandler;
    }

    protected void handleFocusLost(FocusEvent fe) {
        super.handleFocusLost(fe);
        this.messageHandler.reset();
    }

    private void applyThemeSettings() {
        this.getControl().setFont(ERDThemeSettings.instance.diagramFont);
        this.editor.refreshDiagram(true, false);
    }

    public void setContents(EditPart editpart) {
        this.loadContents = true;
        try {
            super.setContents(editpart);
            if (editpart instanceof DiagramPart) {
                DiagramPart diagramPart = (DiagramPart)editpart;
                ArrayList<DBSEntity> tables = new ArrayList<DBSEntity>();
                for (Object child : editpart.getChildren()) {
                    if (!(child instanceof EntityPart)) continue;
                    EntityPart entityPart = (EntityPart)child;
                    tables.add((DBSEntity)entityPart.getEntity().getObject());
                }
                DBRProgressMonitor monitor = this.editor.getDiagram().getMonitor();
                monitor.beginTask(ERDUIMessages.erd_job_rearrange_diagram, tables.size() + 2);
                tables.sort(DBUtils.nameComparator());
                LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>> toolMap = new LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>>();
                for (DBSEntity dBSEntity : tables) {
                    DBPDataSourceContainer container = dBSEntity.getDataSource().getContainer();
                    PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
                    if (drawer != null) {
                        ArrayList<ToolEntryTable> tools = (ArrayList<ToolEntryTable>)toolMap.get(drawer);
                        if (tools == null) {
                            tools = new ArrayList<ToolEntryTable>(tables.size());
                            toolMap.put(drawer, tools);
                        }
                        tools.add(new ToolEntryTable(dBSEntity));
                    }
                    monitor.worked(1);
                }
                monitor.subTask(ERDUIMessages.erd_job_set_diagram_palette);
                for (Map.Entry entry : toolMap.entrySet()) {
                    ArrayList paletteEntries = new ArrayList((Collection)entry.getValue());
                    ((PaletteDrawer)entry.getKey()).setChildren(paletteEntries);
                }
                monitor.worked(1);
                monitor.subTask(ERDUIMessages.erd_job_visuallize_content);
                diagramPart.getDiagram().getModelAdapter().handleContentChange(this.editor);
                monitor.worked(1);
            }
        }
        finally {
            this.loadContents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableActivate(DBSEntity table) {
        PaletteDrawer drawer;
        DBPDataSourceContainer container;
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    dataSourceInfo = new DataSourceInfo();
                    this.usedDataSources.put(container, dataSourceInfo);
                    this.acquireContainer(container);
                }
                ++dataSourceInfo.tableCount;
            }
        }
        if (!this.loadContents && (drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer())) != null) {
            List children = drawer.getChildren();
            int index = 0;
            int i = 0;
            int childrenSize = children.size();
            while (i < childrenSize) {
                Object child = children.get(i);
                if (child instanceof ToolEntryTable && ((ToolEntryTable)((Object)child)).table.getName().compareTo(table.getName()) > 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            drawer.add(index, (PaletteEntry)new ToolEntryTable(table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableDeactivate(DBSEntity table) {
        DBPDataSourceContainer container;
        PaletteDrawer drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer());
        if (drawer != null) {
            for (Object entry : drawer.getChildren()) {
                if (!(entry instanceof ToolEntryTable) || ((ToolEntryTable)((Object)entry)).table != table) continue;
                drawer.remove((PaletteEntry)((ToolEntryTable)((Object)entry)));
                break;
            }
        }
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    log.warn((Object)("Datasource '" + String.valueOf(container) + "' not registered in ERD viewer"));
                } else {
                    --dataSourceInfo.tableCount;
                    if (dataSourceInfo.tableCount <= 0) {
                        this.usedDataSources.remove(container);
                        this.releaseContainer(container);
                    }
                }
            }
        }
    }

    private void acquireContainer(DBPDataSourceContainer container) {
        container.acquire((DBPDataSourceTask)this.editor);
        container.getRegistry().addDataSourceListener((DBPEventListener)this);
        PaletteRoot paletteRoot = this.editor.getPaletteRoot();
        PaletteDrawer dsDrawer = new PaletteDrawer(container.getName(), DBeaverIcons.getImageDescriptor((DBPImage)container.getDriver().getIcon()));
        dsDrawer.setDescription(container.getDescription());
        dsDrawer.setId(container.getId());
        paletteRoot.add((PaletteEntry)dsDrawer);
    }

    private void releaseContainer(DBPDataSourceContainer container) {
        PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
        if (drawer != null) {
            this.editor.getPaletteRoot().remove((PaletteEntry)drawer);
        }
        container.getRegistry().removeDataSourceListener((DBPEventListener)this);
        container.release((DBPDataSourceTask)this.editor);
    }

    PaletteDrawer getContainerPaletteDrawer(DBPDataSourceContainer container) {
        for (Object child : this.editor.getPaletteRoot().getChildren()) {
            if (!(child instanceof PaletteDrawer) || !container.getId().equals(((PaletteDrawer)child).getId())) continue;
            return (PaletteDrawer)child;
        }
        return null;
    }

    public void handleDataSourceEvent(@NotNull DBPEvent event) {
        DBSEntity entity;
        DBSObject object = event.getObject();
        if (object == null || DBWorkbench.getPlatform().isShuttingDown()) {
            return;
        }
        if (object instanceof DBPDataSourceContainer) {
            this.handleDataSourceContainerChange(event, (DBPDataSourceContainer)object);
            return;
        }
        DBPEvent.Action action = event.getAction();
        if (action == DBPEvent.Action.OBJECT_SELECT || !this.usedDataSources.containsKey(object.getDataSource().getContainer())) {
            return;
        }
        DBSEntityAttribute entityAttribute = null;
        DBSEntityAssociation entityAssociation = null;
        if (object instanceof DBSEntityAttribute) {
            entityAttribute = (DBSEntityAttribute)object;
            entity = entityAttribute.getParentObject();
        } else if (object instanceof DBSEntity) {
            entity = (DBSEntity)object;
        } else if (object instanceof DBSEntityAssociation) {
            entityAssociation = (DBSEntityAssociation)object;
            entity = entityAssociation.getParentObject();
        } else {
            return;
        }
        EntityDiagram diagram = this.editor.getDiagram();
        switch (action) {
            case OBJECT_ADD: {
                boolean ownsObject;
                if (entityAttribute != null) {
                    ERDEntity erdEntity = diagram.getEntity(entity);
                    if (erdEntity == null) break;
                    UIUtils.asyncExec(() -> {
                        erdEntity.reloadAttributes((ERDDiagram)diagram);
                        erdEntity.firePropertyChange("CONTENTS", null, null);
                    });
                    break;
                }
                if (entityAssociation != null) {
                    ERDEntity erdEntity = diagram.getEntity(entity);
                    ERDEntity targetEntity = diagram.getEntity(entityAssociation.getAssociatedEntity());
                    DBSEntityAssociation addedAssociation = entityAssociation;
                    UIUtils.asyncExec(() -> {
                        if (erdEntity != null && erdEntity.getAssociation(addedAssociation) == null && erdEntity.getReferenceAssociation(addedAssociation) == null && erdEntity != null && targetEntity != null) {
                            ERDAssociation erdAssociation = new ERDAssociation(addedAssociation, erdEntity, targetEntity, true);
                            erdAssociation.resolveAttributes();
                        }
                    });
                    break;
                }
                DBSObject diagramContainer = (DBSObject)diagram.getObject();
                IEditorPart entityOwnerEditor = (IEditorPart)event.getOptions().get("activeEditor");
                ERDEditorPart erdOwnerEditor = this.getEditor();
                if (erdOwnerEditor.getSite() instanceof MultiPageEditorSite) {
                    erdOwnerEditor = ((MultiPageEditorSite)erdOwnerEditor.getSite()).getMultiPageEditor();
                }
                boolean bl = ownsObject = this.getEditor().getDiagram().isEditEnabled() && entityOwnerEditor != null && entityOwnerEditor == erdOwnerEditor;
                if (!ownsObject && diagramContainer != entity.getParentObject()) break;
                ERDEntity erdEntity = ERDUtils.makeEntityFromObject((DBRProgressMonitor)new VoidProgressMonitor(), (ERDDiagram)diagram, Collections.emptyList(), (DBSEntity)entity, null);
                UIUtils.asyncExec(() -> {
                    diagram.addEntity(erdEntity, true);
                    EntityPart entityPart = this.getEditor().getDiagramPart().getEntityPart(erdEntity);
                    if (entityPart != null) {
                        Display display = Display.getCurrent();
                        Point loc = display.getCursorLocation();
                        Point diagramLoc = this.getControl().toDisplay(0, 0);
                        loc.x -= diagramLoc.x;
                        loc.y -= diagramLoc.y;
                        Dimension size = entityPart.getFigure().getPreferredSize();
                        Rectangle curBounds = new Rectangle();
                        curBounds.width = size.width;
                        curBounds.height = size.height;
                        curBounds.x = loc.x;
                        curBounds.y = loc.y;
                        entityPart.modifyBounds(curBounds);
                        this.getEditor().setDirty(true);
                    }
                });
                break;
            }
            case OBJECT_REMOVE: {
                ERDEntity erdEntity = diagram.getEntity(entity);
                if (erdEntity == null) break;
                DBSEntityAttribute removedAttribute = entityAttribute;
                DBSEntityAssociation removedAssociation = entityAssociation;
                UIUtils.asyncExec(() -> {
                    if (removedAttribute != null) {
                        ERDEntityAttribute erdAttribute = erdEntity.getAttribute(removedAttribute);
                        if (erdAttribute != null) {
                            erdEntity.removeAttribute(erdAttribute, false);
                            erdEntity.firePropertyChange("CONTENTS", null, null);
                        }
                    } else if (removedAssociation != null) {
                        ERDAssociation erdAssociation = erdEntity.getAssociation(removedAssociation);
                        if (erdAssociation != null) {
                            ERDEntity refEntity;
                            erdEntity.removeAssociation(erdAssociation, true);
                            ERDElement eRDElement = erdAssociation.getTargetEntity();
                            if (eRDElement instanceof ERDEntity && (refEntity = (ERDEntity)eRDElement) != null) {
                                refEntity.removeReferenceAssociation(erdAssociation, true);
                            }
                        }
                    } else {
                        diagram.removeEntity(erdEntity, true);
                    }
                });
                break;
            }
            case OBJECT_UPDATE: {
                ERDEntity erdEntity = diagram.getEntity(entity);
                if (erdEntity == null) break;
                DBSEntityAttribute updatedAttribute = entityAttribute;
                DBSEntityAssociation updatedAssociation = entityAssociation;
                UIUtils.asyncExec(() -> {
                    if (updatedAttribute != null) {
                        ERDEntityAttribute erdAttribute = erdEntity.getAttribute(updatedAttribute);
                        if (erdAttribute != null) {
                            erdAttribute.firePropertyChange("NAME", null, (Object)updatedAttribute.getName());
                            erdEntity.firePropertyChange("SIZE", null, null);
                        }
                    } else if (updatedAssociation == null) {
                        erdEntity.reloadAttributes((ERDDiagram)diagram);
                        erdEntity.firePropertyChange("CONTENTS", null, null);
                    }
                });
            }
        }
    }

    private void autoLayoutEntity(EntityPart entityPart) {
        entityPart.getFigure().getBounds();
        DBPPreferenceStore prefStore = ERDUIActivator.getDefault().getPreferences();
        prefStore.getInt("erd.grid.width");
        prefStore.getInt("erd.grid.height");
    }

    private void handleDataSourceContainerChange(DBPEvent event, DBPDataSourceContainer container) {
        if (this.usedDataSources.containsKey(container) && event.getAction() == DBPEvent.Action.OBJECT_UPDATE && Boolean.FALSE.equals(event.getEnabled())) {
            UIUtils.asyncExec(() -> {
                IWorkbenchPartSite site = this.editor.getSite();
                if (site != null) {
                    site.getWorkbenchWindow();
                }
            });
        }
    }

    private static class DataSourceInfo {
        int tableCount = 0;

        private DataSourceInfo() {
        }
    }

    private static class MouseWheelHorizontalScrollHandler
    implements MouseWheelHandler {
        public static final MouseWheelHandler SINGLETON = new MouseWheelHorizontalScrollHandler();

        private MouseWheelHorizontalScrollHandler() {
        }

        public void handleMouseWheel(Event event, EditPartViewer viewer) {
            Control control;
            if (viewer instanceof ScrollingGraphicalViewer && (control = viewer.getControl()) instanceof FigureCanvas) {
                FigureCanvas canvas = (FigureCanvas)control;
                ScrollBar hBar = canvas.getHorizontalBar();
                canvas.scrollToX(hBar.getSelection() - hBar.getIncrement() * event.count);
                event.doit = false;
            }
        }
    }

    private static class ToolEntryTable
    extends ToolEntry {
        private final DBSEntity table;

        ToolEntryTable(DBSEntity table) {
            super(table.getName(), table.getDescription(), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE));
            this.setUserModificationPermission(1);
            this.setDescription(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.table = table;
        }

        public Tool createTool() {
            return new ToolSelectTable(this.table);
        }
    }

    public static class ToolSelectTable
    extends SelectionTool {
        private final DBSEntity table;

        ToolSelectTable(DBSEntity table) {
            this.table = table;
        }

        public void activate() {
            DefaultEditDomain editDomain = (DefaultEditDomain)this.getDomain();
            ERDEditorPart editorPart = (ERDEditorPart)editDomain.getEditorPart();
            GraphicalViewer viewer = editorPart.getViewer();
            for (EditPart child : editorPart.getDiagramPart().getChildren()) {
                if (!(child instanceof EntityPart) || ((EntityPart)child).getEntity().getObject() != this.table) continue;
                viewer.reveal(child);
                viewer.select(child);
                break;
            }
            super.activate();
        }
    }
}

