/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model.impl;

import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.model.AbstractModelProvider;
import org.graalvm.visualvm.jfr.model.impl.JfrModelImpl;
import org.graalvm.visualvm.tools.attach.AttachModel;
import org.graalvm.visualvm.tools.attach.AttachModelFactory;
import org.graalvm.visualvm.tools.jfr.JfrModel;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

public class JfrModelProvider
extends AbstractModelProvider<JfrModel, Application> {
    public JfrModel createModelFor(Application app) {
        JfrModelImpl jfr = JfrModelProvider.getJFRModel(app);
        if (jfr != null && jfr.isJfrAvailable()) {
            return jfr;
        }
        return null;
    }

    private static JfrModelImpl getJFRModel(Application app) {
        AttachModel attach = AttachModelFactory.getAttachFor((Application)app);
        if (attach != null) {
            return new JfrModelImpl(attach);
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            return new JfrModelImpl(jmxModel);
        }
        return null;
    }
}

