// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

export namespace std {

  using std::double_t _LIBCPP_USING_IF_EXISTS;
  using std::float_t _LIBCPP_USING_IF_EXISTS;

  using std::acos _LIBCPP_USING_IF_EXISTS;
  using std::acosf _LIBCPP_USING_IF_EXISTS;
  using std::acosl _LIBCPP_USING_IF_EXISTS;

  using std::asin _LIBCPP_USING_IF_EXISTS;
  using std::asinf _LIBCPP_USING_IF_EXISTS;
  using std::asinl _LIBCPP_USING_IF_EXISTS;

  using std::atan _LIBCPP_USING_IF_EXISTS;
  using std::atanf _LIBCPP_USING_IF_EXISTS;
  using std::atanl _LIBCPP_USING_IF_EXISTS;

  using std::atan2 _LIBCPP_USING_IF_EXISTS;
  using std::atan2f _LIBCPP_USING_IF_EXISTS;
  using std::atan2l _LIBCPP_USING_IF_EXISTS;

  using std::cos _LIBCPP_USING_IF_EXISTS;
  using std::cosf _LIBCPP_USING_IF_EXISTS;
  using std::cosl _LIBCPP_USING_IF_EXISTS;

  using std::sin _LIBCPP_USING_IF_EXISTS;
  using std::sinf _LIBCPP_USING_IF_EXISTS;
  using std::sinl _LIBCPP_USING_IF_EXISTS;

  using std::tan _LIBCPP_USING_IF_EXISTS;
  using std::tanf _LIBCPP_USING_IF_EXISTS;
  using std::tanl _LIBCPP_USING_IF_EXISTS;

  using std::acosh _LIBCPP_USING_IF_EXISTS;
  using std::acoshf _LIBCPP_USING_IF_EXISTS;
  using std::acoshl _LIBCPP_USING_IF_EXISTS;

  using std::asinh _LIBCPP_USING_IF_EXISTS;
  using std::asinhf _LIBCPP_USING_IF_EXISTS;
  using std::asinhl _LIBCPP_USING_IF_EXISTS;

  using std::atanh _LIBCPP_USING_IF_EXISTS;
  using std::atanhf _LIBCPP_USING_IF_EXISTS;
  using std::atanhl _LIBCPP_USING_IF_EXISTS;

  using std::cosh _LIBCPP_USING_IF_EXISTS;
  using std::coshf _LIBCPP_USING_IF_EXISTS;
  using std::coshl _LIBCPP_USING_IF_EXISTS;

  using std::sinh _LIBCPP_USING_IF_EXISTS;
  using std::sinhf _LIBCPP_USING_IF_EXISTS;
  using std::sinhl _LIBCPP_USING_IF_EXISTS;

  using std::tanh _LIBCPP_USING_IF_EXISTS;
  using std::tanhf _LIBCPP_USING_IF_EXISTS;
  using std::tanhl _LIBCPP_USING_IF_EXISTS;

  using std::exp _LIBCPP_USING_IF_EXISTS;
  using std::expf _LIBCPP_USING_IF_EXISTS;
  using std::expl _LIBCPP_USING_IF_EXISTS;

  using std::exp2 _LIBCPP_USING_IF_EXISTS;
  using std::exp2f _LIBCPP_USING_IF_EXISTS;
  using std::exp2l _LIBCPP_USING_IF_EXISTS;

  using std::expm1 _LIBCPP_USING_IF_EXISTS;
  using std::expm1f _LIBCPP_USING_IF_EXISTS;
  using std::expm1l _LIBCPP_USING_IF_EXISTS;

  using std::frexp _LIBCPP_USING_IF_EXISTS;
  using std::frexpf _LIBCPP_USING_IF_EXISTS;
  using std::frexpl _LIBCPP_USING_IF_EXISTS;

  using std::ilogb _LIBCPP_USING_IF_EXISTS;
  using std::ilogbf _LIBCPP_USING_IF_EXISTS;
  using std::ilogbl _LIBCPP_USING_IF_EXISTS;

  using std::ldexp _LIBCPP_USING_IF_EXISTS;
  using std::ldexpf _LIBCPP_USING_IF_EXISTS;
  using std::ldexpl _LIBCPP_USING_IF_EXISTS;

  using std::log _LIBCPP_USING_IF_EXISTS;
  using std::logf _LIBCPP_USING_IF_EXISTS;
  using std::logl _LIBCPP_USING_IF_EXISTS;

  using std::log10 _LIBCPP_USING_IF_EXISTS;
  using std::log10f _LIBCPP_USING_IF_EXISTS;
  using std::log10l _LIBCPP_USING_IF_EXISTS;

  using std::log1p _LIBCPP_USING_IF_EXISTS;
  using std::log1pf _LIBCPP_USING_IF_EXISTS;
  using std::log1pl _LIBCPP_USING_IF_EXISTS;

  using std::log2 _LIBCPP_USING_IF_EXISTS;
  using std::log2f _LIBCPP_USING_IF_EXISTS;
  using std::log2l _LIBCPP_USING_IF_EXISTS;

  using std::logb _LIBCPP_USING_IF_EXISTS;
  using std::logbf _LIBCPP_USING_IF_EXISTS;
  using std::logbl _LIBCPP_USING_IF_EXISTS;

  using std::modf _LIBCPP_USING_IF_EXISTS;
  using std::modff _LIBCPP_USING_IF_EXISTS;
  using std::modfl _LIBCPP_USING_IF_EXISTS;

  using std::scalbn _LIBCPP_USING_IF_EXISTS;
  using std::scalbnf _LIBCPP_USING_IF_EXISTS;
  using std::scalbnl _LIBCPP_USING_IF_EXISTS;

  using std::scalbln _LIBCPP_USING_IF_EXISTS;
  using std::scalblnf _LIBCPP_USING_IF_EXISTS;
  using std::scalblnl _LIBCPP_USING_IF_EXISTS;

  using std::cbrt _LIBCPP_USING_IF_EXISTS;
  using std::cbrtf _LIBCPP_USING_IF_EXISTS;
  using std::cbrtl _LIBCPP_USING_IF_EXISTS;

  // [c.math.abs], absolute values
  using std::abs _LIBCPP_USING_IF_EXISTS;

  using std::fabs _LIBCPP_USING_IF_EXISTS;
  using std::fabsf _LIBCPP_USING_IF_EXISTS;
  using std::fabsl _LIBCPP_USING_IF_EXISTS;

  using std::hypot _LIBCPP_USING_IF_EXISTS;
  using std::hypotf _LIBCPP_USING_IF_EXISTS;
  using std::hypotl _LIBCPP_USING_IF_EXISTS;

  // [c.math.hypot3], three-dimensional hypotenuse

  using std::pow _LIBCPP_USING_IF_EXISTS;
  using std::powf _LIBCPP_USING_IF_EXISTS;
  using std::powl _LIBCPP_USING_IF_EXISTS;

  using std::sqrt _LIBCPP_USING_IF_EXISTS;
  using std::sqrtf _LIBCPP_USING_IF_EXISTS;
  using std::sqrtl _LIBCPP_USING_IF_EXISTS;

  using std::erf _LIBCPP_USING_IF_EXISTS;
  using std::erff _LIBCPP_USING_IF_EXISTS;
  using std::erfl _LIBCPP_USING_IF_EXISTS;

  using std::erfc _LIBCPP_USING_IF_EXISTS;
  using std::erfcf _LIBCPP_USING_IF_EXISTS;
  using std::erfcl _LIBCPP_USING_IF_EXISTS;

  using std::lgamma _LIBCPP_USING_IF_EXISTS;
  using std::lgammaf _LIBCPP_USING_IF_EXISTS;
  using std::lgammal _LIBCPP_USING_IF_EXISTS;

  using std::tgamma _LIBCPP_USING_IF_EXISTS;
  using std::tgammaf _LIBCPP_USING_IF_EXISTS;
  using std::tgammal _LIBCPP_USING_IF_EXISTS;

  using std::ceil _LIBCPP_USING_IF_EXISTS;
  using std::ceilf _LIBCPP_USING_IF_EXISTS;
  using std::ceill _LIBCPP_USING_IF_EXISTS;

  using std::floor _LIBCPP_USING_IF_EXISTS;
  using std::floorf _LIBCPP_USING_IF_EXISTS;
  using std::floorl _LIBCPP_USING_IF_EXISTS;

  using std::nearbyint _LIBCPP_USING_IF_EXISTS;
  using std::nearbyintf _LIBCPP_USING_IF_EXISTS;
  using std::nearbyintl _LIBCPP_USING_IF_EXISTS;

  using std::rint _LIBCPP_USING_IF_EXISTS;
  using std::rintf _LIBCPP_USING_IF_EXISTS;
  using std::rintl _LIBCPP_USING_IF_EXISTS;

  using std::lrint _LIBCPP_USING_IF_EXISTS;
  using std::lrintf _LIBCPP_USING_IF_EXISTS;
  using std::lrintl _LIBCPP_USING_IF_EXISTS;

  using std::llrint _LIBCPP_USING_IF_EXISTS;
  using std::llrintf _LIBCPP_USING_IF_EXISTS;
  using std::llrintl _LIBCPP_USING_IF_EXISTS;

  using std::round _LIBCPP_USING_IF_EXISTS;
  using std::roundf _LIBCPP_USING_IF_EXISTS;
  using std::roundl _LIBCPP_USING_IF_EXISTS;

  using std::lround _LIBCPP_USING_IF_EXISTS;
  using std::lroundf _LIBCPP_USING_IF_EXISTS;
  using std::lroundl _LIBCPP_USING_IF_EXISTS;

  using std::llround _LIBCPP_USING_IF_EXISTS;
  using std::llroundf _LIBCPP_USING_IF_EXISTS;
  using std::llroundl _LIBCPP_USING_IF_EXISTS;

  using std::trunc _LIBCPP_USING_IF_EXISTS;
  using std::truncf _LIBCPP_USING_IF_EXISTS;
  using std::truncl _LIBCPP_USING_IF_EXISTS;

  using std::fmod _LIBCPP_USING_IF_EXISTS;
  using std::fmodf _LIBCPP_USING_IF_EXISTS;
  using std::fmodl _LIBCPP_USING_IF_EXISTS;

  using std::remainder _LIBCPP_USING_IF_EXISTS;
  using std::remainderf _LIBCPP_USING_IF_EXISTS;
  using std::remainderl _LIBCPP_USING_IF_EXISTS;

  using std::remquo _LIBCPP_USING_IF_EXISTS;
  using std::remquof _LIBCPP_USING_IF_EXISTS;
  using std::remquol _LIBCPP_USING_IF_EXISTS;

  using std::copysign _LIBCPP_USING_IF_EXISTS;
  using std::copysignf _LIBCPP_USING_IF_EXISTS;
  using std::copysignl _LIBCPP_USING_IF_EXISTS;

  using std::nan _LIBCPP_USING_IF_EXISTS;
  using std::nanf _LIBCPP_USING_IF_EXISTS;
  using std::nanl _LIBCPP_USING_IF_EXISTS;

  using std::nextafter _LIBCPP_USING_IF_EXISTS;
  using std::nextafterf _LIBCPP_USING_IF_EXISTS;
  using std::nextafterl _LIBCPP_USING_IF_EXISTS;

  using std::nexttoward _LIBCPP_USING_IF_EXISTS;
  using std::nexttowardf _LIBCPP_USING_IF_EXISTS;
  using std::nexttowardl _LIBCPP_USING_IF_EXISTS;

  using std::fdim _LIBCPP_USING_IF_EXISTS;
  using std::fdimf _LIBCPP_USING_IF_EXISTS;
  using std::fdiml _LIBCPP_USING_IF_EXISTS;

  using std::fmax _LIBCPP_USING_IF_EXISTS;
  using std::fmaxf _LIBCPP_USING_IF_EXISTS;
  using std::fmaxl _LIBCPP_USING_IF_EXISTS;

  using std::fmin _LIBCPP_USING_IF_EXISTS;
  using std::fminf _LIBCPP_USING_IF_EXISTS;
  using std::fminl _LIBCPP_USING_IF_EXISTS;

  using std::fma _LIBCPP_USING_IF_EXISTS;
  using std::fmaf _LIBCPP_USING_IF_EXISTS;
  using std::fmal _LIBCPP_USING_IF_EXISTS;

  // [c.math.lerp], linear interpolation
  using std::lerp _LIBCPP_USING_IF_EXISTS;

  // [c.math.fpclass], classification / comparison functions
  using std::fpclassify _LIBCPP_USING_IF_EXISTS;
  using std::isfinite _LIBCPP_USING_IF_EXISTS;
  using std::isgreater _LIBCPP_USING_IF_EXISTS;
  using std::isgreaterequal _LIBCPP_USING_IF_EXISTS;
  using std::isinf _LIBCPP_USING_IF_EXISTS;
  using std::isless _LIBCPP_USING_IF_EXISTS;
  using std::islessequal _LIBCPP_USING_IF_EXISTS;
  using std::islessgreater _LIBCPP_USING_IF_EXISTS;
  using std::isnan _LIBCPP_USING_IF_EXISTS;
  using std::isnormal _LIBCPP_USING_IF_EXISTS;
  using std::isunordered _LIBCPP_USING_IF_EXISTS;
  using std::signbit _LIBCPP_USING_IF_EXISTS;

  // [sf.cmath], mathematical special functions
#if 0
  // [sf.cmath.assoc.laguerre], associated Laguerre polynomials
  using std::assoc_laguerre;
  using std::assoc_laguerref;
  using std::assoc_laguerrel;

  // [sf.cmath.assoc.legendre], associated Legendre functions
  using std::assoc_legendre;
  using std::assoc_legendref;
  using std::assoc_legendrel;

  // [sf.cmath.beta], beta function
  using std::beta;
  using std::betaf;
  using std::betal;

  // [sf.cmath.comp.ellint.1], complete elliptic integral of the first kind
  using std::comp_ellint_1;
  using std::comp_ellint_1f;
  using std::comp_ellint_1l;

  // [sf.cmath.comp.ellint.2], complete elliptic integral of the second kind
  using std::comp_ellint_2;
  using std::comp_ellint_2f;
  using std::comp_ellint_2l;

  // [sf.cmath.comp.ellint.3], complete elliptic integral of the third kind
  using std::comp_ellint_3;
  using std::comp_ellint_3f;
  using std::comp_ellint_3l;

  // [sf.cmath.cyl.bessel.i], regular modified cylindrical Bessel functions
  using std::cyl_bessel_i;
  using std::cyl_bessel_if;
  using std::cyl_bessel_il;

  // [sf.cmath.cyl.bessel.j], cylindrical Bessel functions of the first kind
  using std::cyl_bessel_j;
  using std::cyl_bessel_jf;
  using std::cyl_bessel_jl;

  // [sf.cmath.cyl.bessel.k], irregular modified cylindrical Bessel functions
  using std::cyl_bessel_k;
  using std::cyl_bessel_kf;
  using std::cyl_bessel_kl;

  // [sf.cmath.cyl.neumann], cylindrical Neumann functions
  // cylindrical Bessel functions of the second kind
  using std::cyl_neumann;
  using std::cyl_neumannf;
  using std::cyl_neumannl;

  // [sf.cmath.ellint.1], incomplete elliptic integral of the first kind
  using std::ellint_1;
  using std::ellint_1f;
  using std::ellint_1l;

  // [sf.cmath.ellint.2], incomplete elliptic integral of the second kind
  using std::ellint_2;
  using std::ellint_2f;
  using std::ellint_2l;

  // [sf.cmath.ellint.3], incomplete elliptic integral of the third kind
  using std::ellint_3;
  using std::ellint_3f;
  using std::ellint_3l;

  // [sf.cmath.expint], exponential integral
  using std::expint;
  using std::expintf;
  using std::expintl;

  // [sf.cmath.hermite], Hermite polynomials
  using std::hermite;
  using std::hermitef;
  using std::hermitel;

  // [sf.cmath.laguerre], Laguerre polynomials
  using std::laguerre;
  using std::laguerref;
  using std::laguerrel;

  // [sf.cmath.legendre], Legendre polynomials
  using std::legendre;
  using std::legendref;
  using std::legendrel;

  // [sf.cmath.riemann.zeta], Riemann zeta function
  using std::riemann_zeta;
  using std::riemann_zetaf;
  using std::riemann_zetal;

  // [sf.cmath.sph.bessel], spherical Bessel functions of the first kind
  using std::sph_bessel;
  using std::sph_besself;
  using std::sph_bessell;

  // [sf.cmath.sph.legendre], spherical associated Legendre functions
  using std::sph_legendre;
  using std::sph_legendref;
  using std::sph_legendrel;

  // [sf.cmath.sph.neumann], spherical Neumann functions;
  // spherical Bessel functions of the second kind
  using std::sph_neumann;
  using std::sph_neumannf;
  using std::sph_neumannl;
#endif
} // namespace std
