// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_counting_guest
//
// (header) generated by ../mesa-25.3.1/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.1/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.1/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /tmp/pkg/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "vk_platform_compat.h"
#include "goldfish_vk_private_defs.h"


namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
void count_VkExtent2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtent2D* toCount,
    size_t* count);

void count_VkExtent3D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtent3D* toCount,
    size_t* count);

void count_VkOffset2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkOffset2D* toCount,
    size_t* count);

void count_VkOffset3D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkOffset3D* toCount,
    size_t* count);

void count_VkRect2D(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRect2D* toCount,
    size_t* count);

void count_VkBaseInStructure(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBaseInStructure* toCount,
    size_t* count);

void count_VkBaseOutStructure(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBaseOutStructure* toCount,
    size_t* count);

void count_VkBufferMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* toCount,
    size_t* count);

void count_VkDispatchIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* toCount,
    size_t* count);

void count_VkDrawIndexedIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* toCount,
    size_t* count);

void count_VkDrawIndirectCommand(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrawIndirectCommand* toCount,
    size_t* count);

void count_VkImageSubresourceRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresourceRange* toCount,
    size_t* count);

void count_VkImageMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryBarrier* toCount,
    size_t* count);

void count_VkMemoryBarrier(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryBarrier* toCount,
    size_t* count);

void count_VkPipelineCacheHeaderVersionOne(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* toCount,
    size_t* count);

void count_VkAllocationCallbacks(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAllocationCallbacks* toCount,
    size_t* count);

void count_VkApplicationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkApplicationInfo* toCount,
    size_t* count);

void count_VkFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties* toCount,
    size_t* count);

void count_VkImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatProperties* toCount,
    size_t* count);

void count_VkInstanceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkInstanceCreateInfo* toCount,
    size_t* count);

void count_VkMemoryHeap(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryHeap* toCount,
    size_t* count);

void count_VkMemoryType(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryType* toCount,
    size_t* count);

void count_VkPhysicalDeviceFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceLimits(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* toCount,
    size_t* count);

void count_VkPhysicalDeviceMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceSparseProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* toCount,
    size_t* count);

void count_VkQueueFamilyProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyProperties* toCount,
    size_t* count);

void count_VkDeviceQueueCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* toCount,
    size_t* count);

void count_VkDeviceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceCreateInfo* toCount,
    size_t* count);

void count_VkExtensionProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExtensionProperties* toCount,
    size_t* count);

void count_VkLayerProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkLayerProperties* toCount,
    size_t* count);

void count_VkSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubmitInfo* toCount,
    size_t* count);

void count_VkMappedMemoryRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMappedMemoryRange* toCount,
    size_t* count);

void count_VkMemoryAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* toCount,
    size_t* count);

void count_VkMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryRequirements* toCount,
    size_t* count);

void count_VkSparseMemoryBind(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseMemoryBind* toCount,
    size_t* count);

void count_VkSparseBufferMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* toCount,
    size_t* count);

void count_VkSparseImageOpaqueMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* toCount,
    size_t* count);

void count_VkImageSubresource(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresource* toCount,
    size_t* count);

void count_VkSparseImageMemoryBind(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* toCount,
    size_t* count);

void count_VkSparseImageMemoryBindInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* toCount,
    size_t* count);

void count_VkBindSparseInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindSparseInfo* toCount,
    size_t* count);

void count_VkSparseImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* toCount,
    size_t* count);

void count_VkSparseImageMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* toCount,
    size_t* count);

void count_VkFenceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFenceCreateInfo* toCount,
    size_t* count);

void count_VkSemaphoreCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* toCount,
    size_t* count);

void count_VkEventCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkEventCreateInfo* toCount,
    size_t* count);

void count_VkQueryPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* toCount,
    size_t* count);

void count_VkBufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCreateInfo* toCount,
    size_t* count);

void count_VkBufferViewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* toCount,
    size_t* count);

void count_VkImageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCreateInfo* toCount,
    size_t* count);

void count_VkSubresourceLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceLayout* toCount,
    size_t* count);

void count_VkComponentMapping(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkComponentMapping* toCount,
    size_t* count);

void count_VkImageViewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageViewCreateInfo* toCount,
    size_t* count);

void count_VkShaderModuleCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* toCount,
    size_t* count);

void count_VkPipelineCacheCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* toCount,
    size_t* count);

void count_VkSpecializationMapEntry(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSpecializationMapEntry* toCount,
    size_t* count);

void count_VkSpecializationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSpecializationInfo* toCount,
    size_t* count);

void count_VkPipelineShaderStageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* toCount,
    size_t* count);

void count_VkComputePipelineCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* toCount,
    size_t* count);

void count_VkVertexInputBindingDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* toCount,
    size_t* count);

void count_VkVertexInputAttributeDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* toCount,
    size_t* count);

void count_VkPipelineVertexInputStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineInputAssemblyStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineTessellationStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* toCount,
    size_t* count);

void count_VkViewport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkViewport* toCount,
    size_t* count);

void count_VkPipelineViewportStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineRasterizationStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineMultisampleStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* toCount,
    size_t* count);

void count_VkStencilOpState(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkStencilOpState* toCount,
    size_t* count);

void count_VkPipelineDepthStencilStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineColorBlendAttachmentState(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* toCount,
    size_t* count);

void count_VkPipelineColorBlendStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* toCount,
    size_t* count);

void count_VkPipelineDynamicStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* toCount,
    size_t* count);

void count_VkGraphicsPipelineCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* toCount,
    size_t* count);

void count_VkPushConstantRange(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushConstantRange* toCount,
    size_t* count);

void count_VkPipelineLayoutCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* toCount,
    size_t* count);

void count_VkSamplerCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerCreateInfo* toCount,
    size_t* count);

void count_VkCopyDescriptorSet(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyDescriptorSet* toCount,
    size_t* count);

void count_VkDescriptorBufferInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* toCount,
    size_t* count);

void count_VkDescriptorImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorImageInfo* toCount,
    size_t* count);

void count_VkDescriptorPoolSize(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolSize* toCount,
    size_t* count);

void count_VkDescriptorPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* toCount,
    size_t* count);

void count_VkDescriptorSetAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* toCount,
    size_t* count);

void count_VkDescriptorSetLayoutBinding(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* toCount,
    size_t* count);

void count_VkDescriptorSetLayoutCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* toCount,
    size_t* count);

void count_VkWriteDescriptorSet(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkWriteDescriptorSet* toCount,
    size_t* count);

void count_VkAttachmentDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescription* toCount,
    size_t* count);

void count_VkAttachmentReference(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReference* toCount,
    size_t* count);

void count_VkFramebufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* toCount,
    size_t* count);

void count_VkSubpassDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescription* toCount,
    size_t* count);

void count_VkSubpassDependency(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDependency* toCount,
    size_t* count);

void count_VkRenderPassCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* toCount,
    size_t* count);

void count_VkCommandPoolCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* toCount,
    size_t* count);

void count_VkCommandBufferAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* toCount,
    size_t* count);

void count_VkCommandBufferInheritanceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* toCount,
    size_t* count);

void count_VkCommandBufferBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* toCount,
    size_t* count);

void count_VkBufferCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCopy* toCount,
    size_t* count);

void count_VkImageSubresourceLayers(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresourceLayers* toCount,
    size_t* count);

void count_VkBufferImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferImageCopy* toCount,
    size_t* count);

void count_VkClearColorValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearColorValue* toCount,
    size_t* count);

void count_VkClearDepthStencilValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearDepthStencilValue* toCount,
    size_t* count);

void count_VkClearValue(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearValue* toCount,
    size_t* count);

void count_VkClearAttachment(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearAttachment* toCount,
    size_t* count);

void count_VkClearRect(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkClearRect* toCount,
    size_t* count);

void count_VkImageBlit(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageBlit* toCount,
    size_t* count);

void count_VkImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCopy* toCount,
    size_t* count);

void count_VkImageResolve(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageResolve* toCount,
    size_t* count);

void count_VkRenderPassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* toCount,
    size_t* count);

#endif
#ifdef VK_VERSION_1_1
void count_VkPhysicalDeviceSubgroupProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* toCount,
    size_t* count);

void count_VkBindBufferMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* toCount,
    size_t* count);

void count_VkBindImageMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* toCount,
    size_t* count);

void count_VkPhysicalDevice16BitStorageFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* toCount,
    size_t* count);

void count_VkMemoryDedicatedRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* toCount,
    size_t* count);

void count_VkMemoryDedicatedAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* toCount,
    size_t* count);

void count_VkMemoryAllocateFlagsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* toCount,
    size_t* count);

void count_VkDeviceGroupRenderPassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* toCount,
    size_t* count);

void count_VkDeviceGroupCommandBufferBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* toCount,
    size_t* count);

void count_VkDeviceGroupSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* toCount,
    size_t* count);

void count_VkDeviceGroupBindSparseInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* toCount,
    size_t* count);

void count_VkBindBufferMemoryDeviceGroupInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* toCount,
    size_t* count);

void count_VkBindImageMemoryDeviceGroupInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceGroupProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* toCount,
    size_t* count);

void count_VkDeviceGroupDeviceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* toCount,
    size_t* count);

void count_VkBufferMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* toCount,
    size_t* count);

void count_VkImageMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* toCount,
    size_t* count);

void count_VkImageSparseMemoryRequirementsInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* toCount,
    size_t* count);

void count_VkMemoryRequirements2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryRequirements2* toCount,
    size_t* count);

void count_VkSparseImageMemoryRequirements2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* toCount,
    size_t* count);

void count_VkPhysicalDeviceFeatures2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* toCount,
    size_t* count);

void count_VkPhysicalDeviceProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* toCount,
    size_t* count);

void count_VkFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties2* toCount,
    size_t* count);

void count_VkImageFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatProperties2* toCount,
    size_t* count);

void count_VkPhysicalDeviceImageFormatInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* toCount,
    size_t* count);

void count_VkQueueFamilyProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* toCount,
    size_t* count);

void count_VkPhysicalDeviceMemoryProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* toCount,
    size_t* count);

void count_VkSparseImageFormatProperties2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* toCount,
    size_t* count);

void count_VkPhysicalDeviceSparseImageFormatInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* toCount,
    size_t* count);

void count_VkPhysicalDevicePointClippingProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* toCount,
    size_t* count);

void count_VkInputAttachmentAspectReference(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* toCount,
    size_t* count);

void count_VkRenderPassInputAttachmentAspectCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* toCount,
    size_t* count);

void count_VkImageViewUsageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* toCount,
    size_t* count);

void count_VkPipelineTessellationDomainOriginStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* toCount,
    size_t* count);

void count_VkRenderPassMultiviewCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceMultiviewFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceMultiviewProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceVariablePointersFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* toCount,
    size_t* count);

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceVariablePointersFeatures, count_VkPhysicalDeviceVariablePointerFeatures)

void count_VkPhysicalDeviceProtectedMemoryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceProtectedMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* toCount,
    size_t* count);

void count_VkDeviceQueueInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* toCount,
    size_t* count);

void count_VkProtectedSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* toCount,
    size_t* count);

void count_VkSamplerYcbcrConversionCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* toCount,
    size_t* count);

void count_VkSamplerYcbcrConversionInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* toCount,
    size_t* count);

void count_VkBindImagePlaneMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* toCount,
    size_t* count);

void count_VkImagePlaneMemoryRequirementsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* toCount,
    size_t* count);

void count_VkSamplerYcbcrConversionImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* toCount,
    size_t* count);

void count_VkDescriptorUpdateTemplateEntry(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* toCount,
    size_t* count);

void count_VkDescriptorUpdateTemplateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* toCount,
    size_t* count);

void count_VkExternalMemoryProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceExternalImageFormatInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* toCount,
    size_t* count);

void count_VkExternalImageFormatProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceExternalBufferInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* toCount,
    size_t* count);

void count_VkExternalBufferProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalBufferProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceIDProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* toCount,
    size_t* count);

void count_VkExternalMemoryImageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* toCount,
    size_t* count);

void count_VkExternalMemoryBufferCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* toCount,
    size_t* count);

void count_VkExportMemoryAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceExternalFenceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* toCount,
    size_t* count);

void count_VkExternalFenceProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalFenceProperties* toCount,
    size_t* count);

void count_VkExportFenceCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* toCount,
    size_t* count);

void count_VkExportSemaphoreCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceExternalSemaphoreInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* toCount,
    size_t* count);

void count_VkExternalSemaphoreProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance3Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* toCount,
    size_t* count);

void count_VkDescriptorSetLayoutSupport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderDrawParametersFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* toCount,
    size_t* count);

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderDrawParametersFeatures, count_VkPhysicalDeviceShaderDrawParameterFeatures)

#endif
#ifdef VK_VERSION_1_2
void count_VkPhysicalDeviceVulkan11Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkan11Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkan12Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* toCount,
    size_t* count);

void count_VkConformanceVersion(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkConformanceVersion* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkan12Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* toCount,
    size_t* count);

void count_VkImageFormatListCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* toCount,
    size_t* count);

void count_VkAttachmentDescription2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescription2* toCount,
    size_t* count);

void count_VkAttachmentReference2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReference2* toCount,
    size_t* count);

void count_VkSubpassDescription2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescription2* toCount,
    size_t* count);

void count_VkSubpassDependency2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDependency2* toCount,
    size_t* count);

void count_VkRenderPassCreateInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* toCount,
    size_t* count);

void count_VkSubpassBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassBeginInfo* toCount,
    size_t* count);

void count_VkSubpassEndInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassEndInfo* toCount,
    size_t* count);

void count_VkPhysicalDevice8BitStorageFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceDriverProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderAtomicInt64Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderFloat16Int8Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceFloatControlsProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* toCount,
    size_t* count);

void count_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceDescriptorIndexingFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceDescriptorIndexingProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* toCount,
    size_t* count);

void count_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* toCount,
    size_t* count);

void count_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* toCount,
    size_t* count);

void count_VkSubpassDescriptionDepthStencilResolve(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* toCount,
    size_t* count);

void count_VkPhysicalDeviceDepthStencilResolveProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceScalarBlockLayoutFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* toCount,
    size_t* count);

void count_VkImageStencilUsageCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* toCount,
    size_t* count);

void count_VkSamplerReductionModeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkanMemoryModelFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceImagelessFramebufferFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* toCount,
    size_t* count);

void count_VkFramebufferAttachmentImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* toCount,
    size_t* count);

void count_VkFramebufferAttachmentsCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* toCount,
    size_t* count);

void count_VkRenderPassAttachmentBeginInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toCount,
    size_t* count);

void count_VkAttachmentReferenceStencilLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* toCount,
    size_t* count);

void count_VkAttachmentDescriptionStencilLayout(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* toCount,
    size_t* count);

void count_VkPhysicalDeviceHostQueryResetFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceTimelineSemaphoreFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceTimelineSemaphoreProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* toCount,
    size_t* count);

void count_VkSemaphoreTypeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* toCount,
    size_t* count);

void count_VkTimelineSemaphoreSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* toCount,
    size_t* count);

void count_VkSemaphoreWaitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* toCount,
    size_t* count);

void count_VkSemaphoreSignalInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceBufferDeviceAddressFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* toCount,
    size_t* count);

void count_VkBufferDeviceAddressInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* toCount,
    size_t* count);

void count_VkBufferOpaqueCaptureAddressCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* toCount,
    size_t* count);

void count_VkMemoryOpaqueCaptureAddressAllocateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* toCount,
    size_t* count);

void count_VkDeviceMemoryOpaqueCaptureAddressInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* toCount,
    size_t* count);

#endif
#ifdef VK_VERSION_1_3
void count_VkPhysicalDeviceVulkan13Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkan13Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* toCount,
    size_t* count);

void count_VkPipelineCreationFeedback(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* toCount,
    size_t* count);

void count_VkPipelineCreationFeedbackCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceToolProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toCount,
    size_t* count);

void count_VkPhysicalDevicePrivateDataFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* toCount,
    size_t* count);

void count_VkDevicePrivateDataCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* toCount,
    size_t* count);

void count_VkPrivateDataSlotCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* toCount,
    size_t* count);

void count_VkMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryBarrier2* toCount,
    size_t* count);

void count_VkBufferMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* toCount,
    size_t* count);

void count_VkImageMemoryBarrier2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* toCount,
    size_t* count);

void count_VkDependencyInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDependencyInfo* toCount,
    size_t* count);

void count_VkSemaphoreSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* toCount,
    size_t* count);

void count_VkCommandBufferSubmitInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* toCount,
    size_t* count);

void count_VkSubmitInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubmitInfo2* toCount,
    size_t* count);

void count_VkPhysicalDeviceSynchronization2Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceImageRobustnessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* toCount,
    size_t* count);

void count_VkBufferCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferCopy2* toCount,
    size_t* count);

void count_VkCopyBufferInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyBufferInfo2* toCount,
    size_t* count);

void count_VkImageCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCopy2* toCount,
    size_t* count);

void count_VkCopyImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageInfo2* toCount,
    size_t* count);

void count_VkBufferImageCopy2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferImageCopy2* toCount,
    size_t* count);

void count_VkCopyBufferToImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* toCount,
    size_t* count);

void count_VkCopyImageToBufferInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* toCount,
    size_t* count);

void count_VkImageBlit2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageBlit2* toCount,
    size_t* count);

void count_VkBlitImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBlitImageInfo2* toCount,
    size_t* count);

void count_VkImageResolve2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageResolve2* toCount,
    size_t* count);

void count_VkResolveImageInfo2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkResolveImageInfo2* toCount,
    size_t* count);

void count_VkPhysicalDeviceSubgroupSizeControlFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceSubgroupSizeControlProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* toCount,
    size_t* count);

void count_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceInlineUniformBlockFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceInlineUniformBlockProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* toCount,
    size_t* count);

void count_VkWriteDescriptorSetInlineUniformBlock(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* toCount,
    size_t* count);

void count_VkDescriptorPoolInlineUniformBlockCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toCount,
    size_t* count);

void count_VkRenderingAttachmentInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* toCount,
    size_t* count);

void count_VkRenderingInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingInfo* toCount,
    size_t* count);

void count_VkPipelineRenderingCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceDynamicRenderingFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* toCount,
    size_t* count);

void count_VkCommandBufferInheritanceRenderingInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderIntegerDotProductProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceTexelBufferAlignmentProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* toCount,
    size_t* count);

void count_VkFormatProperties3(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFormatProperties3* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance4Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance4Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* toCount,
    size_t* count);

void count_VkDeviceBufferMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* toCount,
    size_t* count);

void count_VkDeviceImageMemoryRequirements(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* toCount,
    size_t* count);

#endif
#ifdef VK_VERSION_1_4
void count_VkPhysicalDeviceVulkan14Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceVulkan14Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* toCount,
    size_t* count);

void count_VkDeviceQueueGlobalPriorityCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* toCount,
    size_t* count);

void count_VkQueueFamilyGlobalPriorityProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderFloatControls2Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceShaderExpectAssumeFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceLineRasterizationFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceLineRasterizationProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* toCount,
    size_t* count);

void count_VkPipelineRasterizationLineStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceVertexAttributeDivisorProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* toCount,
    size_t* count);

void count_VkVertexInputBindingDivisorDescription(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* toCount,
    size_t* count);

void count_VkPipelineVertexInputDivisorStateCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceIndexTypeUint8Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* toCount,
    size_t* count);

void count_VkMemoryMapInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryMapInfo* toCount,
    size_t* count);

void count_VkMemoryUnmapInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance5Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance5Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* toCount,
    size_t* count);

void count_VkRenderingAreaInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAreaInfo* toCount,
    size_t* count);

void count_VkImageSubresource2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageSubresource2* toCount,
    size_t* count);

void count_VkDeviceImageSubresourceInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* toCount,
    size_t* count);

void count_VkSubresourceLayout2(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceLayout2* toCount,
    size_t* count);

void count_VkPipelineCreateFlags2CreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* toCount,
    size_t* count);

void count_VkBufferUsageFlags2CreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDevicePushDescriptorProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* toCount,
    size_t* count);

void count_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toCount,
    size_t* count);

void count_VkRenderingAttachmentLocationInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* toCount,
    size_t* count);

void count_VkRenderingInputAttachmentIndexInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance6Features(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* toCount,
    size_t* count);

void count_VkPhysicalDeviceMaintenance6Properties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* toCount,
    size_t* count);

void count_VkBindMemoryStatus(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindMemoryStatus* toCount,
    size_t* count);

void count_VkBindDescriptorSetsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* toCount,
    size_t* count);

void count_VkPushConstantsInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushConstantsInfo* toCount,
    size_t* count);

void count_VkPushDescriptorSetInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* toCount,
    size_t* count);

void count_VkPushDescriptorSetWithTemplateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* toCount,
    size_t* count);

void count_VkPhysicalDevicePipelineProtectedAccessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* toCount,
    size_t* count);

void count_VkPhysicalDevicePipelineRobustnessFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* toCount,
    size_t* count);

void count_VkPhysicalDevicePipelineRobustnessProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* toCount,
    size_t* count);

void count_VkPipelineRobustnessCreateInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* toCount,
    size_t* count);

void count_VkPhysicalDeviceHostImageCopyFeatures(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* toCount,
    size_t* count);

void count_VkPhysicalDeviceHostImageCopyProperties(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* toCount,
    size_t* count);

void count_VkMemoryToImageCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkMemoryToImageCopy* toCount,
    size_t* count);

void count_VkImageToMemoryCopy(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageToMemoryCopy* toCount,
    size_t* count);

void count_VkCopyMemoryToImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* toCount,
    size_t* count);

void count_VkCopyImageToMemoryInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* toCount,
    size_t* count);

void count_VkCopyImageToImageInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* toCount,
    size_t* count);

void count_VkHostImageLayoutTransitionInfo(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* toCount,
    size_t* count);

void count_VkSubresourceHostMemcpySize(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* toCount,
    size_t* count);

void count_VkHostImageCopyDevicePerformanceQuery(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* toCount,
    size_t* count);

#endif
#ifdef VK_KHR_dynamic_rendering
DEFINE_ALIAS_FUNCTION(count_VkRenderingInfo, count_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkRenderingAttachmentInfo, count_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPipelineRenderingCreateInfo, count_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceDynamicRenderingFeatures, count_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkCommandBufferInheritanceRenderingInfo, count_VkCommandBufferInheritanceRenderingInfoKHR)

#endif
#ifdef VK_KHR_multiview
DEFINE_ALIAS_FUNCTION(count_VkRenderPassMultiviewCreateInfo, count_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMultiviewFeatures, count_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMultiviewProperties, count_VkPhysicalDeviceMultiviewPropertiesKHR)

#endif
#ifdef VK_KHR_get_physical_device_properties2
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceFeatures2, count_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceProperties2, count_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkFormatProperties2, count_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageFormatProperties2, count_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceImageFormatInfo2, count_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkQueueFamilyProperties2, count_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMemoryProperties2, count_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSparseImageFormatProperties2, count_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceSparseImageFormatInfo2, count_VkPhysicalDeviceSparseImageFormatInfo2KHR)

#endif
#ifdef VK_KHR_external_memory_capabilities
DEFINE_ALIAS_FUNCTION(count_VkExternalMemoryProperties, count_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceExternalImageFormatInfo, count_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExternalImageFormatProperties, count_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceExternalBufferInfo, count_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExternalBufferProperties, count_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceIDProperties, count_VkPhysicalDeviceIDPropertiesKHR)

#endif
#ifdef VK_KHR_external_memory
DEFINE_ALIAS_FUNCTION(count_VkExternalMemoryImageCreateInfo, count_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExternalMemoryBufferCreateInfo, count_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExportMemoryAllocateInfo, count_VkExportMemoryAllocateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_capabilities
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceExternalSemaphoreInfo, count_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExternalSemaphoreProperties, count_VkExternalSemaphorePropertiesKHR)

#endif
#ifdef VK_KHR_external_semaphore
DEFINE_ALIAS_FUNCTION(count_VkExportSemaphoreCreateInfo, count_VkExportSemaphoreCreateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_fd
void count_VkImportSemaphoreFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* toCount,
    size_t* count);

void count_VkSemaphoreGetFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* toCount,
    size_t* count);

#endif
#ifdef VK_KHR_shader_float16_int8
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderFloat16Int8Features, count_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderFloat16Int8Features, count_VkPhysicalDeviceFloat16Int8FeaturesKHR)

#endif
#ifdef VK_KHR_incremental_present
void count_VkRectLayerKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRectLayerKHR* toCount,
    size_t* count);

void count_VkPresentRegionKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPresentRegionKHR* toCount,
    size_t* count);

void count_VkPresentRegionsKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPresentRegionsKHR* toCount,
    size_t* count);

#endif
#ifdef VK_KHR_descriptor_update_template
DEFINE_ALIAS_FUNCTION(count_VkDescriptorUpdateTemplateEntry, count_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(count_VkDescriptorUpdateTemplateCreateInfo, count_VkDescriptorUpdateTemplateCreateInfoKHR)

#endif
#ifdef VK_KHR_imageless_framebuffer
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceImagelessFramebufferFeatures, count_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkFramebufferAttachmentsCreateInfo, count_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkFramebufferAttachmentImageInfo, count_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkRenderPassAttachmentBeginInfo, count_VkRenderPassAttachmentBeginInfoKHR)

#endif
#ifdef VK_KHR_create_renderpass2
DEFINE_ALIAS_FUNCTION(count_VkRenderPassCreateInfo2, count_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkAttachmentDescription2, count_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(count_VkAttachmentReference2, count_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSubpassDescription2, count_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSubpassDependency2, count_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSubpassBeginInfo, count_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkSubpassEndInfo, count_VkSubpassEndInfoKHR)

#endif
#ifdef VK_KHR_external_fence_capabilities
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceExternalFenceInfo, count_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkExternalFenceProperties, count_VkExternalFencePropertiesKHR)

#endif
#ifdef VK_KHR_external_fence
DEFINE_ALIAS_FUNCTION(count_VkExportFenceCreateInfo, count_VkExportFenceCreateInfoKHR)

#endif
#ifdef VK_KHR_external_fence_fd
void count_VkImportFenceFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* toCount,
    size_t* count);

void count_VkFenceGetFdInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* toCount,
    size_t* count);

#endif
#ifdef VK_KHR_maintenance2
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDevicePointClippingProperties, count_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkRenderPassInputAttachmentAspectCreateInfo, count_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkInputAttachmentAspectReference, count_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(count_VkImageViewUsageCreateInfo, count_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPipelineTessellationDomainOriginStateCreateInfo, count_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

#endif
#ifdef VK_KHR_dedicated_allocation
DEFINE_ALIAS_FUNCTION(count_VkMemoryDedicatedRequirements, count_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(count_VkMemoryDedicatedAllocateInfo, count_VkMemoryDedicatedAllocateInfoKHR)

#endif
#ifdef VK_KHR_get_memory_requirements2
DEFINE_ALIAS_FUNCTION(count_VkBufferMemoryRequirementsInfo2, count_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageMemoryRequirementsInfo2, count_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageSparseMemoryRequirementsInfo2, count_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkMemoryRequirements2, count_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSparseImageMemoryRequirements2, count_VkSparseImageMemoryRequirements2KHR)

#endif
#ifdef VK_KHR_image_format_list
DEFINE_ALIAS_FUNCTION(count_VkImageFormatListCreateInfo, count_VkImageFormatListCreateInfoKHR)

#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
DEFINE_ALIAS_FUNCTION(count_VkSamplerYcbcrConversionCreateInfo, count_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkSamplerYcbcrConversionInfo, count_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkBindImagePlaneMemoryInfo, count_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkImagePlaneMemoryRequirementsInfo, count_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceSamplerYcbcrConversionFeatures, count_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkSamplerYcbcrConversionImageFormatProperties, count_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

#endif
#ifdef VK_KHR_bind_memory2
DEFINE_ALIAS_FUNCTION(count_VkBindBufferMemoryInfo, count_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkBindImageMemoryInfo, count_VkBindImageMemoryInfoKHR)

#endif
#ifdef VK_KHR_maintenance3
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMaintenance3Properties, count_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkDescriptorSetLayoutSupport, count_VkDescriptorSetLayoutSupportKHR)

#endif
#ifdef VK_KHR_shader_subgroup_extended_types
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, count_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

#endif
#ifdef VK_KHR_global_priority
DEFINE_ALIAS_FUNCTION(count_VkDeviceQueueGlobalPriorityCreateInfo, count_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceGlobalPriorityQueryFeatures, count_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkQueueFamilyGlobalPriorityProperties, count_VkQueueFamilyGlobalPriorityPropertiesKHR)

#endif
#ifdef VK_KHR_vulkan_memory_model
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceVulkanMemoryModelFeatures, count_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

#endif
#ifdef VK_KHR_shader_terminate_invocation
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderTerminateInvocationFeatures, count_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

#endif
#ifdef VK_KHR_buffer_device_address
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceBufferDeviceAddressFeatures, count_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferDeviceAddressInfo, count_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferOpaqueCaptureAddressCreateInfo, count_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkMemoryOpaqueCaptureAddressAllocateInfo, count_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkDeviceMemoryOpaqueCaptureAddressInfo, count_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

#endif
#ifdef VK_KHR_pipeline_executable_properties
void count_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toCount,
    size_t* count);

void count_VkPipelineInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineInfoKHR* toCount,
    size_t* count);

void count_VkPipelineExecutablePropertiesKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* toCount,
    size_t* count);

void count_VkPipelineExecutableInfoKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* toCount,
    size_t* count);

void count_VkPipelineExecutableStatisticValueKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* toCount,
    size_t* count);

void count_VkPipelineExecutableStatisticKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* toCount,
    size_t* count);

void count_VkPipelineExecutableInternalRepresentationKHR(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* toCount,
    size_t* count);

#endif
#ifdef VK_KHR_shader_integer_dot_product
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderIntegerDotProductFeatures, count_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderIntegerDotProductProperties, count_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

#endif
#ifdef VK_KHR_synchronization2
DEFINE_ALIAS_FUNCTION(count_VkMemoryBarrier2, count_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferMemoryBarrier2, count_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageMemoryBarrier2, count_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(count_VkDependencyInfo, count_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkSubmitInfo2, count_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSemaphoreSubmitInfo, count_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkCommandBufferSubmitInfo, count_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceSynchronization2Features, count_VkPhysicalDeviceSynchronization2FeaturesKHR)

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, count_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

#endif
#ifdef VK_KHR_copy_commands2
DEFINE_ALIAS_FUNCTION(count_VkCopyBufferInfo2, count_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkCopyImageInfo2, count_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkCopyBufferToImageInfo2, count_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkCopyImageToBufferInfo2, count_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkBlitImageInfo2, count_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkResolveImageInfo2, count_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferCopy2, count_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageCopy2, count_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageBlit2, count_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferImageCopy2, count_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(count_VkImageResolve2, count_VkImageResolve2KHR)

#endif
#ifdef VK_KHR_format_feature_flags2
DEFINE_ALIAS_FUNCTION(count_VkFormatProperties3, count_VkFormatProperties3KHR)

#endif
#ifdef VK_KHR_maintenance4
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMaintenance4Features, count_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMaintenance4Properties, count_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkDeviceBufferMemoryRequirements, count_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(count_VkDeviceImageMemoryRequirements, count_VkDeviceImageMemoryRequirementsKHR)

#endif
#ifdef VK_KHR_maintenance5
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMaintenance5Features, count_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceMaintenance5Properties, count_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkRenderingAreaInfo, count_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkDeviceImageSubresourceInfo, count_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkImageSubresource2, count_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(count_VkSubresourceLayout2, count_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(count_VkPipelineCreateFlags2CreateInfo, count_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(count_VkBufferUsageFlags2CreateInfo, count_VkBufferUsageFlags2CreateInfoKHR)

#endif
#ifdef VK_KHR_line_rasterization
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceLineRasterizationFeatures, count_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceLineRasterizationProperties, count_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(count_VkPipelineRasterizationLineStateCreateInfo, count_VkPipelineRasterizationLineStateCreateInfoKHR)

#endif
#ifdef VK_ANDROID_native_buffer
void count_VkNativeBufferUsage2ANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* toCount,
    size_t* count);

void count_VkNativeBufferANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkNativeBufferANDROID* toCount,
    size_t* count);

void count_VkSwapchainImageCreateInfoANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* toCount,
    size_t* count);

void count_VkPhysicalDevicePresentationPropertiesANDROID(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_transform_feedback
void count_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* toCount,
    size_t* count);

void count_VkPipelineRasterizationStateStreamCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_texture_compression_astc_hdr
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, count_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

#endif
#ifdef VK_EXT_depth_clip_enable
void count_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* toCount,
    size_t* count);

void count_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_inline_uniform_block
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceInlineUniformBlockFeatures, count_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceInlineUniformBlockProperties, count_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(count_VkWriteDescriptorSetInlineUniformBlock, count_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(count_VkDescriptorPoolInlineUniformBlockCreateInfo, count_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

#endif
#ifdef VK_EXT_image_drm_format_modifier
void count_VkDrmFormatModifierPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* toCount,
    size_t* count);

void count_VkDrmFormatModifierPropertiesListEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toCount,
    size_t* count);

void count_VkImageDrmFormatModifierListCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* toCount,
    size_t* count);

void count_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* toCount,
    size_t* count);

void count_VkImageDrmFormatModifierPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* toCount,
    size_t* count);

void count_VkDrmFormatModifierProperties2EXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* toCount,
    size_t* count);

void count_VkDrmFormatModifierPropertiesList2EXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void count_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toCount,
    size_t* count);

DEFINE_ALIAS_FUNCTION(count_VkVertexInputBindingDivisorDescription, count_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(count_VkPipelineVertexInputDivisorStateCreateInfo, count_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceVertexAttributeDivisorFeatures, count_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

#endif
#ifdef VK_EXT_pipeline_creation_feedback
DEFINE_ALIAS_FUNCTION(count_VkPipelineCreationFeedbackCreateInfo, count_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkPipelineCreationFeedback, count_VkPipelineCreationFeedbackEXT)

#endif
#ifdef VK_EXT_fragment_density_map
void count_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toCount,
    size_t* count);

void count_VkRenderPassFragmentDensityMapCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* toCount,
    size_t* count);

void count_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_scalar_block_layout
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceScalarBlockLayoutFeatures, count_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

#endif
#ifdef VK_EXT_subgroup_size_control
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceSubgroupSizeControlFeatures, count_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceSubgroupSizeControlProperties, count_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, count_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

#endif
#ifdef VK_EXT_memory_budget
void count_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_tooling_info
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceToolProperties, count_VkPhysicalDeviceToolPropertiesEXT)

#endif
#ifdef VK_EXT_provoking_vertex
void count_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* toCount,
    size_t* count);

void count_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_line_rasterization
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceLineRasterizationFeatures, count_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceLineRasterizationProperties, count_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPipelineRasterizationLineStateCreateInfo, count_VkPipelineRasterizationLineStateCreateInfoEXT)

#endif
#ifdef VK_EXT_index_type_uint8
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceIndexTypeUint8Features, count_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

#endif
#ifdef VK_EXT_extended_dynamic_state
void count_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_host_image_copy
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceHostImageCopyFeatures, count_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceHostImageCopyProperties, count_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(count_VkMemoryToImageCopy, count_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(count_VkImageToMemoryCopy, count_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(count_VkCopyMemoryToImageInfo, count_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkCopyImageToMemoryInfo, count_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkCopyImageToImageInfo, count_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkHostImageLayoutTransitionInfo, count_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkSubresourceHostMemcpySize, count_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(count_VkHostImageCopyDevicePerformanceQuery, count_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(count_VkSubresourceLayout2, count_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(count_VkImageSubresource2, count_VkImageSubresource2EXT)

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, count_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

#endif
#ifdef VK_EXT_texel_buffer_alignment
void count_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toCount,
    size_t* count);

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceTexelBufferAlignmentProperties, count_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

#endif
#ifdef VK_EXT_device_memory_report
void count_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toCount,
    size_t* count);

void count_VkDeviceMemoryReportCallbackDataEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* toCount,
    size_t* count);

void count_VkDeviceDeviceMemoryReportCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_robustness2
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceRobustness2FeaturesKHR, count_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceRobustness2PropertiesKHR, count_VkPhysicalDeviceRobustness2PropertiesEXT)

#endif
#ifdef VK_EXT_custom_border_color
void count_VkSamplerCustomBorderColorCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_private_data
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDevicePrivateDataFeatures, count_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(count_VkDevicePrivateDataCreateInfo, count_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(count_VkPrivateDataSlotCreateInfo, count_VkPrivateDataSlotCreateInfoEXT)

#endif
#ifdef VK_EXT_pipeline_creation_cache_control
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDevicePipelineCreationCacheControlFeatures, count_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

#endif
#ifdef VK_EXT_graphics_pipeline_library
void count_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toCount,
    size_t* count);

void count_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toCount,
    size_t* count);

void count_VkGraphicsPipelineLibraryCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void count_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_image_robustness
DEFINE_ALIAS_FUNCTION(count_VkPhysicalDeviceImageRobustnessFeatures, count_VkPhysicalDeviceImageRobustnessFeaturesEXT)

#endif
#ifdef VK_EXT_image_compression_control
void count_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* toCount,
    size_t* count);

void count_VkImageCompressionControlEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* toCount,
    size_t* count);

void count_VkImageCompressionPropertiesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_4444_formats
void count_VkPhysicalDevice4444FormatsFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void count_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_extended_dynamic_state2
void count_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_color_write_enable
void count_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* toCount,
    size_t* count);

void count_VkPipelineColorWriteCreateInfoEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* toCount,
    size_t* count);

#endif
#ifdef VK_GOOGLE_gfxstream
void count_VkImportColorBufferGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* toCount,
    size_t* count);

void count_VkImportBufferGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* toCount,
    size_t* count);

void count_VkCreateBlobGOOGLE(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* toCount,
    size_t* count);

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void count_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    uint32_t featureBits,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toCount,
    size_t* count);

#endif
}  // namespace vk
}  // namespace gfxstream
